/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.shingle;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.EmptyTokenStream;
import org.apache.lucene.analysis.payloads.PayloadHelper;
import org.apache.lucene.index.Payload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShingleMatrixFilter
extends TokenStream {
    public static Character defaultSpacerCharacter = Character.valueOf('_');
    public static TokenSettingsCodec defaultSettingsCodec = new OneDimensionalNonWeightedTokenSettingsCodec();
    public static boolean ignoringSinglePrefixOrSuffixShingleByDefault = false;
    private TokenSettingsCodec settingsCodec;
    private int minimumShingleSize;
    private int maximumShingleSize;
    private boolean ignoringSinglePrefixOrSuffixShingle = false;
    private Character spacerCharacter = Character.valueOf('_');
    private TokenStream input;
    private Iterator<Matrix.Column.Row[]> permutations;
    private List<Token> currentPermuationTokens;
    private List<Matrix.Column.Row> currentPermutationRows;
    private int currentPermutationTokensStartOffset;
    private int currentShingleLength;
    private Set<List<Token>> shinglesSeen = new HashSet<List<Token>>();
    private Matrix matrix;
    private Token readColumnBuf;

    public ShingleMatrixFilter(Matrix matrix, int minimumShingleSize, int maximumShingleSize, Character spacerCharacter, boolean ignoringSinglePrefixOrSuffixShingle, TokenSettingsCodec settingsCodec) {
        this.matrix = matrix;
        this.minimumShingleSize = minimumShingleSize;
        this.maximumShingleSize = maximumShingleSize;
        this.spacerCharacter = spacerCharacter;
        this.ignoringSinglePrefixOrSuffixShingle = ignoringSinglePrefixOrSuffixShingle;
        this.settingsCodec = settingsCodec;
        this.input = new EmptyTokenStream();
    }

    public ShingleMatrixFilter(TokenStream input, int minimumShingleSize, int maximumShingleSize) {
        this(input, minimumShingleSize, maximumShingleSize, defaultSpacerCharacter);
    }

    public ShingleMatrixFilter(TokenStream input, int minimumShingleSize, int maximumShingleSize, Character spacerCharacter) {
        this(input, minimumShingleSize, maximumShingleSize, spacerCharacter, ignoringSinglePrefixOrSuffixShingleByDefault);
    }

    public ShingleMatrixFilter(TokenStream input, int minimumShingleSize, int maximumShingleSize, Character spacerCharacter, boolean ignoringSinglePrefixOrSuffixShingle) {
        this(input, minimumShingleSize, maximumShingleSize, spacerCharacter, ignoringSinglePrefixOrSuffixShingle, defaultSettingsCodec);
    }

    public ShingleMatrixFilter(TokenStream input, int minimumShingleSize, int maximumShingleSize, Character spacerCharacter, boolean ignoringSinglePrefixOrSuffixShingle, TokenSettingsCodec settingsCodec) {
        this.input = input;
        this.minimumShingleSize = minimumShingleSize;
        this.maximumShingleSize = maximumShingleSize;
        this.spacerCharacter = spacerCharacter;
        this.ignoringSinglePrefixOrSuffixShingle = ignoringSinglePrefixOrSuffixShingle;
        this.settingsCodec = settingsCodec;
    }

    public void reset() throws IOException {
        this.permutations = null;
        this.shinglesSeen.clear();
        this.input.reset();
    }

    public Token next(Token reusableToken) throws IOException {
        assert (reusableToken != null);
        if (this.matrix == null) {
            this.matrix = new Matrix();
            while (this.matrix.columns.size() < this.maximumShingleSize && this.readColumn()) {
            }
        }
        if (this.currentPermuationTokens != null) {
            ++this.currentShingleLength;
            if (this.currentShingleLength + this.currentPermutationTokensStartOffset <= this.currentPermuationTokens.size() && this.currentShingleLength <= this.maximumShingleSize) {
                if (this.ignoringSinglePrefixOrSuffixShingle && this.currentShingleLength == 1 && (this.currentPermutationRows.get(this.currentPermutationTokensStartOffset).getColumn().isFirst() || this.currentPermutationRows.get(this.currentPermutationTokensStartOffset).getColumn().isLast())) {
                    return this.next(reusableToken);
                }
                int termLength = 0;
                ArrayList<Token> shingle = new ArrayList<Token>();
                for (int i = 0; i < this.currentShingleLength; ++i) {
                    Token shingleToken = this.currentPermuationTokens.get(i + this.currentPermutationTokensStartOffset);
                    termLength += shingleToken.termLength();
                    shingle.add(shingleToken);
                }
                if (this.spacerCharacter != null) {
                    termLength += this.currentShingleLength - 1;
                }
                if (!this.shinglesSeen.add(shingle)) {
                    return this.next(reusableToken);
                }
                StringBuilder sb = new StringBuilder(termLength + 10);
                for (Token shingleToken : shingle) {
                    if (this.spacerCharacter != null && sb.length() > 0) {
                        sb.append(this.spacerCharacter);
                    }
                    sb.append(shingleToken.termBuffer(), 0, shingleToken.termLength());
                }
                reusableToken.setTermBuffer(sb.toString());
                this.updateToken(reusableToken, shingle, this.currentPermutationTokensStartOffset, this.currentPermutationRows, this.currentPermuationTokens);
                return reusableToken;
            }
            if (this.currentPermutationTokensStartOffset < this.currentPermuationTokens.size() - 1) {
                ++this.currentPermutationTokensStartOffset;
                this.currentShingleLength = this.minimumShingleSize - 1;
                return this.next(reusableToken);
            }
            if (this.permutations == null) {
                return null;
            }
            if (!this.permutations.hasNext()) {
                if (this.input == null || this.readColumn()) {
                    // empty if block
                }
                Matrix.Column deletedColumn = (Matrix.Column)this.matrix.columns.remove(0);
                ArrayList<Token> deletedColumnTokens = new ArrayList<Token>();
                for (Matrix.Column.Row row : deletedColumn.getRows()) {
                    for (Token shingleToken : row.getTokens()) {
                        deletedColumnTokens.add(shingleToken);
                    }
                }
                Iterator<List<Token>> shinglesSeenIterator = this.shinglesSeen.iterator();
                block5: while (shinglesSeenIterator.hasNext()) {
                    List<Token> shingle = shinglesSeenIterator.next();
                    for (Token deletedColumnToken : deletedColumnTokens) {
                        if (!shingle.contains(deletedColumnToken)) continue;
                        shinglesSeenIterator.remove();
                        continue block5;
                    }
                }
                if (this.matrix.columns.size() < this.minimumShingleSize) {
                    return null;
                }
                this.permutations = this.matrix.permutationIterator();
            }
            this.nextTokensPermutation();
            return this.next(reusableToken);
        }
        if (this.permutations == null) {
            this.permutations = this.matrix.permutationIterator();
        }
        if (!this.permutations.hasNext()) {
            return null;
        }
        this.nextTokensPermutation();
        return this.next(reusableToken);
    }

    private void nextTokensPermutation() {
        Matrix.Column.Row[] rowsPermutation = this.permutations.next();
        ArrayList<Matrix.Column.Row> currentPermutationRows = new ArrayList<Matrix.Column.Row>();
        ArrayList<Token> currentPermuationTokens = new ArrayList<Token>();
        for (Matrix.Column.Row row : rowsPermutation) {
            for (Token shingleToken : row.getTokens()) {
                currentPermuationTokens.add(shingleToken);
                currentPermutationRows.add(row);
            }
        }
        this.currentPermuationTokens = currentPermuationTokens;
        this.currentPermutationRows = currentPermutationRows;
        this.currentPermutationTokensStartOffset = 0;
        this.currentShingleLength = this.minimumShingleSize - 1;
    }

    public void updateToken(Token token, List<Token> shingle, int currentPermutationStartOffset, List<Matrix.Column.Row> currentPermutationRows, List<Token> currentPermuationTokens) {
        token.setType(ShingleMatrixFilter.class.getSimpleName());
        token.setFlags(0);
        token.setPositionIncrement(1);
        token.setStartOffset(shingle.get(0).startOffset());
        token.setEndOffset(shingle.get(shingle.size() - 1).endOffset());
        this.settingsCodec.setWeight(token, this.calculateShingleWeight(token, shingle, currentPermutationStartOffset, currentPermutationRows, currentPermuationTokens));
    }

    public float calculateShingleWeight(Token shingleToken, List<Token> shingle, int currentPermutationStartOffset, List<Matrix.Column.Row> currentPermutationRows, List<Token> currentPermuationTokens) {
        double[] weights = new double[shingle.size()];
        double total = 0.0;
        double top = 0.0;
        for (int i = 0; i < weights.length; ++i) {
            weights[i] = this.settingsCodec.getWeight(shingle.get(i));
            double tmp = weights[i];
            if (tmp > top) {
                top = tmp;
            }
            total += tmp;
        }
        double factor = 1.0 / Math.sqrt(total);
        double weight = 0.0;
        for (double partWeight : weights) {
            weight += partWeight * factor;
        }
        return (float)weight;
    }

    private boolean readColumn() throws IOException {
        TokenPositioner tokenPositioner;
        Token token;
        if (this.readColumnBuf != null) {
            token = this.readColumnBuf;
            this.readColumnBuf = null;
        } else {
            token = this.input.next(new Token());
        }
        if (token == null) {
            return false;
        }
        Matrix.Column currentReaderColumn = this.matrix.new Matrix.Column();
        Matrix.Column.Row currentReaderRow = currentReaderColumn.new Matrix.Column.Row();
        currentReaderRow.getTokens().add(token);
        while ((this.readColumnBuf = this.input.next(new Token())) != null && (tokenPositioner = this.settingsCodec.getTokenPositioner(this.readColumnBuf)) != TokenPositioner.newColumn) {
            if (tokenPositioner == TokenPositioner.sameRow) {
                currentReaderRow.getTokens().add(this.readColumnBuf);
            } else {
                currentReaderRow = currentReaderColumn.new Matrix.Column.Row();
                currentReaderRow.getTokens().add(this.readColumnBuf);
            }
            this.readColumnBuf = null;
        }
        if (this.readColumnBuf == null) {
            this.readColumnBuf = this.input.next(new Token());
            if (this.readColumnBuf == null) {
                currentReaderColumn.setLast(true);
            }
        }
        return true;
    }

    public int getMinimumShingleSize() {
        return this.minimumShingleSize;
    }

    public void setMinimumShingleSize(int minimumShingleSize) {
        this.minimumShingleSize = minimumShingleSize;
    }

    public int getMaximumShingleSize() {
        return this.maximumShingleSize;
    }

    public void setMaximumShingleSize(int maximumShingleSize) {
        this.maximumShingleSize = maximumShingleSize;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public void setMatrix(Matrix matrix) {
        this.matrix = matrix;
    }

    public Character getSpacerCharacter() {
        return this.spacerCharacter;
    }

    public void setSpacerCharacter(Character spacerCharacter) {
        this.spacerCharacter = spacerCharacter;
    }

    public boolean isIgnoringSinglePrefixOrSuffixShingle() {
        return this.ignoringSinglePrefixOrSuffixShingle;
    }

    public void setIgnoringSinglePrefixOrSuffixShingle(boolean ignoringSinglePrefixOrSuffixShingle) {
        this.ignoringSinglePrefixOrSuffixShingle = ignoringSinglePrefixOrSuffixShingle;
    }

    public static class SimpleThreeDimensionalTokenSettingsCodec
    extends TokenSettingsCodec {
        public TokenPositioner getTokenPositioner(Token token) throws IOException {
            switch (token.getFlags()) {
                case 0: {
                    return TokenPositioner.newColumn;
                }
                case 1: {
                    return TokenPositioner.newRow;
                }
                case 2: {
                    return TokenPositioner.sameRow;
                }
            }
            throw new IOException("Unknown matrix positioning of token " + token);
        }

        public void setTokenPositioner(Token token, TokenPositioner tokenPositioner) {
            token.setFlags(tokenPositioner.getIndex());
        }

        public float getWeight(Token token) {
            if (token.getPayload() == null || token.getPayload().getData() == null) {
                return 1.0f;
            }
            return PayloadHelper.decodeFloat(token.getPayload().getData());
        }

        public void setWeight(Token token, float weight) {
            if (weight == 1.0f) {
                token.setPayload(null);
            } else {
                token.setPayload(new Payload(PayloadHelper.encodeFloat(weight)));
            }
        }
    }

    public static class TwoDimensionalNonWeightedSynonymTokenSettingsCodec
    extends TokenSettingsCodec {
        public TokenPositioner getTokenPositioner(Token token) throws IOException {
            if (token.getPositionIncrement() == 0) {
                return TokenPositioner.newRow;
            }
            return TokenPositioner.newColumn;
        }

        public void setTokenPositioner(Token token, TokenPositioner tokenPositioner) {
            throw new UnsupportedOperationException();
        }

        public float getWeight(Token token) {
            return 1.0f;
        }

        public void setWeight(Token token, float weight) {
        }
    }

    public static class OneDimensionalNonWeightedTokenSettingsCodec
    extends TokenSettingsCodec {
        public TokenPositioner getTokenPositioner(Token token) throws IOException {
            return TokenPositioner.newColumn;
        }

        public void setTokenPositioner(Token token, TokenPositioner tokenPositioner) {
        }

        public float getWeight(Token token) {
            return 1.0f;
        }

        public void setWeight(Token token, float weight) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Matrix {
        private boolean columnsHasBeenCreated = false;
        private List<Column> columns = new ArrayList<Column>();

        public List<Column> getColumns() {
            return this.columns;
        }

        public Iterator<Column.Row[]> permutationIterator() {
            return new Iterator<Column.Row[]>(){
                private int[] columnRowCounters;
                {
                    this.columnRowCounters = new int[Matrix.this.columns.size()];
                }

                @Override
                public void remove() {
                    throw new IllegalStateException("not implemented");
                }

                @Override
                public boolean hasNext() {
                    int s = this.columnRowCounters.length;
                    return s != 0 && this.columnRowCounters[s - 1] < ((Column)Matrix.this.columns.get(s - 1)).getRows().size();
                }

                @Override
                public Column.Row[] next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException("no more elements");
                    }
                    Column.Row[] rows = new Column.Row[this.columnRowCounters.length];
                    for (int i = 0; i < this.columnRowCounters.length; ++i) {
                        rows[i] = (Column.Row)((Column)Matrix.this.columns.get(i)).rows.get(this.columnRowCounters[i]);
                    }
                    this.incrementColumnRowCounters();
                    return rows;
                }

                private void incrementColumnRowCounters() {
                    for (int i = 0; i < this.columnRowCounters.length; ++i) {
                        int n = i;
                        this.columnRowCounters[n] = this.columnRowCounters[n] + 1;
                        if (this.columnRowCounters[i] != ((Column)Matrix.this.columns.get(i)).rows.size() || i >= this.columnRowCounters.length - 1) break;
                        this.columnRowCounters[i] = 0;
                    }
                }
            };
        }

        public String toString() {
            return "Matrix{columns=" + this.columns + '}';
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Column {
            private boolean last;
            private boolean first;
            private List<Row> rows = new ArrayList<Row>();

            public Matrix getMatrix() {
                return Matrix.this;
            }

            public Column(Token token) {
                this();
                Row row = new Row();
                row.getTokens().add(token);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Column() {
                Matrix matrix2 = Matrix.this;
                synchronized (matrix2) {
                    if (!Matrix.this.columnsHasBeenCreated) {
                        this.setFirst(true);
                        Matrix.this.columnsHasBeenCreated = true;
                    }
                }
                Matrix.this.columns.add(this);
            }

            public List<Row> getRows() {
                return this.rows;
            }

            public int getIndex() {
                return Matrix.this.columns.indexOf(this);
            }

            public String toString() {
                return "Column{first=" + this.first + ", last=" + this.last + ", rows=" + this.rows + '}';
            }

            public boolean isFirst() {
                return this.first;
            }

            public void setFirst(boolean first) {
                this.first = first;
            }

            public void setLast(boolean last) {
                this.last = last;
            }

            public boolean isLast() {
                return this.last;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Row {
                private List<Token> tokens = new LinkedList<Token>();

                public Column getColumn() {
                    return Column.this;
                }

                public Row() {
                    Column.this.rows.add(this);
                }

                public int getIndex() {
                    return Column.this.rows.indexOf(this);
                }

                public List<Token> getTokens() {
                    return this.tokens;
                }

                public void setTokens(List<Token> tokens) {
                    this.tokens = tokens;
                }

                public String toString() {
                    return "Row{index=" + this.getIndex() + ", tokens=" + (this.tokens == null ? null : Arrays.asList(this.tokens)) + '}';
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TokenPositioner {
        newColumn(0),
        newRow(1),
        sameRow(2);

        private final int index;

        private TokenPositioner(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static abstract class TokenSettingsCodec {
        public abstract TokenPositioner getTokenPositioner(Token var1) throws IOException;

        public abstract void setTokenPositioner(Token var1, TokenPositioner var2);

        public abstract float getWeight(Token var1);

        public abstract void setWeight(Token var1, float var2);
    }
}

