/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.charset;

import com.ibm.icu.charset.CharsetDecoderICU;
import com.ibm.icu.charset.CharsetEncoderICU;
import com.ibm.icu.charset.CharsetICU;
import com.ibm.icu.text.UTF16;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

class CharsetUTF32
extends CharsetICU {
    protected byte[] fromUSubstitution = new byte[]{0, 0, -1, -3};
    protected int bom;

    public CharsetUTF32(String icuCanonicalName, String javaCanonicalName, String[] aliases) {
        super(icuCanonicalName, javaCanonicalName, aliases);
        this.maxBytesPerChar = 4;
        this.minBytesPerChar = 4;
        this.maxCharsPerByte = 1.0f;
        this.bom = 0;
    }

    public CharsetDecoder newDecoder() {
        return new CharsetDecoderUTF32(this);
    }

    public CharsetEncoder newEncoder() {
        return new CharsetEncoderUTF32(this);
    }

    class CharsetEncoderUTF32
    extends CharsetEncoderICU {
        public CharsetEncoderUTF32(CharsetICU cs) {
            super(cs, CharsetUTF32.this.fromUSubstitution);
            this.implReset();
            this.writeBOM = true;
        }

        protected void implReset() {
            super.implReset();
            this.fromUnicodeStatus = 1;
        }

        /*
         * Enabled aggressive block sorting
         */
        protected CoderResult encodeLoop(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            int indexToWrite;
            char ch2;
            CoderResult cr = CoderResult.UNDERFLOW;
            if (!source.hasRemaining()) {
                return cr;
            }
            if (this.fromUnicodeStatus == 1 && this.writeBOM) {
                byte[] bom = new byte[]{0, 0, -2, -1};
                cr = CharsetEncoderUTF32.fromUWriteBytes(this, bom, 0, bom.length, target, offsets, -1);
                if (cr.isError() || cr.isOverflow()) {
                    return cr;
                }
                this.fromUnicodeStatus = 0;
            }
            byte[] temp = new byte[4];
            temp[0] = 0;
            int sourceArrayIndex = source.position();
            boolean doloop = true;
            if (this.fromUChar32 != 0) {
                int ch = this.fromUChar32;
                this.fromUChar32 = 0;
                if (sourceArrayIndex < source.limit()) {
                    ch2 = source.get(sourceArrayIndex);
                    if (UTF16.isTrailSurrogate((char)ch2)) {
                        ch = (ch - 55296 << 10) + ch2 + 9216;
                        ++sourceArrayIndex;
                    } else {
                        this.fromUChar32 = ch;
                        cr = CoderResult.malformedForLength(sourceArrayIndex);
                        doloop = false;
                    }
                } else {
                    this.fromUChar32 = ch;
                    if (flush) {
                        cr = CoderResult.malformedForLength(sourceArrayIndex);
                    }
                    doloop = false;
                }
                temp[1] = (byte)(ch >>> 16 & 0x1F);
                temp[2] = (byte)(ch >>> 8);
                temp[3] = (byte)ch;
                for (indexToWrite = 0; indexToWrite <= 3; ++indexToWrite) {
                    if (target.hasRemaining()) {
                        target.put(temp[indexToWrite]);
                        continue;
                    }
                    this.errorBuffer[this.errorBufferLength++] = temp[indexToWrite];
                    cr = CoderResult.OVERFLOW;
                }
            }
            if (doloop) {
                while (sourceArrayIndex < source.limit() && target.hasRemaining()) {
                    int ch;
                    block22: {
                        if (UTF16.isSurrogate((char)((char)(ch = source.get(sourceArrayIndex++))))) {
                            if (UTF16.isLeadSurrogate((char)((char)ch))) {
                                if (sourceArrayIndex < source.limit()) {
                                    ch2 = source.get(sourceArrayIndex);
                                    if (UTF16.isTrailSurrogate((char)ch2)) {
                                        ch = (ch - 55296 << 10) + ch2 + 9216;
                                        ++sourceArrayIndex;
                                        break block22;
                                    } else {
                                        this.fromUChar32 = ch;
                                        cr = CoderResult.OVERFLOW;
                                        break;
                                    }
                                }
                                this.fromUChar32 = ch;
                                if (!flush) break;
                                cr = CoderResult.malformedForLength(sourceArrayIndex);
                                break;
                            }
                            this.fromUChar32 = ch;
                            cr = CoderResult.malformedForLength(sourceArrayIndex);
                            break;
                        }
                    }
                    temp[1] = (byte)(ch >>> 16 & 0x1F);
                    temp[2] = (byte)(ch >>> 8);
                    temp[3] = (byte)ch;
                    for (indexToWrite = 0; indexToWrite <= 3; ++indexToWrite) {
                        if (target.hasRemaining()) {
                            target.put(temp[indexToWrite]);
                            continue;
                        }
                        this.errorBuffer[this.errorBufferLength++] = temp[indexToWrite];
                        cr = CoderResult.OVERFLOW;
                    }
                }
            }
            if (sourceArrayIndex < source.limit() && !target.hasRemaining()) {
                cr = CoderResult.OVERFLOW;
            }
            source.position(sourceArrayIndex);
            return cr;
        }
    }

    class CharsetDecoderUTF32
    extends CharsetDecoderICU {
        boolean isFirstBuffer = true;
        final int SIGNATURE_LENGTH = 4;

        public CharsetDecoderUTF32(CharsetICU cs) {
            super(cs);
        }

        protected CoderResult decodeLoop(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            int offsetsPos = offsets == null ? 0 : offsets.position();
            CoderResult cr = CoderResult.UNDERFLOW;
            int state = this.mode;
            int offsetDelta = 0;
            int pos = source.position();
            if (this.isFirstBuffer && this.toULength < 4 && source.remaining() >= 4) {
                while (pos < source.limit() && pos < 4) {
                    this.toUBytesArray[this.toULength++] = source.get(pos++);
                }
                if (this.toULength == 4) {
                    if (this.toUBytesArray[0] == 0 && this.toUBytesArray[1] == 0 && this.toUBytesArray[2] == -2 && this.toUBytesArray[3] == -1) {
                        state = 1;
                        offsetDelta = 4;
                    } else if (this.toUBytesArray[0] == -1 && this.toUBytesArray[1] == -2 && this.toUBytesArray[2] == 0 && this.toUBytesArray[3] == 0) {
                        state = 2;
                        offsetDelta = 4;
                    } else {
                        this.toUnicodeStatus = this.getChar(this.toUBytesArray, this.toULength) + 1;
                    }
                    this.isFirstBuffer = false;
                }
            }
            if (offsets != null && offsetDelta != 0) {
                int offsetsLimit = offsets.position();
                while (offsetsPos < offsetsLimit) {
                    int delta = offsetDelta + offsets.get(pos);
                    offsets.put(pos++, delta);
                }
            }
            this.mode = state;
            source.position(pos);
            if (!source.hasRemaining()) {
                return cr;
            }
            cr = !this.isFirstBuffer || CharsetUTF32.this.bom != 0 ? this.decodeLoopImpl(source, target, offsets, flush) : CoderResult.malformedForLength(pos);
            return cr;
        }

        protected int getChar(byte[] bytes, int length) {
            return -1;
        }

        protected CoderResult decodeLoopImpl(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult cr = CoderResult.UNDERFLOW;
            cr = this.mode == 1 ? this.decodeLoopUTF32BE(source, target, offsets, flush) : (this.mode == 2 ? this.decodeLoopUTF32LE(source, target, offsets, flush) : CoderResult.malformedForLength(source.position()));
            return cr;
        }

        /*
         * Unable to fully structure code
         */
        final CoderResult decodeLoopUTF32BE(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            block15: {
                cr = CoderResult.UNDERFLOW;
                sourceArrayIndex = source.position();
                if (this.toUnicodeStatus == 0 || !target.hasRemaining()) ** GOTO lbl34
                i = this.toULength;
                ch = this.toUnicodeStatus - 1;
                this.toUnicodeStatus = 0;
                this.toULength = 0;
                while (i < 4) {
                    if (sourceArrayIndex < source.limit()) {
                        ch = ch << 8 | source.get(sourceArrayIndex) & 255;
                        this.toUBytesArray[i++] = source.get(sourceArrayIndex++);
                        continue;
                    }
                    this.toUnicodeStatus = ch + 1;
                    this.toULength = (byte)i;
                    break block15;
                }
                if (ch > 0x10FFFF || CharsetICU.isSurrogate(ch)) {
                    this.toULength = (byte)i;
                    cr = CoderResult.malformedForLength(sourceArrayIndex);
                } else {
                    if (ch <= 65535) {
                        target.put((char)ch);
                    } else {
                        target.put(UTF16.getLeadSurrogate((int)ch));
                        ch = UTF16.getTrailSurrogate((int)ch);
                        if (target.hasRemaining()) {
                            target.put((char)ch);
                        } else {
                            this.charErrorBufferArray[0] = (char)ch;
                            this.charErrorBufferLength = 1;
                            cr = CoderResult.OVERFLOW;
                        }
                    }
lbl34:
                    // 6 sources

                    block1: while (sourceArrayIndex < source.limit() && target.hasRemaining()) {
                        i = 0;
                        ch = 0;
                        while (i < 4) {
                            if (sourceArrayIndex < source.limit()) {
                                ch = ch << 8 | source.get(sourceArrayIndex) & 255;
                                this.toUBytesArray[i++] = source.get(sourceArrayIndex++);
                                continue;
                            }
                            this.toUnicodeStatus = ch + 1;
                            this.toULength = (byte)i;
                            break block1;
                        }
                        if (ch <= 0x10FFFF && !CharsetICU.isSurrogate(ch)) {
                            if (ch <= 65535) {
                                target.put((char)ch);
                                continue;
                            }
                            target.put(UTF16.getLeadSurrogate((int)ch));
                            ch = UTF16.getTrailSurrogate((int)ch);
                            if (target.hasRemaining()) {
                                target.put((char)ch);
                                continue;
                            }
                            this.charErrorBufferArray[0] = (char)ch;
                            this.charErrorBufferLength = 1;
                            cr = CoderResult.OVERFLOW;
                            break;
                        }
                        this.toULength = (byte)i;
                        cr = CoderResult.malformedForLength(sourceArrayIndex);
                        break;
                    }
                }
            }
            if (sourceArrayIndex < source.limit() && !target.hasRemaining()) {
                cr = CoderResult.OVERFLOW;
            }
            source.position(sourceArrayIndex);
            return cr;
        }

        /*
         * Unable to fully structure code
         */
        final CoderResult decodeLoopUTF32LE(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            block15: {
                cr = CoderResult.UNDERFLOW;
                sourceArrayIndex = source.position();
                if (this.toUnicodeStatus == 0 || !target.hasRemaining()) ** GOTO lbl34
                i = this.toULength;
                ch = this.toUnicodeStatus - 1;
                this.toUnicodeStatus = 0;
                this.toULength = 0;
                while (i < 4) {
                    if (sourceArrayIndex < source.limit()) {
                        ch |= (source.get(sourceArrayIndex) & 255) << i * 8;
                        this.toUBytesArray[i++] = source.get(sourceArrayIndex++);
                        continue;
                    }
                    this.toUnicodeStatus = ch + 1;
                    this.toULength = (byte)i;
                    break block15;
                }
                if (ch > 0x10FFFF || CharsetICU.isSurrogate(ch)) {
                    this.toULength = (byte)i;
                    cr = CoderResult.malformedForLength(sourceArrayIndex);
                } else {
                    if (ch <= 65535) {
                        target.put((char)ch);
                    } else {
                        target.put(UTF16.getLeadSurrogate((int)ch));
                        ch = UTF16.getTrailSurrogate((int)ch);
                        if (target.hasRemaining()) {
                            target.put((char)ch);
                        } else {
                            this.charErrorBufferArray[0] = (char)ch;
                            this.charErrorBufferLength = 1;
                            cr = CoderResult.OVERFLOW;
                        }
                    }
lbl34:
                    // 6 sources

                    block1: while (sourceArrayIndex < source.limit() && target.hasRemaining()) {
                        i = 0;
                        ch = 0;
                        while (i < 4) {
                            if (sourceArrayIndex < source.limit()) {
                                ch |= (source.get(sourceArrayIndex) & 255) << i * 8;
                                this.toUBytesArray[i++] = source.get(sourceArrayIndex++);
                                continue;
                            }
                            this.toUnicodeStatus = ch + 1;
                            this.toULength = (byte)i;
                            break block1;
                        }
                        if (ch <= 0x10FFFF && !CharsetICU.isSurrogate(ch)) {
                            if (ch <= 65535) {
                                target.put((char)ch);
                                continue;
                            }
                            target.put(UTF16.getLeadSurrogate((int)ch));
                            ch = UTF16.getTrailSurrogate((int)ch);
                            if (target.hasRemaining()) {
                                target.put((char)ch);
                                continue;
                            }
                            this.charErrorBufferArray[0] = (char)ch;
                            this.charErrorBufferLength = 1;
                            cr = CoderResult.OVERFLOW;
                            break;
                        }
                        this.toULength = (byte)i;
                        cr = CoderResult.malformedForLength(sourceArrayIndex);
                        break;
                    }
                }
            }
            if (sourceArrayIndex < source.limit() && !target.hasRemaining()) {
                cr = CoderResult.OVERFLOW;
            }
            source.position(sourceArrayIndex);
            return cr;
        }

        protected void implReset() {
            super.implReset();
            this.isFirstBuffer = true;
        }
    }
}

