/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.charset;

import com.ibm.icu.charset.CharsetEncoderICU;
import com.ibm.icu.charset.CharsetICU;
import com.ibm.icu.charset.CharsetUTF16;
import com.ibm.icu.text.UTF16;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

class CharsetUTF16LE
extends CharsetUTF16 {
    private static final byte[] UTF16LE_BOM = new byte[]{-1, -2};

    public CharsetUTF16LE(String icuCanonicalName, String javaCanonicalName, String[] aliases) {
        super(icuCanonicalName, javaCanonicalName, aliases);
        this.fromUSubstitution = new byte[]{-3, -1};
    }

    public CharsetDecoder newDecoder() {
        return new CharsetDecoderUTF16LE((CharsetICU)this);
    }

    public CharsetEncoder newEncoder() {
        return new CharsetEncoderUTF16LE(this);
    }

    class CharsetEncoderUTF16LE
    extends CharsetEncoderICU {
        public CharsetEncoderUTF16LE(CharsetICU cs) {
            super(cs, CharsetUTF16LE.this.fromUSubstitution);
            this.implReset();
        }

        protected void implReset() {
            super.implReset();
            this.fromUnicodeStatus = 0;
        }

        protected CoderResult encodeLoop(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult cr = CoderResult.UNDERFLOW;
            if (!source.hasRemaining()) {
                return cr;
            }
            if (this.fromUnicodeStatus == 1 && this.writeBOM) {
                cr = CharsetEncoderUTF16LE.fromUWriteBytes(this, UTF16LE_BOM, 0, UTF16LE_BOM.length, target, offsets, -1);
                if (cr.isError()) {
                    return cr;
                }
                this.fromUnicodeStatus = 0;
            }
            if (!target.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            int sourceIndex = 0;
            char trail = '\u0000';
            int length = source.remaining();
            int sourceArrayIndex = source.position();
            char c = (char)this.fromUChar32;
            if (c != '\u0000' && UTF16.isTrailSurrogate((char)(trail = source.get(sourceArrayIndex))) && target.remaining() >= 4) {
                ++sourceArrayIndex;
                --length;
                target.put((byte)c);
                target.put((byte)(c >>> 8));
                target.put((byte)trail);
                target.put((byte)(trail >>> 8));
                if (offsets != null && offsets.remaining() >= 4) {
                    offsets.put(-1);
                    offsets.put(-1);
                    offsets.put(-1);
                    offsets.put(-1);
                }
                sourceIndex = 1;
                c = '\u0000';
                this.fromUChar32 = '\u0000';
            }
            byte[] overflow = new byte[4];
            if (c == '\u0000') {
                int count = 2 * length;
                int targetCapacity = target.remaining();
                if (count > targetCapacity) {
                    count = targetCapacity & 0xFFFFFFFE;
                }
                targetCapacity -= count;
                length -= (count >>= 1);
                if (offsets == null) {
                    while (count > 0) {
                        if (!UTF16.isSurrogate((char)(c = source.get(sourceArrayIndex++)))) {
                            target.put((byte)c);
                            target.put((byte)(c >>> 8));
                        } else {
                            if (!UTF16.isLeadSurrogate((char)c) || count < 2 || !UTF16.isTrailSurrogate((char)(trail = source.get(sourceArrayIndex)))) break;
                            ++sourceArrayIndex;
                            --count;
                            target.put((byte)c);
                            target.put((byte)(c >>> 8));
                            target.put((byte)trail);
                            target.put((byte)(trail >>> 8));
                        }
                        --count;
                    }
                } else {
                    while (count > 0) {
                        if (!UTF16.isSurrogate((char)(c = source.get(sourceArrayIndex++)))) {
                            target.put((byte)c);
                            target.put((byte)(c >>> 8));
                            offsets.put(sourceIndex);
                            offsets.put(sourceIndex++);
                        } else {
                            if (!UTF16.isLeadSurrogate((char)c) || count < 2 || !UTF16.isTrailSurrogate((char)(trail = source.get(sourceArrayIndex)))) break;
                            ++sourceArrayIndex;
                            --count;
                            target.put((byte)c);
                            target.put((byte)(c >>> 8));
                            target.put((byte)trail);
                            target.put((byte)(trail >>> 8));
                            offsets.put(sourceIndex);
                            offsets.put(sourceIndex);
                            offsets.put(sourceIndex);
                            offsets.put(sourceIndex);
                            sourceIndex += 2;
                        }
                        --count;
                    }
                }
                if (count == 0) {
                    if (length > 0 && targetCapacity > 0) {
                        if (!UTF16.isSurrogate((char)(c = source.get(sourceArrayIndex++)))) {
                            overflow[0] = (byte)c;
                            overflow[1] = (byte)(c >>> 8);
                            length = 2;
                            c = '\u0000';
                        }
                    } else {
                        length = 0;
                        c = '\u0000';
                    }
                } else {
                    targetCapacity += 2 * count;
                }
            } else {
                length = 0;
            }
            if (c != '\u0000') {
                length = 0;
                if (UTF16.isLeadSurrogate((char)c)) {
                    if (sourceArrayIndex < source.limit()) {
                        trail = source.get(sourceArrayIndex);
                        if (UTF16.isTrailSurrogate((char)trail)) {
                            ++sourceArrayIndex;
                            overflow[0] = (byte)c;
                            overflow[1] = (byte)(c >>> 8);
                            overflow[2] = (byte)trail;
                            overflow[3] = (byte)(trail >>> 8);
                            length = 4;
                            c = '\u0000';
                        } else {
                            cr = CoderResult.malformedForLength(sourceArrayIndex);
                        }
                    }
                } else {
                    cr = CoderResult.malformedForLength(sourceArrayIndex);
                }
                this.fromUChar32 = c;
            }
            source.position(sourceArrayIndex);
            if (length > 0) {
                cr = CharsetEncoderUTF16LE.fromUWriteBytes(this, overflow, 0, length, target, offsets, sourceIndex);
            }
            return cr;
        }
    }

    class CharsetDecoderUTF16LE
    extends CharsetUTF16.CharsetDecoderUTF16 {
        public CharsetDecoderUTF16LE(CharsetICU cs) {
            super(cs);
        }

        protected CoderResult decodeLoopImpl(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            return this.decodeLoopUTF16LE(source, target, offsets, flush);
        }
    }
}

