/*
 * Decompiled with CFR 0.152.
 */
package org.postgis;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import org.postgis.Geometry;
import org.postgis.Point;
import org.postgresql.util.PGtokenizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ComposedGeom
extends Geometry {
    private static final long serialVersionUID = 256L;
    public static final Geometry[] EMPTY = new Geometry[0];
    protected Geometry[] subgeoms;
    boolean nohash;
    int hashcode;

    public Geometry getSubGeometry(int n) {
        return this.subgeoms[n];
    }

    public int numGeoms() {
        return this.subgeoms.length;
    }

    protected abstract Geometry createSubGeomInstance(String var1, boolean var2) throws SQLException;

    protected abstract Geometry[] createSubGeomArray(int var1);

    protected boolean equalsintern(Geometry geometry) {
        ComposedGeom composedGeom = (ComposedGeom)geometry;
        if (composedGeom.subgeoms == null && this.subgeoms == null) {
            return true;
        }
        if (composedGeom.subgeoms == null || this.subgeoms == null) {
            return false;
        }
        if (composedGeom.subgeoms.length != this.subgeoms.length) {
            return false;
        }
        if (this.subgeoms.length == 0) {
            return true;
        }
        int n = 0;
        while (n < this.subgeoms.length) {
            if (!composedGeom.subgeoms[n].equalsintern(this.subgeoms[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int numPoints() {
        if (this.subgeoms == null || this.subgeoms.length == 0) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.subgeoms.length) {
            n += this.subgeoms[n2].numPoints();
            ++n2;
        }
        return n;
    }

    public Point getPoint(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Negative index not allowed");
        }
        if (this.subgeoms == null || this.subgeoms.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Empty Geometry has no Points!");
        }
        int n2 = 0;
        while (n2 < this.subgeoms.length) {
            Geometry geometry = this.subgeoms[n2];
            int n3 = geometry.numPoints();
            if (n < n3) {
                return geometry.getPoint(n);
            }
            n -= n3;
            ++n2;
        }
        throw new ArrayIndexOutOfBoundsException("Index too large!");
    }

    public Point getLastPoint() {
        if (this.subgeoms == null || this.subgeoms.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Empty Geometry has no Points!");
        }
        return this.subgeoms[this.subgeoms.length - 1].getLastPoint();
    }

    public Point getFirstPoint() {
        if (this.subgeoms == null || this.subgeoms.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Empty Geometry has no Points!");
        }
        return this.subgeoms[0].getFirstPoint();
    }

    public Iterator iterator() {
        return Arrays.asList(this.subgeoms).iterator();
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this.subgeoms == null || this.subgeoms.length == 0) {
            bl = true;
        }
        return bl;
    }

    protected void mediumWKT(StringBuffer stringBuffer) {
        if (this.subgeoms == null || this.subgeoms.length == 0) {
            stringBuffer.append(" EMPTY");
        } else {
            stringBuffer.append('(');
            this.innerWKT(stringBuffer);
            stringBuffer.append(')');
        }
    }

    protected void innerWKT(StringBuffer stringBuffer) {
        this.subgeoms[0].mediumWKT(stringBuffer);
        int n = 1;
        while (n < this.subgeoms.length) {
            stringBuffer.append(',');
            this.subgeoms[n].mediumWKT(stringBuffer);
            ++n;
        }
    }

    public int hashCode() {
        if (this.nohash) {
            this.hashcode = super.hashCode() ^ this.subgeoms.hashCode();
            this.nohash = false;
        }
        return this.hashcode;
    }

    public boolean checkConsistency() {
        if (super.checkConsistency()) {
            if (this.isEmpty()) {
                return true;
            }
            int n = this.dimension;
            boolean bl = this.haveMeasure;
            int n2 = this.srid;
            int n3 = 0;
            while (n3 < this.subgeoms.length) {
                Geometry geometry = this.subgeoms[n3];
                if (!geometry.checkConsistency() || geometry.dimension != n || geometry.haveMeasure != bl || geometry.srid != n2) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        return false;
    }

    private final /* synthetic */ void this() {
        this.subgeoms = EMPTY;
        this.nohash = true;
        this.hashcode = 0;
    }

    public ComposedGeom(int n) {
        super(n);
        this.this();
    }

    protected ComposedGeom(int n, Geometry[] geometryArray) {
        this(n);
        this.subgeoms = geometryArray;
        if (geometryArray.length > 0) {
            this.dimension = geometryArray[0].dimension;
            this.haveMeasure = geometryArray[0].haveMeasure;
        } else {
            this.dimension = 0;
        }
    }

    protected ComposedGeom(int n, String string, boolean bl) throws SQLException {
        super(n);
        this.this();
        string = this.initSRID(string);
        String string2 = this.getTypeString();
        if (string.indexOf(string2) == 0) {
            int n2 = string2.length();
            if (string.charAt(n2) == 'M') {
                ++n2;
                bl = true;
            }
            string = string.substring(n2).trim();
        } else if (string.charAt(0) != '(') {
            throw new SQLException("Error parsing a " + string2 + " out of " + string);
        }
        if (string.equals("(EMPTY)")) {
            return;
        }
        PGtokenizer pGtokenizer = new PGtokenizer(PGtokenizer.removePara((String)string), ',');
        int n3 = pGtokenizer.getSize();
        this.subgeoms = this.createSubGeomArray(n3);
        int n4 = 0;
        while (n4 < n3) {
            this.subgeoms[n4] = this.createSubGeomInstance(pGtokenizer.getToken(n4), bl);
            ++n4;
        }
        this.dimension = this.subgeoms[0].dimension;
        this.haveMeasure = this.subgeoms[0].haveMeasure;
    }
}

