/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.util.algorithm2D;

public class RobustDeterminant {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int signOfDet2x2(double x1, double y1, double x2, double y2) {
        double swap;
        long count = 0L;
        int sign = 1;
        if (x1 == 0.0 || y2 == 0.0) {
            if (y1 == 0.0 || x2 == 0.0) {
                return 0;
            }
            if (y1 > 0.0) {
                if (!(x2 > 0.0)) return sign;
                return -sign;
            }
            if (!(x2 > 0.0)) return -sign;
            return sign;
        }
        if (y1 == 0.0 || x2 == 0.0) {
            if (y2 > 0.0) {
                if (!(x1 > 0.0)) return -sign;
                return sign;
            }
            if (!(x1 > 0.0)) return sign;
            return -sign;
        }
        if (0.0 < y1) {
            if (0.0 < y2) {
                if (!(y1 <= y2)) {
                    sign = -sign;
                    swap = x1;
                    x1 = x2;
                    x2 = swap;
                    swap = y1;
                    y1 = y2;
                    y2 = swap;
                }
            } else if (y1 <= -y2) {
                sign = -sign;
                x2 = -x2;
                y2 = -y2;
            } else {
                swap = x1;
                x1 = -x2;
                x2 = swap;
                swap = y1;
                y1 = -y2;
                y2 = swap;
            }
        } else if (0.0 < y2) {
            if (-y1 <= y2) {
                sign = -sign;
                x1 = -x1;
                y1 = -y1;
            } else {
                swap = -x1;
                x1 = x2;
                x2 = swap;
                swap = -y1;
                y1 = y2;
                y2 = swap;
            }
        } else if (y1 >= y2) {
            x1 = -x1;
            y1 = -y1;
            x2 = -x2;
            y2 = -y2;
        } else {
            sign = -sign;
            swap = -x1;
            x1 = -x2;
            x2 = swap;
            swap = -y1;
            y1 = -y2;
            y2 = swap;
        }
        if (0.0 < x1) {
            if (!(0.0 < x2)) return sign;
            if (!(x1 <= x2)) {
                return sign;
            }
        } else {
            if (0.0 < x2) {
                return -sign;
            }
            if (!(x1 >= x2)) return -sign;
            sign = -sign;
            x1 = -x1;
            x2 = -x2;
        }
        do {
            ++count;
            double k = Math.floor(x2 / x1);
            x2 -= k * x1;
            if ((y2 -= k * y1) < 0.0) {
                return -sign;
            }
            if (y2 > y1) {
                return sign;
            }
            if (x1 > x2 + x2) {
                if (y1 < y2 + y2) {
                    return sign;
                }
            } else {
                if (y1 > y2 + y2) {
                    return -sign;
                }
                x2 = x1 - x2;
                y2 = y1 - y2;
                sign = -sign;
            }
            if (y2 == 0.0) {
                if (x2 != 0.0) return -sign;
                return 0;
            }
            if (x2 == 0.0) {
                return sign;
            }
            k = Math.floor(x1 / x2);
            x1 -= k * x2;
            if ((y1 -= k * y2) < 0.0) {
                return sign;
            }
            if (y1 > y2) {
                return -sign;
            }
            if (x2 > x1 + x1) {
                if (y2 < y1 + y1) {
                    return -sign;
                }
            } else {
                if (y2 > y1 + y1) {
                    return sign;
                }
                x1 = x2 - x1;
                y1 = y2 - y1;
                sign = -sign;
            }
            if (y1 != 0.0) continue;
            if (x1 != 0.0) return sign;
            return 0;
        } while (x1 != 0.0);
        return -sign;
    }
}

