/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.coordinate;

import java.io.Serializable;
import org.geotools.geometry.iso.coordinate.DirectPositionImpl;
import org.geotools.geometry.iso.primitive.PointImpl;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.Point;

public class PositionImpl
implements Position,
Serializable {
    private static final long serialVersionUID = -1588536548235183389L;
    private Object position = null;

    public PositionImpl(DirectPosition directPosition) {
        if (directPosition == null) {
            throw new IllegalArgumentException("DirectPosition is null");
        }
        this.position = directPosition;
    }

    public PositionImpl(PointImpl pointRef) {
        if (pointRef == null) {
            throw new IllegalArgumentException("PointRef not passed");
        }
        this.position = pointRef;
    }

    public DirectPosition getPosition() {
        return (DirectPosition)this.position;
    }

    public boolean hasPoint() {
        return this.position instanceof PointImpl;
    }

    public PointImpl getPoint() {
        return this.hasPoint() ? (PointImpl)this.position : null;
    }

    public void setDirectPosition(DirectPositionImpl position) {
        this.position = position;
    }

    public int getCoordinateDimension() {
        return this.hasPoint() ? ((PointImpl)this.position).getCoordinateDimension() : ((DirectPositionImpl)this.position).getDimension();
    }

    public String toString() {
        return "[GM_Position: " + this.getPosition() + "]";
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.position instanceof DirectPosition || this.position instanceof DirectPositionImpl) {
            DirectPositionImpl dp = (DirectPositionImpl)this.position;
            return dp.equals(obj);
        }
        if (this.position instanceof Point || this.position instanceof PointImpl) {
            PointImpl point = (PointImpl)this.position;
            return point.equals(obj);
        }
        return this.position.equals(obj);
    }
}

