/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.Collection;
import org.geotools.math.Complex;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ModifiedParameterDescriptor;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform;

public class NewZealandMapGrid
extends MapProjection {
    private static final long serialVersionUID = 8394817836243729133L;
    private static final Complex[] A = new Complex[]{new Complex(0.7557853228, 0.0), new Complex(0.249204646, 0.003371507), new Complex(-0.001541739, 0.04105856), new Complex(-0.10162907, 0.01727609), new Complex(-0.26623489, -0.36249218), new Complex(-0.6870983, -1.1651967)};
    private static final Complex[] B = new Complex[]{new Complex(1.3231270439, 0.0), new Complex(-0.577245789, -0.007809598), new Complex(0.508307513, -0.112208952), new Complex(-0.15094762, 0.18200602), new Complex(1.01418179, 1.64497696), new Complex(1.9660549, 2.5127645)};
    private static final double[] TPHI = new double[]{1.5627014243, 0.5185406398, -0.03333098, -0.1052906, -0.0368594, 0.007317, 0.0122, 0.00394, -0.0013};
    private static final double[] TPSI = new double[]{0.6399175073, -0.1358797613, 0.063294409, -0.02526853, 0.0117879, -0.0055161, 0.0026906, -0.001333, 6.7E-4, -3.4E-4};
    private final transient Complex theta = new Complex();
    private final transient Complex power = new Complex();
    private final transient Complex z = new Complex();
    private final transient Complex t = new Complex();
    private final transient Complex num = new Complex();
    private final transient Complex denom = new Complex();

    protected NewZealandMapGrid() {
        this((ParameterValueGroup)Provider.PARAMETERS.createValue());
    }

    protected NewZealandMapGrid(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    final boolean isExpectedParameter(Collection expected, ParameterDescriptor param) {
        return ModifiedParameterDescriptor.contains(expected, param);
    }

    protected synchronized Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        int i;
        double dphi;
        double dphi_pow_i = dphi = (y - this.latitudeOfOrigin) * 2.0626480624709633;
        double dpsi = 0.0;
        for (i = 0; i < TPSI.length; ++i) {
            dpsi += TPSI[i] * dphi_pow_i;
            dphi_pow_i *= dphi;
        }
        this.power.real = this.theta.real = dpsi;
        this.power.imag = this.theta.imag = x;
        this.z.multiply(A[0], this.power);
        for (i = 1; i < A.length; ++i) {
            this.power.multiply(this.power, this.theta);
            this.z.addMultiply(this.z, A[i], this.power);
        }
        if (ptDst != null) {
            ptDst.setLocation(this.z.imag, this.z.real);
            return ptDst;
        }
        return new Point2D.Double(this.z.imag, this.z.real);
    }

    protected synchronized Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double dpsi;
        int j;
        this.power.real = this.z.real = y;
        this.power.imag = this.z.imag = x;
        this.theta.multiply(B[0], this.z);
        for (j = 1; j < B.length; ++j) {
            this.power.multiply(this.power, this.z);
            this.theta.addMultiply(this.theta, B[j], this.power);
        }
        for (j = 0; j < 3; ++j) {
            int k;
            this.power.power(this.theta, 2);
            this.num.addMultiply(this.z, A[1], this.power);
            for (k = 2; k < A.length; ++k) {
                this.power.multiply(this.power, this.theta);
                this.t.multiply(A[k], this.power);
                this.t.multiply(this.t, k);
                this.num.add(this.num, this.t);
            }
            this.power.real = 1.0;
            this.power.imag = 0.0;
            this.denom.copy(A[0]);
            for (k = 1; k < A.length; ++k) {
                this.power.multiply(this.power, this.theta);
                this.t.multiply(A[k], this.power);
                this.t.multiply(this.t, k + 1);
                this.denom.add(this.denom, this.t);
            }
            this.theta.divide(this.num, this.denom);
        }
        double dpsi_pow_i = dpsi = this.theta.real;
        double dphi = TPHI[0] * dpsi;
        for (int i = 1; i < TPHI.length; ++i) {
            dphi += TPHI[i] * (dpsi_pow_i *= dpsi);
        }
        dphi = dphi / 2.0626480624709633 + this.latitudeOfOrigin;
        if (ptDst != null) {
            ptDst.setLocation(this.theta.imag, dphi);
            return ptDst;
        }
        return new Point2D.Double(this.theta.imag, dphi);
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = -7716733400419275656L;
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, "New_Zealand_Map_Grid"), new NamedIdentifier(Citations.EPSG, "New Zealand Map Grid"), new NamedIdentifier(Citations.EPSG, "27200")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{new ModifiedParameterDescriptor(SEMI_MAJOR, 6378388.0), new ModifiedParameterDescriptor(SEMI_MINOR, 6356911.9461279465), new ModifiedParameterDescriptor(LATITUDE_OF_ORIGIN, -41.0), new ModifiedParameterDescriptor(CENTRAL_MERIDIAN, 173.0), new ModifiedParameterDescriptor(FALSE_EASTING, 2510000.0), new ModifiedParameterDescriptor(FALSE_NORTHING, 6023150.0)});

        public Provider() {
            super(PARAMETERS);
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            return new NewZealandMapGrid(parameters);
        }
    }
}

