/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.Map;
import java.util.logging.Logger;
import org.apache.solr.analysis.TokenFilterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseTokenFilterFactory
implements TokenFilterFactory {
    static final Logger log = Logger.getLogger(BaseTokenFilterFactory.class.getName());
    protected Map<String, String> args;

    @Override
    public void init(Map<String, String> args) {
        this.args = args;
    }

    @Override
    public Map<String, String> getArgs() {
        return this.args;
    }

    protected int getInt(String name) {
        return this.getInt(name, -1, false);
    }

    protected int getInt(String name, int defaultVal) {
        return this.getInt(name, defaultVal, true);
    }

    protected int getInt(String name, int defaultVal, boolean useDefault) {
        String s = this.args.get(name);
        if (s == null) {
            if (useDefault) {
                return defaultVal;
            }
            throw new RuntimeException("Configuration Error: missing parameter '" + name + "'");
        }
        return Integer.parseInt(s);
    }

    protected boolean getBoolean(String name, boolean defaultVal) {
        return this.getBoolean(name, defaultVal, true);
    }

    protected boolean getBoolean(String name, boolean defaultVal, boolean useDefault) {
        String s = this.args.get(name);
        if (s == null) {
            if (useDefault) {
                return defaultVal;
            }
            throw new RuntimeException("Configuration Error: missing parameter '" + name + "'");
        }
        return Boolean.parseBoolean(s);
    }
}

