/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.FeatureVisitor;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.function.ClassificationFunction;
import org.geotools.filter.function.RangedClassifier;
import org.geotools.util.NullProgressListener;
import org.opengis.filter.expression.Expression;

public class EqualIntervalFunction
extends ClassificationFunction {
    public EqualIntervalFunction() {
        this.setName("EqualInterval");
    }

    private RangedClassifier calculate(FeatureCollection featureCollection) {
        int classNum = this.getClasses();
        try {
            MinVisitor minVisit = new MinVisitor((Expression)this.getExpression());
            if (this.progress == null) {
                this.progress = new NullProgressListener();
            }
            featureCollection.accepts((FeatureVisitor)minVisit, this.progress);
            if (this.progress.isCanceled()) {
                return null;
            }
            Comparable globalMin = (Comparable)minVisit.getResult().getValue();
            MaxVisitor maxVisit = new MaxVisitor((Expression)this.getExpression());
            featureCollection.accepts((FeatureVisitor)maxVisit, this.progress);
            if (this.progress.isCanceled()) {
                return null;
            }
            Comparable globalMax = (Comparable)maxVisit.getResult().getValue();
            if (globalMin instanceof Number && globalMax instanceof Number) {
                return this.calculateNumerical(classNum, globalMin, globalMax);
            }
            return this.calculateNonNumerical(classNum, featureCollection);
        }
        catch (IllegalFilterException e) {
            LOGGER.log(Level.SEVERE, "EqualIntervalFunction calculate(FeatureCollection) failed", e);
            return null;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "EqualIntervalFunction calculate(FeatureCollection) failed", e);
            return null;
        }
    }

    private RangedClassifier calculateNumerical(int classNum, Comparable globalMin, Comparable globalMax) {
        double slotWidth = (((Number)((Object)globalMax)).doubleValue() - ((Number)((Object)globalMin)).doubleValue()) / (double)classNum;
        Comparable[] localMin = new Comparable[classNum];
        Comparable[] localMax = new Comparable[classNum];
        for (int i = 0; i < classNum; ++i) {
            localMin[i] = new Double(((Number)((Object)globalMin)).doubleValue() + (double)i * slotWidth);
            localMax[i] = new Double(((Number)((Object)globalMax)).doubleValue() - (double)(classNum - i - 1) * slotWidth);
            int decPlaces = this.decimalPlaces(slotWidth);
            if (decPlaces > -1) {
                localMin[i] = new Double(this.round(((Number)((Object)localMin[i])).doubleValue(), decPlaces));
                localMax[i] = new Double(this.round(((Number)((Object)localMax[i])).doubleValue(), decPlaces));
            }
            if (i == 0) {
                if (localMin[i].compareTo(new Double(((Number)((Object)globalMin)).doubleValue())) < 0) {
                    localMin[i] = new Double(this.fixRound(((Number)((Object)localMin[i])).doubleValue(), decPlaces, false));
                }
            } else if (i == classNum - 1 && localMax[i].compareTo(new Double(((Number)((Object)globalMax)).doubleValue())) > 0) {
                localMax[i] = new Double(this.fixRound(((Number)((Object)localMax[i])).doubleValue(), decPlaces, true));
            }
            if (i == 0 || localMin[i].equals(localMax[i - 1])) continue;
            localMin[i] = localMax[i - 1];
        }
        return new RangedClassifier(localMin, localMax);
    }

    private RangedClassifier calculateNonNumerical(int classNum, FeatureCollection featureCollection) throws IOException {
        UniqueVisitor uniqueVisit = new UniqueVisitor((Expression)this.getExpression());
        featureCollection.accepts((FeatureVisitor)uniqueVisit, null);
        List result = uniqueVisit.getResult().toList();
        Collections.sort(result);
        Comparable[] values = result.toArray(new Comparable[result.size()]);
        Comparable[] localMin = new Comparable[classNum];
        Comparable[] localMax = new Comparable[classNum];
        int binPop = new Double(Math.ceil((double)values.length / (double)classNum)).intValue();
        int lastBigBin = values.length % classNum;
        lastBigBin = lastBigBin == 0 ? classNum : --lastBigBin;
        int itemIndex = 0;
        for (int binIndex = 0; binIndex < classNum; ++binIndex) {
            localMin[binIndex] = values[itemIndex];
            localMax[binIndex] = binIndex == classNum - 1 ? values[itemIndex] : values[(itemIndex += binPop) + 1];
            if (lastBigBin != binIndex) continue;
            --binPop;
        }
        return new RangedClassifier(localMin, localMax);
    }

    public RangedClassifier evaluate(Object object) {
        if (!(object instanceof FeatureCollection)) {
            return null;
        }
        return this.calculate((FeatureCollection)object);
    }

    public int getArgCount() {
        return 2;
    }
}

