/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.simple;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.geotools.feature.type.Descriptors;
import org.geotools.feature.type.FeatureTypeImpl;
import org.geotools.feature.type.Types;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.InternationalString;

public class SimpleFeatureTypeImpl
extends FeatureTypeImpl
implements SimpleFeatureType {
    List types = null;

    public SimpleFeatureTypeImpl(Name name, List schema, AttributeDescriptor defaultGeometry, CoordinateReferenceSystem crs, boolean isAbstract, Set restrictions, SimpleFeatureType superType, InternationalString description) {
        super(name, schema, defaultGeometry, crs, isAbstract, restrictions, (AttributeType)superType, description);
    }

    public List getAttributes() {
        return (List)this.getProperties();
    }

    public AttributeType getType(Name qname) {
        return Descriptors.type(this.PROPERTIES, qname);
    }

    public AttributeDescriptor getAttribute(Name name) {
        return Descriptors.node(this.PROPERTIES, name);
    }

    public AttributeType getType(String name) {
        return this.getType(Types.attributeName(name));
    }

    public AttributeDescriptor getAttribute(String name) {
        return this.getAttribute(Types.attributeName(name));
    }

    public AttributeType getType(int index) {
        return (AttributeType)this.getTypes().get(index);
    }

    public AttributeDescriptor getAttribute(int index) {
        return (AttributeDescriptor)((List)this.PROPERTIES).get(index);
    }

    public int indexOf(String name) {
        int index = 0;
        for (AttributeDescriptor descriptor : this.PROPERTIES) {
            if (name.equals(descriptor.getName().getLocalPart())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int getAttributeCount() {
        return this.PROPERTIES.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTypes() {
        if (this.types == null) {
            SimpleFeatureTypeImpl simpleFeatureTypeImpl = this;
            synchronized (simpleFeatureTypeImpl) {
                if (this.types == null) {
                    this.types = new ArrayList();
                    for (AttributeDescriptor ad : this.PROPERTIES) {
                        this.types.add(ad.getType());
                    }
                }
            }
        }
        return this.types;
    }

    public GeometryType getDefaultGeometryType() {
        AttributeDescriptor desc = this.getDefaultGeometry();
        if (desc != null) {
            return (GeometryType)desc.getType();
        }
        return null;
    }
}

