/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.geotools.data.collection.ResourceList;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.collection.AbstractResourceCollection;
import org.geotools.feature.collection.DefaultResourceList;
import org.geotools.feature.collection.RandomFeatureAccess;
import org.geotools.feature.collection.SubFeatureCollection;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

public class SubFeatureList
extends SubFeatureCollection
implements RandomFeatureAccess {
    List sort;
    List index;

    public SubFeatureList(FeatureCollection list, Filter filter) {
        this(list, filter, null);
    }

    public SubFeatureList(FeatureCollection list, SortBy sort) {
        this(list, null, sort);
    }

    public SubFeatureList(FeatureCollection list, Filter filter, SortBy subSort) {
        super(list, filter);
        if (subSort == null) {
            this.sort = Collections.EMPTY_LIST;
        } else {
            this.sort = new ArrayList();
            if (this.collection instanceof SubFeatureList) {
                SubFeatureList sorted = (SubFeatureList)this.collection;
                this.sort.addAll(sorted.sort);
            }
            this.sort.add(subSort);
        }
        this.index = null;
    }

    public SubFeatureList(FeatureCollection list, List order) {
        super(list);
        this.index = order;
        this.filter = null;
    }

    AbstractResourceCollection createResourceCollection() {
        return new DefaultResourceList(new DefaultResourceList.Strategy(){

            public Object get(int index) {
                if (SubFeatureList.this.collection instanceof RandomFeatureAccess) {
                    RandomFeatureAccess random = (RandomFeatureAccess)SubFeatureList.this.collection;
                    String id = (String)SubFeatureList.this.index().get(index);
                    random.getFeatureMember(id);
                }
                Iterator it = SubFeatureList.this.iterator();
                try {
                    int i = 0;
                    while (it.hasNext()) {
                        Feature feature = (Feature)it.next();
                        if (i == index) {
                            Feature feature2 = feature;
                            return feature2;
                        }
                        ++i;
                    }
                    throw new IndexOutOfBoundsException();
                }
                finally {
                    SubFeatureList.this.close(it);
                }
            }

            public int size() {
                return 0;
            }
        });
    }

    protected Filter createFilter() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        HashSet<FeatureId> featureIds = new HashSet<FeatureId>();
        Iterator it = this.index.iterator();
        while (it.hasNext()) {
            featureIds.add(ff.featureId((String)it.next()));
        }
        Id fids = ff.id(featureIds);
        return fids;
    }

    protected List index() {
        if (this.index == null) {
            this.index = this.createIndex();
        }
        return this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List createIndex() {
        ArrayList<String> fids = new ArrayList<String>();
        Iterator it = this.collection.iterator();
        try {
            while (it.hasNext()) {
                Feature feature = (Feature)it.next();
                if (!this.filter.evaluate((Object)feature)) continue;
                fids.add(feature.getID());
            }
            if (this.sort != null && !this.sort.isEmpty()) {
                final SortBy initialOrder = (SortBy)this.sort.get(this.sort.size() - 1);
                Collections.sort(fids, new Comparator(){

                    public int compare(Object key1, Object key2) {
                        Feature feature2;
                        Feature feature1 = SubFeatureList.this.getFeatureMember((String)key1);
                        int compare = this.compare(feature1, feature2 = SubFeatureList.this.getFeatureMember((String)key2), initialOrder);
                        if (compare == 0 && SubFeatureList.this.sort.size() > 1) {
                            for (int i = SubFeatureList.this.sort.size() - 1; compare == 0 && i >= 0; --i) {
                                compare = this.compare(feature1, feature2, (SortBy)SubFeatureList.this.sort.get(i));
                            }
                        }
                        return compare;
                    }

                    protected int compare(Feature feature1, Feature feature2, SortBy order) {
                        PropertyName name = order.getPropertyName();
                        Comparable value1 = (Comparable)name.evaluate((Object)feature1);
                        Comparable value2 = (Comparable)name.evaluate((Object)feature2);
                        if (order.getSortOrder() == SortOrder.ASCENDING) {
                            return value1.compareTo(value2);
                        }
                        return value2.compareTo(value1);
                    }
                });
            }
        }
        finally {
            this.collection.close(it);
        }
        return fids;
    }

    public void add(int index, Object element) {
        ((ResourceList)this.rc).add(index, element);
    }

    public boolean addAll(int index, Collection c) {
        return ((ResourceList)this.rc).addAll(index, c);
    }

    public Object get(int index) {
        return ((ResourceList)this.rc).get(index);
    }

    public int indexOf(Object o) {
        return ((ResourceList)this.rc).indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return ((ResourceList)this.rc).lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return ((ResourceList)this.rc).listIterator();
    }

    public ListIterator listIterator(int index) {
        return ((ResourceList)this.rc).listIterator(index);
    }

    public Object remove(int index) {
        return ((ResourceList)this.rc).remove(index);
    }

    public Object set(int index, Object element) {
        return ((ResourceList)this.rc).set(index, element);
    }

    public FeatureCollection subList(Filter subfilter) {
        return new SubFeatureCollection(this, subfilter);
    }

    public Feature getFeatureMember(String id) throws NoSuchElementException {
        int position = this.index.indexOf(id);
        if (position == -1) {
            throw new NoSuchElementException(id);
        }
        if (this.collection instanceof RandomFeatureAccess) {
            RandomFeatureAccess random = (RandomFeatureAccess)this.collection;
            random.getFeatureMember(id);
        }
        return (Feature)this.get(position);
    }

    public Feature removeFeatureMember(String id) {
        int position = this.index.indexOf(id);
        if (position == -1) {
            throw new NoSuchElementException(id);
        }
        if (this.collection instanceof RandomFeatureAccess) {
            RandomFeatureAccess random = (RandomFeatureAccess)this.collection;
            if (this.index != null) {
                this.index.remove(id);
            }
            return random.removeFeatureMember(id);
        }
        return (Feature)this.remove(position);
    }
}

