/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geotools.feature.ComplexAttributeImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Feature;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryType;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FeatureImpl
extends ComplexAttributeImpl
implements Feature {
    private Map userData = new HashMap();
    CoordinateReferenceSystem crs;
    GeometryAttribute defaultGeometry;

    public FeatureImpl(Collection properties, AttributeDescriptor desc, String id) {
        super(properties, desc, id);
    }

    public FeatureImpl(Collection properties, FeatureType type, String id) {
        super(properties, (ComplexType)type, id);
    }

    public void putUserData(Object key, Object value) {
        this.userData.put(key, value);
    }

    public Object getUserData(Object key) {
        return this.userData.get(key);
    }

    public void setCRS(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public CoordinateReferenceSystem getCRS() {
        return this.crs;
    }

    public BoundingBox getBounds() {
        ReferencedEnvelope bounds = new ReferencedEnvelope(this.getCRS());
        for (Attribute attribute : this.attributes()) {
            if (!(attribute instanceof GeometryAttribute)) continue;
            bounds.include(((GeometryAttribute)attribute).getBounds());
        }
        return bounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeometryAttribute getDefaultGeometry() {
        if (this.defaultGeometry != null) {
            return this.defaultGeometry;
        }
        FeatureImpl featureImpl = this;
        synchronized (featureImpl) {
            if (this.defaultGeometry == null) {
                if (((FeatureType)this.getType()).getDefaultGeometry() == null) {
                    return null;
                }
                GeometryType geometryType = (GeometryType)((FeatureType)this.getType()).getDefaultGeometry().getType();
                if (geometryType != null) {
                    for (Attribute attribute : this.attributes()) {
                        if (!(attribute instanceof GeometryAttribute) || !attribute.getType().equals(geometryType)) continue;
                        this.defaultGeometry = (GeometryAttribute)attribute;
                        break;
                    }
                }
            }
        }
        return this.defaultGeometry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultGeometry(GeometryAttribute defaultGeometry) {
        FeatureImpl featureImpl = this;
        synchronized (featureImpl) {
            this.defaultGeometry = defaultGeometry;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        List atts = this.properties;
        sb.append("<").append(this.ID);
        if (this.DESCRIPTOR != null) {
            sb.append(",").append(this.DESCRIPTOR.getName().getLocalPart());
        }
        sb.append(">");
        sb.append(this.getType().getName().getLocalPart()).append("=[");
        Iterator itr = atts.iterator();
        while (itr.hasNext()) {
            Attribute att = (Attribute)itr.next();
            sb.append(att.getDescriptor().getName().getLocalPart());
            if (!(att instanceof ComplexAttribute)) {
                sb.append('=');
                sb.append(att.getValue());
            }
            if (!itr.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

