/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.feature.CollectionEvent;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.DefaultFeatureType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.collection.BaseFeatureCollection;
import org.geotools.feature.collection.FeatureIteratorImpl;
import org.geotools.feature.collection.FeatureState;
import org.geotools.feature.collection.SubFeatureCollection;
import org.geotools.feature.visitor.FeatureVisitor;
import org.geotools.filter.SortBy2;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.NullProgressListener;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.util.ProgressListener;

public class DefaultFeatureCollection
extends BaseFeatureCollection
implements FeatureCollection {
    private SortedMap contents = new TreeMap();
    private Envelope bounds = null;
    private FeatureType childType = null;
    private FeatureCollection parent;

    public DefaultFeatureCollection(FeatureCollection collection) {
        this(collection.getID(), collection.getFeatureType());
        this.addAll((Collection)collection);
    }

    public DefaultFeatureCollection(String id, FeatureType featureType) {
        super(id, featureType == null ? new DefaultFeatureType("AbstractFeatureType", FeatureTypes.DEFAULT_NAMESPACE, new LinkedList(), new LinkedList(), null) : featureType);
    }

    public SimpleFeatureType getMemberType() {
        if (this.childType != null) {
            return this.childType;
        }
        return super.getMemberType();
    }

    public ReferencedEnvelope getBounds() {
        if (this.bounds == null) {
            this.bounds = new Envelope();
            Iterator i = this.contents.values().iterator();
            while (i.hasNext()) {
                ReferencedEnvelope geomBounds = ((Feature)i.next()).getBounds();
                if (geomBounds.isNull()) continue;
                this.bounds.expandToInclude((Envelope)geomBounds);
            }
        }
        return ReferencedEnvelope.reference((Envelope)this.bounds);
    }

    protected void fireChange(Feature[] features, int type) {
        this.bounds = null;
        CollectionEvent cEvent = new CollectionEvent((FeatureCollection)this, features, type);
        int ii = this.listeners.size();
        for (int i = 0; i < ii; ++i) {
            ((CollectionListener)this.listeners.get(i)).collectionChanged(cEvent);
        }
    }

    protected void fireChange(Feature feature, int type) {
        this.fireChange(new Feature[]{feature}, type);
    }

    protected void fireChange(Collection coll, int type) {
        Feature[] features = new Feature[coll.size()];
        features = coll.toArray(features);
        this.fireChange(features, type);
    }

    public boolean add(Object o) {
        return this.add((Feature)o, true);
    }

    protected boolean add(Feature feature, boolean fire) {
        if (feature == null) {
            return false;
        }
        String ID = feature.getID();
        if (ID == null) {
            return false;
        }
        if (this.contents.containsKey(ID)) {
            return false;
        }
        if (this.childType == null) {
            this.childType = feature.getFeatureType();
        }
        FeatureType childType = (FeatureType)this.getMemberType();
        if (!feature.getFeatureType().equals(childType)) {
            LOGGER.warning("Feature Collection contains a heterogeneous mix of features");
        }
        this.contents.put(ID, feature);
        if (fire) {
            this.fireChange(feature, 0);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection collection) {
        boolean changed = false;
        Iterator iterator = collection.iterator();
        try {
            ArrayList<Feature> featuresAdded = new ArrayList<Feature>(collection.size());
            while (iterator.hasNext()) {
                Feature f = (Feature)iterator.next();
                boolean added = this.add(f, false);
                changed |= added;
                if (!added) continue;
                featuresAdded.add(f);
            }
            if (changed) {
                this.fireChange(featuresAdded, 0);
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            if (collection instanceof FeatureCollection) {
                ((FeatureCollection)collection).close(iterator);
            }
        }
    }

    public void clear() {
        if (this.contents.isEmpty()) {
            return;
        }
        Feature[] oldFeatures = new Feature[this.contents.size()];
        oldFeatures = this.contents.values().toArray(oldFeatures);
        this.contents.clear();
        this.fireChange(oldFeatures, 1);
    }

    public boolean contains(Object o) {
        if (!(o instanceof Feature)) {
            return false;
        }
        Feature feature = (Feature)o;
        String ID = feature.getID();
        return this.contents.containsKey(ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        try {
            while (iterator.hasNext()) {
                Feature feature = (Feature)iterator.next();
                if (this.contents.containsKey(feature.getID())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (collection instanceof FeatureCollection) {
                ((FeatureCollection)collection).close(iterator);
            }
        }
    }

    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    public Iterator iterator() {
        final Iterator iterator = this.contents.values().iterator();
        return new Iterator(){
            Feature currFeature = null;

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public Object next() {
                this.currFeature = (Feature)iterator.next();
                return this.currFeature;
            }

            public void remove() {
                iterator.remove();
                DefaultFeatureCollection.this.fireChange(this.currFeature, 1);
            }
        };
    }

    public FeatureIterator features() {
        return new FeatureIteratorImpl(this);
    }

    public boolean remove(Object o) {
        if (!(o instanceof Feature)) {
            return false;
        }
        Feature f = (Feature)o;
        boolean changed = this.contents.values().remove(f);
        if (changed) {
            this.fireChange(f, 1);
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection collection) {
        boolean changed = false;
        Iterator iterator = collection.iterator();
        try {
            ArrayList<Feature> removedFeatures = new ArrayList<Feature>(collection.size());
            while (iterator.hasNext()) {
                Feature f = (Feature)iterator.next();
                boolean removed = this.contents.values().remove(f);
                if (!removed) continue;
                changed = true;
                removedFeatures.add(f);
            }
            if (changed) {
                this.fireChange(removedFeatures, 1);
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            if (collection instanceof FeatureCollection) {
                ((FeatureCollection)collection).close(iterator);
            }
        }
    }

    public boolean retainAll(Collection collection) {
        ArrayList<Feature> removedFeatures = new ArrayList<Feature>(this.contents.size() - collection.size());
        boolean modified = false;
        Iterator it = this.contents.values().iterator();
        while (it.hasNext()) {
            Feature f = (Feature)it.next();
            if (collection.contains(f)) continue;
            it.remove();
            modified = true;
            removedFeatures.add(f);
        }
        if (modified) {
            this.fireChange(removedFeatures, 1);
        }
        return modified;
    }

    public int size() {
        return this.contents.size();
    }

    public Object[] toArray() {
        return this.contents.values().toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.contents.values().toArray(a != null ? a : new Object[this.contents.size()]);
    }

    public FeatureCollection getParent() {
        return this.parent;
    }

    public void setParent(FeatureCollection collection) {
        this.parent = collection;
    }

    public List getValues() {
        return Arrays.asList(this.toArray(null));
    }

    public Object getValue(String xPath) {
        if (xPath.indexOf(this.getFeatureType().getTypeName()) > -1) {
            if (xPath.endsWith("]")) {
                return this.contents.values();
            }
            return this.contents.values();
        }
        return null;
    }

    public Object getValue(int index) {
        if (index == 0) {
            return this.contents.values();
        }
        return null;
    }

    public void setValue(int position, Object val) {
        if (position == 0 && val instanceof List) {
            List nw = (List)val;
            if (!FeatureState.isFeatures(nw)) {
                return;
            }
            this.contents.clear();
            for (Feature feature : nw) {
                this.contents.put(feature.getID(), feature);
            }
            this.fireChange(nw, 0);
        }
    }

    public void setValue(String xPath, Object attribute) {
        if (xPath.indexOf(this.getFeatureType().getTypeName()) > -1 && !xPath.endsWith("]")) {
            this.setValue(0, attribute);
        }
    }

    public Object getDefaultGeometryValue() {
        return null;
    }

    public void setDefaultGeometryValue(Object geometry) {
        throw new UnsupportedOperationException("Not Supported");
    }

    public void close(FeatureIterator close) {
        if (close instanceof FeatureIteratorImpl) {
            FeatureIteratorImpl wrapper = (FeatureIteratorImpl)close;
            wrapper.close();
        }
    }

    public void close(Iterator close) {
    }

    public FeatureReader reader() throws IOException {
        final FeatureIterator iterator = this.features();
        return new FeatureReader(){

            public FeatureType getFeatureType() {
                return DefaultFeatureCollection.this.getSchema();
            }

            public Feature next() throws IOException, IllegalAttributeException, NoSuchElementException {
                return iterator.next();
            }

            public boolean hasNext() throws IOException {
                return iterator.hasNext();
            }

            public void close() throws IOException {
                DefaultFeatureCollection.this.close(iterator);
            }
        };
    }

    public int getCount() throws IOException {
        return this.contents.size();
    }

    public FeatureCollection collection() throws IOException {
        DefaultFeatureCollection copy = new DefaultFeatureCollection(null, this.getFeatureType());
        ArrayList<Feature> list = new ArrayList<Feature>(this.contents.size());
        FeatureIterator iterator = this.features();
        while (iterator.hasNext()) {
            Feature duplicate;
            Feature feature = iterator.next();
            try {
                duplicate = feature.getFeatureType().duplicate(feature);
            }
            catch (IllegalAttributeException e) {
                throw new DataSourceException("Unable to copy " + feature.getID(), (Throwable)e);
            }
            list.add(duplicate);
        }
        copy.addAll(list);
        return copy;
    }

    public Set fids() {
        return Collections.unmodifiableSet(this.contents.keySet());
    }

    public final void accepts(FeatureVisitor visitor, org.geotools.util.ProgressListener progress) throws IOException {
        this.accepts((org.opengis.feature.FeatureVisitor)visitor, (ProgressListener)progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accepts(org.opengis.feature.FeatureVisitor visitor, ProgressListener progress) {
        Iterator iterator = null;
        if (progress == null) {
            progress = new NullProgressListener();
        }
        try {
            float size = this.size();
            float position = 0.0f;
            progress.started();
            iterator = this.iterator();
            while (!progress.isCanceled() && iterator.hasNext()) {
                try {
                    Feature feature = (Feature)iterator.next();
                    visitor.visit((org.opengis.feature.Feature)feature);
                }
                catch (Exception erp) {
                    progress.exceptionOccurred((Throwable)erp);
                }
                float f = position;
                position = f + 1.0f;
                progress.progress(f / size);
            }
        }
        catch (Throwable throwable) {
            progress.complete();
            this.close(iterator);
            throw throwable;
        }
        progress.complete();
        this.close(iterator);
    }

    public FeatureCollection subCollection(Filter filter) {
        if (filter == Filter.INCLUDE) {
            return this;
        }
        return new SubFeatureCollection(this, filter);
    }

    public FeatureCollection sort(SortBy order) {
        if (order == SortBy.NATURAL_ORDER) {
            return this;
        }
        if (order instanceof SortBy2) {
            SortBy2 advanced = (SortBy2)order;
            return this.sort(advanced);
        }
        return null;
    }

    public FeatureCollection sort(SortBy2 order) {
        if (order == SortBy.NATURAL_ORDER) {
            return this;
        }
        if (order == SortBy.REVERSE_ORDER) {
            // empty if block
        }
        return null;
    }

    public void purge() {
    }
}

