/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.Iterator;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;

public class ReprojectingIterator
implements Iterator {
    Iterator delegate;
    CoordinateReferenceSystem target;
    FeatureType schema;
    GeometryCoordinateSequenceTransformer tx;

    public ReprojectingIterator(Iterator delegate, MathTransform transform, FeatureType schema, GeometryCoordinateSequenceTransformer transformer) throws OperationNotFoundException, FactoryRegistryException, FactoryException {
        this.delegate = delegate;
        this.schema = schema;
        this.tx = transformer;
        this.tx.setMathTransform((MathTransform)((MathTransform2D)transform));
    }

    public ReprojectingIterator(Iterator delegate, CoordinateReferenceSystem source, CoordinateReferenceSystem target, FeatureType schema, GeometryCoordinateSequenceTransformer transformer) throws OperationNotFoundException, FactoryRegistryException, FactoryException {
        this.delegate = delegate;
        this.target = target;
        this.schema = schema;
        this.tx = transformer;
        MathTransform transform = ReferencingFactoryFinder.getCoordinateOperationFactory(null).createOperation(source, target).getMathTransform();
        this.tx.setMathTransform((MathTransform)((MathTransform2D)transform));
    }

    public Iterator getDelegate() {
        return this.delegate;
    }

    public void remove() {
        this.delegate.remove();
    }

    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    public Object next() {
        Feature feature = (Feature)this.delegate.next();
        try {
            return this.reproject(feature);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    Feature reproject(Feature feature) throws IOException {
        Object[] attributes = feature.getAttributes(null);
        for (int i = 0; i < attributes.length; ++i) {
            Object object = attributes[i];
            if (!(object instanceof Geometry)) continue;
            Geometry geometry = (Geometry)object;
            try {
                attributes[i] = this.tx.transform(geometry);
                continue;
            }
            catch (TransformException e) {
                String msg = "Error occured transforming " + geometry.toString();
                throw (IOException)new IOException(msg).initCause(e);
            }
        }
        try {
            return this.schema.create(attributes, feature.getID());
        }
        catch (IllegalAttributeException e) {
            String msg = "Error creating reprojeced feature";
            throw (IOException)new IOException(msg).initCause(e);
        }
    }
}

