/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.collection;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.Iterator;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.SchemaNotFoundException;
import org.geotools.data.Transaction;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.feature.CollectionEvent;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.DefaultFeatureType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureType;
import org.opengis.filter.Filter;

public class CollectionDataStore
extends AbstractDataStore {
    FeatureType featureType;
    FeatureCollection collection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectionDataStore(FeatureCollection collection) {
        this.collection = collection;
        if (collection.size() == 0) {
            this.featureType = DefaultFeatureType.EMPTY;
        } else {
            Iterator iter = null;
            try {
                iter = collection.iterator();
                this.featureType = ((Feature)iter.next()).getFeatureType();
            }
            finally {
                if (iter != null) {
                    collection.close(iter);
                }
            }
        }
        collection.addListener((CollectionListener)new FeatureCollectionListener());
    }

    public String[] getTypeNames() {
        return new String[]{this.featureType.getTypeName()};
    }

    public FeatureType getSchema(String typeName) throws IOException {
        if (typeName != null && typeName.equals(this.featureType.getTypeName())) {
            return this.featureType;
        }
        throw new IOException(typeName + " not available");
    }

    public FeatureReader getFeatureReader(String typeName) throws IOException {
        return new DelegateFeatureReader(this.getSchema(typeName), this.collection.features());
    }

    public FeatureCollection getCollection() {
        return this.collection;
    }

    protected Envelope getBounds(Query query) throws SchemaNotFoundException {
        String featureTypeName = query.getTypeName();
        if (!this.featureType.getTypeName().equals(featureTypeName)) {
            throw new SchemaNotFoundException(featureTypeName);
        }
        return this.getBoundsInternal(query);
    }

    protected Envelope getBoundsInternal(Query query) {
        FeatureIterator iterator = this.collection.features();
        Envelope envelope = null;
        if (iterator.hasNext()) {
            int count = 1;
            Filter filter = query.getFilter();
            envelope = iterator.next().getPrimaryGeometry().getEnvelopeInternal();
            while (iterator.hasNext() && count < query.getMaxFeatures()) {
                Feature feature = iterator.next();
                if (!filter.evaluate((Object)feature)) continue;
                ++count;
                envelope.expandToInclude(feature.getPrimaryGeometry().getEnvelopeInternal());
            }
        }
        return envelope;
    }

    protected int getCount(Query query) throws IOException {
        String featureTypeName = query.getTypeName();
        if (!this.featureType.getTypeName().equals(featureTypeName)) {
            throw new SchemaNotFoundException(featureTypeName);
        }
        int count = 0;
        FeatureIterator iterator = this.collection.features();
        Filter filter = query.getFilter();
        while (iterator.hasNext() && count < query.getMaxFeatures()) {
            if (!filter.evaluate((Object)iterator.next())) continue;
            ++count;
        }
        return count;
    }

    private class FeatureCollectionListener
    implements CollectionListener {
        private FeatureCollectionListener() {
        }

        public void collectionChanged(CollectionEvent tce) {
            String typeName = CollectionDataStore.this.featureType.getTypeName();
            Envelope bounds = null;
            bounds = CollectionDataStore.this.getBoundsInternal(Query.ALL);
            switch (tce.getEventType()) {
                case 0: {
                    CollectionDataStore.this.listenerManager.fireFeaturesAdded(typeName, Transaction.AUTO_COMMIT, bounds, false);
                    break;
                }
                case 2: {
                    CollectionDataStore.this.listenerManager.fireFeaturesChanged(typeName, Transaction.AUTO_COMMIT, bounds, false);
                    break;
                }
                case 1: {
                    CollectionDataStore.this.listenerManager.fireFeaturesRemoved(typeName, Transaction.AUTO_COMMIT, bounds, false);
                }
            }
        }
    }
}

