/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.catalog.adaptable;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.geotools.catalog.Service;
import org.geotools.catalog.ServiceFinder;
import org.geotools.catalog.adaptable.AdaptingCatalog;
import org.geotools.catalog.adaptable.AdaptingService;

public class AdaptingServiceFinder
implements ServiceFinder {
    AdaptingCatalog catalog;
    ServiceFinder finder;

    public AdaptingServiceFinder(AdaptingCatalog catalog, ServiceFinder finder) {
        this.catalog = catalog;
        this.finder = finder;
    }

    public List aquire(Map params) {
        return this.wrap(this.finder.aquire(params));
    }

    public List aquire(URI target) {
        return this.wrap(this.finder.aquire(target));
    }

    public List aquire(URI id, Map params) {
        return this.wrap(this.finder.aquire(id, params));
    }

    public List wrap(List services) {
        if (services == null || services.isEmpty()) {
            return services;
        }
        ArrayList<AdaptingService> adapting = new ArrayList<AdaptingService>(services.size());
        for (Service service : services) {
            adapting.add(new AdaptingService(service, this.catalog.getResolveAdapterFactoryFinder()));
        }
        return adapting;
    }
}

