/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.incrementer;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.incrementer.AbstractDataFieldMaxValueIncrementer;

public class HsqlMaxValueIncrementer
extends AbstractDataFieldMaxValueIncrementer {
    private String columnName;
    private int cacheSize = 1;
    private long[] valueCache = null;
    private int nextValueIndex = -1;

    public HsqlMaxValueIncrementer() {
    }

    public HsqlMaxValueIncrementer(DataSource ds, String incrementerName, String columnName) {
        this.setDataSource(ds);
        this.setIncrementerName(incrementerName);
        this.columnName = columnName;
        this.afterPropertiesSet();
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.columnName == null) {
            throw new IllegalArgumentException("columnName is required");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized long getNextKey() throws DataAccessException {
        if (this.nextValueIndex < 0 || this.nextValueIndex >= this.getCacheSize()) {
            Connection con = DataSourceUtils.getConnection(this.getDataSource());
            Statement stmt = null;
            try {
                stmt = con.createStatement();
                DataSourceUtils.applyTransactionTimeout(stmt, this.getDataSource());
                this.valueCache = new long[this.getCacheSize()];
                this.nextValueIndex = 0;
                for (int i = 0; i < this.getCacheSize(); ++i) {
                    stmt.executeUpdate("insert into " + this.getIncrementerName() + " values(null)");
                    ResultSet rs = stmt.executeQuery("select max(identity()) from " + this.getIncrementerName());
                    try {
                        if (!rs.next()) {
                            throw new DataAccessResourceFailureException("identity() failed after executing an update");
                        }
                        this.valueCache[i] = rs.getLong(1);
                        continue;
                    }
                    finally {
                        JdbcUtils.closeResultSet(rs);
                    }
                }
                long l = this.valueCache[this.valueCache.length - 1];
                stmt.executeUpdate("delete from " + this.getIncrementerName() + " where " + this.columnName + " < " + l);
            }
            catch (SQLException ex) {
                throw new DataAccessResourceFailureException("Could not obtain identity()", ex);
            }
            finally {
                JdbcUtils.closeStatement(stmt);
                DataSourceUtils.releaseConnection(con, this.getDataSource());
            }
        }
        return this.valueCache[this.nextValueIndex++];
    }
}

