/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.registry.ConfigurationElement;
import org.eclipse.core.internal.registry.ConfigurationElementHandle;
import org.eclipse.core.internal.registry.Contribution;
import org.eclipse.core.internal.registry.Extension;
import org.eclipse.core.internal.registry.ExtensionHandle;
import org.eclipse.core.internal.registry.ExtensionPoint;
import org.eclipse.core.internal.registry.ExtensionPointHandle;
import org.eclipse.core.internal.registry.Handle;
import org.eclipse.core.internal.registry.HashtableOfInt;
import org.eclipse.core.internal.registry.HashtableOfStringAndInt;
import org.eclipse.core.internal.registry.IObjectManager;
import org.eclipse.core.internal.registry.KeyedElement;
import org.eclipse.core.internal.registry.KeyedHashSet;
import org.eclipse.core.internal.registry.ReferenceMap;
import org.eclipse.core.internal.registry.RegistryObject;
import org.eclipse.core.internal.registry.TableReader;
import org.eclipse.core.internal.registry.TemporaryObjectManager;
import org.eclipse.core.internal.registry.ThirdLevelConfigurationElementHandle;
import org.eclipse.core.runtime.InvalidRegistryObjectException;

public class RegistryObjectManager
implements IObjectManager {
    static final byte CONFIGURATION_ELEMENT = 1;
    static final byte EXTENSION = 2;
    static final byte EXTENSION_POINT = 3;
    static final byte THIRDLEVEL_CONFIGURATION_ELEMENT = 4;
    static final int CACHE_INITIAL_SIZE = 512;
    static final float DEFAULT_LOADFACTOR = 0.75f;
    static final int[] EMPTY_INT_ARRAY = new int[0];
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    static int UNKNOWN = -1;
    private HashtableOfStringAndInt extensionPoints;
    private ReferenceMap cache;
    private HashtableOfInt fileOffsets;
    private int nextId = 1;
    private KeyedHashSet newContributions;
    private Object formerContributions;
    private Object orphanExtensions;
    private KeyedHashSet heldObjects = new KeyedHashSet();
    private boolean isDirty = false;
    private boolean fromCache = false;

    public RegistryObjectManager() {
        this.extensionPoints = new HashtableOfStringAndInt();
        this.cache = "true".equalsIgnoreCase(System.getProperty("eclipse.noRegistryFlushing")) ? new ReferenceMap(0, 512, 0.75f) : new ReferenceMap(1, 512, 0.75f);
        this.newContributions = new KeyedHashSet();
        this.fileOffsets = new HashtableOfInt();
    }

    synchronized boolean init(long timeStamp) {
        TableReader reader = new TableReader();
        Object[] results = reader.loadTables(timeStamp);
        if (results == null) {
            return false;
        }
        this.fileOffsets = (HashtableOfInt)results[0];
        this.extensionPoints = (HashtableOfStringAndInt)results[1];
        this.nextId = (Integer)results[2];
        this.fromCache = true;
        if ("true".equalsIgnoreCase(System.getProperty("eclipse.noLazyRegistryCacheLoading"))) {
            reader.setHoldObjects(true);
            this.markOrphansHasDirty(this.getOrphans());
            this.fromCache = reader.readAllCache(this);
            this.formerContributions = this.getFormerContributions();
        }
        return this.fromCache;
    }

    synchronized void addContribution(Contribution contribution) {
        this.isDirty = true;
        this.newContributions.add(contribution);
    }

    synchronized int[] getExtensionPointsFrom(long id) {
        KeyedElement tmp = this.newContributions.getByKey(new Long(id));
        if (tmp == null) {
            tmp = this.getFormerContributions().getByKey(new Long(id));
        }
        if (tmp == null) {
            return EMPTY_INT_ARRAY;
        }
        return ((Contribution)tmp).getExtensionPoints();
    }

    synchronized Set getNamespaces() {
        KeyedElement[] formerElts = this.getFormerContributions().elements();
        KeyedElement[] newElts = this.newContributions.elements();
        HashSet<String> tmp = new HashSet<String>(formerElts.length + newElts.length);
        int i = 0;
        while (i < formerElts.length) {
            tmp.add(((Contribution)formerElts[i]).getNamespace());
            ++i;
        }
        i = 0;
        while (i < newElts.length) {
            tmp.add(((Contribution)newElts[i]).getNamespace());
            ++i;
        }
        return tmp;
    }

    synchronized boolean hasContribution(long id) {
        KeyedElement result = this.newContributions.getByKey(new Long(id));
        if (result == null) {
            result = this.getFormerContributions().getByKey(new Long(id));
        }
        return result != null;
    }

    private KeyedHashSet getFormerContributions() {
        KeyedHashSet result;
        if (!this.fromCache) {
            return new KeyedHashSet(0);
        }
        if (this.formerContributions == null || (result = (KeyedHashSet)(this.formerContributions instanceof SoftReference ? ((SoftReference)this.formerContributions).get() : this.formerContributions)) == null) {
            TableReader reader = new TableReader();
            result = reader.loadNamespaces();
            this.formerContributions = new SoftReference<KeyedHashSet>(result);
        }
        return result;
    }

    public synchronized void add(RegistryObject registryObject, boolean hold) {
        if (registryObject.getObjectId() == UNKNOWN) {
            int id = this.nextId++;
            registryObject.setObjectId(id);
        }
        this.cache.put(registryObject.getObjectId(), registryObject);
        if (hold) {
            this.hold(registryObject);
        }
    }

    private void remove(RegistryObject registryObject, boolean release) {
        this.cache.remove(registryObject.getObjectId());
        if (release) {
            this.release(registryObject);
        }
    }

    synchronized void remove(int id, boolean release) {
        RegistryObject toRemove = (RegistryObject)this.cache.get(id);
        if (this.fileOffsets != null) {
            this.fileOffsets.removeKey(id);
        }
        if (toRemove != null) {
            this.remove(toRemove, release);
        }
    }

    private void hold(RegistryObject toHold) {
        this.heldObjects.add(toHold);
    }

    private void release(RegistryObject toRelease) {
        this.heldObjects.remove(toRelease);
    }

    public synchronized Object getObject(int id, byte type) {
        return this.basicGetObject(id, type);
    }

    private Object basicGetObject(int id, byte type) {
        Object result = this.cache.get(id);
        if (result != null) {
            return result;
        }
        if (this.fromCache) {
            result = this.load(id, type);
        }
        if (result == null) {
            throw new InvalidRegistryObjectException();
        }
        this.cache.put(id, result);
        return result;
    }

    public synchronized RegistryObject[] getObjects(int[] values, byte type) {
        if (values.length == 0) {
            switch (type) {
                case 3: {
                    return ExtensionPoint.EMPTY_ARRAY;
                }
                case 2: {
                    return Extension.EMPTY_ARRAY;
                }
                case 1: 
                case 4: {
                    return ConfigurationElement.EMPTY_ARRAY;
                }
            }
        }
        RegistryObject[] results = null;
        switch (type) {
            case 3: {
                results = new ExtensionPoint[values.length];
                break;
            }
            case 2: {
                results = new Extension[values.length];
                break;
            }
            case 1: 
            case 4: {
                results = new ConfigurationElement[values.length];
            }
        }
        int i = 0;
        while (i < values.length) {
            results[i] = (RegistryObject)this.basicGetObject(values[i], type);
            ++i;
        }
        return results;
    }

    synchronized ExtensionPoint getExtensionPointObject(String xptUniqueId) {
        int id = this.extensionPoints.get(xptUniqueId);
        if (id == Integer.MIN_VALUE) {
            return null;
        }
        return (ExtensionPoint)this.getObject(id, (byte)3);
    }

    public Handle getHandle(int id, byte type) {
        switch (type) {
            case 3: {
                return new ExtensionPointHandle(this, id);
            }
            case 2: {
                return new ExtensionHandle(this, id);
            }
            case 1: {
                return new ConfigurationElementHandle(this, id);
            }
        }
        return new ThirdLevelConfigurationElementHandle(this, id);
    }

    public Handle[] getHandles(int[] ids, byte type) {
        Handle[] results = null;
        int nbrId = ids.length;
        switch (type) {
            case 3: {
                if (nbrId == 0) {
                    return ExtensionPointHandle.EMPTY_ARRAY;
                }
                results = new ExtensionPointHandle[nbrId];
                int i = 0;
                while (i < nbrId) {
                    results[i] = new ExtensionPointHandle(this, ids[i]);
                    ++i;
                }
                break;
            }
            case 2: {
                if (nbrId == 0) {
                    return ExtensionHandle.EMPTY_ARRAY;
                }
                results = new ExtensionHandle[nbrId];
                int i = 0;
                while (i < nbrId) {
                    results[i] = new ExtensionHandle(this, ids[i]);
                    ++i;
                }
                break;
            }
            case 1: {
                if (nbrId == 0) {
                    return ConfigurationElementHandle.EMPTY_ARRAY;
                }
                results = new ConfigurationElementHandle[nbrId];
                int i = 0;
                while (i < nbrId) {
                    results[i] = new ConfigurationElementHandle(this, ids[i]);
                    ++i;
                }
                break;
            }
            case 4: {
                if (nbrId == 0) {
                    return ConfigurationElementHandle.EMPTY_ARRAY;
                }
                results = new ThirdLevelConfigurationElementHandle[nbrId];
                int i = 0;
                while (i < nbrId) {
                    results[i] = new ThirdLevelConfigurationElementHandle(this, ids[i]);
                    ++i;
                }
                break;
            }
        }
        return results;
    }

    synchronized ExtensionPointHandle[] getExtensionPointsHandles() {
        return (ExtensionPointHandle[])this.getHandles(this.extensionPoints.getValues(), (byte)3);
    }

    synchronized ExtensionPointHandle getExtensionPointHandle(String xptUniqueId) {
        int id = this.extensionPoints.get(xptUniqueId);
        if (id == Integer.MIN_VALUE) {
            return null;
        }
        return (ExtensionPointHandle)this.getHandle(id, (byte)3);
    }

    private Object load(int id, byte type) {
        TableReader reader = new TableReader();
        int offset = this.fileOffsets.get(id);
        if (offset == Integer.MIN_VALUE) {
            return null;
        }
        switch (type) {
            case 1: {
                return reader.loadConfigurationElement(offset);
            }
            case 4: {
                return reader.loadThirdLevelConfigurationElements(offset, this);
            }
            case 2: {
                return reader.loadExtension(offset);
            }
        }
        return reader.loadExtensionPointTree(offset, this);
    }

    synchronized int[] getExtensionsFrom(long bundleId) {
        KeyedElement tmp = this.newContributions.getByKey(new Long(bundleId));
        if (tmp == null) {
            tmp = this.getFormerContributions().getByKey(new Long(bundleId));
        }
        if (tmp == null) {
            return EMPTY_INT_ARRAY;
        }
        return ((Contribution)tmp).getExtensions();
    }

    synchronized void addExtensionPoint(ExtensionPoint currentExtPoint, boolean hold) {
        this.add(currentExtPoint, hold);
        this.extensionPoints.put(currentExtPoint.getUniqueIdentifier(), currentExtPoint.getObjectId());
    }

    synchronized void removeExtensionPoint(String extensionPointId) {
        int pointId = this.extensionPoints.removeKey(extensionPointId);
        if (pointId == Integer.MIN_VALUE) {
            return;
        }
        this.remove(pointId, true);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    synchronized void removeContribution(long bundleId) {
        boolean removed = this.newContributions.removeByKey(new Long(bundleId));
        if (!removed && (removed = this.getFormerContributions().removeByKey(new Long(bundleId)))) {
            this.formerContributions = this.getFormerContributions();
        }
        if (removed) {
            this.isDirty = true;
            return;
        }
    }

    private Map getOrphans() {
        HashMap result = this.orphanExtensions;
        if (this.orphanExtensions == null && !this.fromCache) {
            this.orphanExtensions = result = new HashMap();
        } else if (this.orphanExtensions == null || (result = (HashMap)(this.orphanExtensions instanceof SoftReference ? ((SoftReference)this.orphanExtensions).get() : this.orphanExtensions)) == null) {
            TableReader reader = new TableReader();
            result = reader.loadOrphans();
            this.orphanExtensions = new SoftReference<HashMap>(result);
        }
        return result;
    }

    void addOrphans(String extensionPoint, int[] extensions) {
        Map orphans = this.getOrphans();
        int[] existingOrphanExtensions = (int[])orphans.get(extensionPoint);
        if (existingOrphanExtensions != null) {
            int[] newOrphanExtensions = new int[existingOrphanExtensions.length + extensions.length];
            System.arraycopy(existingOrphanExtensions, 0, newOrphanExtensions, 0, existingOrphanExtensions.length);
            System.arraycopy(extensions, 0, newOrphanExtensions, existingOrphanExtensions.length, extensions.length);
            orphans.put(extensionPoint, newOrphanExtensions);
        } else {
            orphans.put(extensionPoint, extensions);
        }
        this.markOrphansHasDirty(orphans);
    }

    void markOrphansHasDirty(Map orphans) {
        this.orphanExtensions = orphans;
    }

    void addOrphan(String extensionPoint, int extension) {
        Map orphans = this.getOrphans();
        int[] existingOrphanExtensions = (int[])orphans.get(extensionPoint);
        if (existingOrphanExtensions != null) {
            int[] newOrphanExtensions = new int[existingOrphanExtensions.length + 1];
            System.arraycopy(existingOrphanExtensions, 0, newOrphanExtensions, 0, existingOrphanExtensions.length);
            newOrphanExtensions[existingOrphanExtensions.length] = extension;
            orphans.put(extensionPoint, newOrphanExtensions);
        } else {
            orphans.put(extensionPoint, new int[]{extension});
        }
        this.markOrphansHasDirty(orphans);
    }

    int[] removeOrphans(String extensionPoint) {
        Map orphans = this.getOrphans();
        int[] existingOrphanExtensions = (int[])orphans.remove(extensionPoint);
        if (existingOrphanExtensions != null) {
            this.markOrphansHasDirty(orphans);
        }
        return existingOrphanExtensions;
    }

    void removeOrphan(String extensionPoint, int extension) {
        Map orphans = this.getOrphans();
        int[] existingOrphanExtensions = (int[])orphans.get(extensionPoint);
        if (existingOrphanExtensions == null) {
            return;
        }
        this.markOrphansHasDirty(orphans);
        int newSize = existingOrphanExtensions.length - 1;
        if (newSize == 0) {
            orphans.remove(extensionPoint);
            return;
        }
        int[] newOrphanExtensions = new int[existingOrphanExtensions.length - 1];
        int i = 0;
        int j = 0;
        while (i < existingOrphanExtensions.length) {
            if (extension != existingOrphanExtensions[i]) {
                newOrphanExtensions[j++] = existingOrphanExtensions[i];
            }
            ++i;
        }
        orphans.put(extensionPoint, newOrphanExtensions);
    }

    Map getOrphanExtensions() {
        return this.getOrphans();
    }

    int getNextId() {
        return this.nextId;
    }

    HashtableOfStringAndInt getExtensionPoints() {
        return this.extensionPoints;
    }

    KeyedHashSet[] getContributions() {
        return new KeyedHashSet[]{this.newContributions, this.getFormerContributions()};
    }

    synchronized Map getAssociatedObjects(long contributionId) {
        int[] xpts = this.getExtensionPointsFrom(contributionId);
        int[] exts = this.getExtensionsFrom(contributionId);
        HashMap<Integer, RegistryObject> actualObjects = new HashMap<Integer, RegistryObject>(xpts.length + exts.length);
        int i = 0;
        while (i < exts.length) {
            Extension tmp = (Extension)this.basicGetObject(exts[i], (byte)2);
            actualObjects.put(new Integer(exts[i]), tmp);
            this.collectChildren(tmp, 0, actualObjects);
            ++i;
        }
        i = 0;
        while (i < xpts.length) {
            ExtensionPoint xpt = (ExtensionPoint)this.basicGetObject(xpts[i], (byte)3);
            actualObjects.put(new Integer(xpts[i]), xpt);
            ++i;
        }
        return actualObjects;
    }

    synchronized void removeObjects(Map associatedObjects) {
        Collection allValues = associatedObjects.values();
        Iterator iter = allValues.iterator();
        while (iter.hasNext()) {
            RegistryObject toRemove = (RegistryObject)iter.next();
            this.remove(toRemove.getObjectId(), true);
            if (!(toRemove instanceof ExtensionPoint)) continue;
            this.removeExtensionPoint(((ExtensionPoint)toRemove).getUniqueIdentifier());
        }
    }

    IObjectManager createDelegatingObjectManager(Map object) {
        return new TemporaryObjectManager(object, this);
    }

    private void collectChildren(RegistryObject ce, int level, Map collector) {
        ConfigurationElement[] children = (ConfigurationElement[])this.getObjects(ce.getRawChildren(), (byte)(level == 0 || ce.extraDataOffset == -1 ? 1 : 4));
        int j = 0;
        while (j < children.length) {
            collector.put(new Integer(children[j].getObjectId()), children[j]);
            this.collectChildren(children[j], level + 1, collector);
            ++j;
        }
    }

    public void close() {
    }
}

