/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.ast;

import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Statement;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.Label;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.LoopingFlowContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class ForeachStatement
extends Statement {
    public LocalDeclaration elementVariable;
    public int elementVariableImplicitWidening = -1;
    public Expression collection;
    public Statement action;
    private int kind;
    private static final int ARRAY = 0;
    private static final int RAW_ITERABLE = 1;
    private static final int GENERIC_ITERABLE = 2;
    private TypeBinding collectionElementType;
    private Label breakLabel;
    private Label continueLabel;
    public BlockScope scope;
    public LocalVariableBinding indexVariable;
    public LocalVariableBinding collectionVariable;
    public LocalVariableBinding maxVariable;
    private static final char[] SecretIndexVariableName = " index".toCharArray();
    private static final char[] SecretCollectionVariableName = " collection".toCharArray();
    private static final char[] SecretMaxVariableName = " max".toCharArray();
    int postCollectionInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public ForeachStatement(LocalDeclaration elementVariable, Expression collection, int start) {
        this.elementVariable = elementVariable;
        this.collection = collection;
        this.sourceStart = start;
        this.kind = -1;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo exitBranch;
        this.breakLabel = new Label();
        this.continueLabel = new Label();
        flowInfo = this.elementVariable.analyseCode(this.scope, flowContext, flowInfo);
        FlowInfo condInfo = flowInfo.copy().unconditionalInits().discardNullRelatedInitializations();
        condInfo = this.collection.analyseCode(this.scope, flowContext, condInfo);
        condInfo.markAsDefinitelyAssigned(this.elementVariable.binding);
        this.postCollectionInitStateIndex = currentScope.methodScope().recordInitializationStates(condInfo);
        LoopingFlowContext loopingContext = new LoopingFlowContext(flowContext, this, this.breakLabel, this.continueLabel, this.scope);
        FlowInfo actionInfo = condInfo.initsWhenTrue().copy();
        if (!(this.action == null || this.action.isEmptyBlock() && currentScope.compilerOptions().complianceLevel <= 0x2F0000L)) {
            if (!this.action.complainIfUnreachable(actionInfo, this.scope, false)) {
                actionInfo = this.action.analyseCode(this.scope, loopingContext, actionInfo);
            }
            exitBranch = condInfo.initsWhenFalse();
            exitBranch.addInitializationsFrom(flowInfo);
            if (!actionInfo.isReachable() && !loopingContext.initsOnContinue.isReachable()) {
                this.continueLabel = null;
            } else {
                actionInfo = actionInfo.mergedWith(loopingContext.initsOnContinue.unconditionalInits());
                loopingContext.complainOnDeferredChecks(this.scope, actionInfo);
                exitBranch.addPotentialInitializationsFrom(actionInfo.unconditionalInits());
            }
        } else {
            exitBranch = condInfo.initsWhenFalse();
        }
        if (this.action != null && !this.action.isEmptyBlock() && (this.action.bits & 1) == 0) {
            switch (this.kind) {
                case 0: {
                    this.collectionVariable.useFlag = 1;
                    this.indexVariable.useFlag = 1;
                    this.maxVariable.useFlag = 1;
                    break;
                }
                case 1: 
                case 2: {
                    this.indexVariable.useFlag = 1;
                }
            }
        }
        FlowInfo mergedInfo = FlowInfo.mergedOptimizedBranches(loopingContext.initsOnBreak, false, exitBranch, false, true);
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        return mergedInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        if (this.action == null || this.action.isEmptyBlock() || (this.action.bits & 1) != 0) {
            codeStream.exitUserScope(this.scope);
            if (this.mergedInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
            }
            codeStream.recordPositionsFrom(pc, this.sourceStart);
            return;
        }
        switch (this.kind) {
            case 0: {
                this.collection.generateCode(this.scope, codeStream, true);
                codeStream.store(this.collectionVariable, false);
                codeStream.iconst_0();
                codeStream.store(this.indexVariable, false);
                codeStream.load(this.collectionVariable);
                codeStream.arraylength();
                codeStream.store(this.maxVariable, false);
                break;
            }
            case 1: 
            case 2: {
                this.collection.generateCode(this.scope, codeStream, true);
                TypeBinding collectionTypeBinding = this.collection.resolvedType.erasure();
                MethodBinding iteratorMethodBinding = new MethodBinding(1, "iterator".toCharArray(), this.scope.getJavaUtilIterator(), TypeConstants.NoParameters, TypeConstants.NoExceptions, (ReferenceBinding)collectionTypeBinding);
                if (collectionTypeBinding.isInterface()) {
                    codeStream.invokeinterface(iteratorMethodBinding);
                } else {
                    codeStream.invokevirtual(iteratorMethodBinding);
                }
                codeStream.store(this.indexVariable, false);
            }
        }
        Label actionLabel = new Label(codeStream);
        Label conditionLabel = new Label(codeStream);
        this.breakLabel.initialize(codeStream);
        if (this.continueLabel != null) {
            this.continueLabel.initialize(codeStream);
        }
        codeStream.goto_(conditionLabel);
        actionLabel.place();
        if (this.elementVariable.binding.resolvedPosition != -1) {
            switch (this.kind) {
                case 0: {
                    codeStream.load(this.collectionVariable);
                    codeStream.load(this.indexVariable);
                    codeStream.arrayAt(this.collectionElementType.id);
                    if (this.elementVariableImplicitWidening != -1) {
                        codeStream.generateImplicitConversion(this.elementVariableImplicitWidening);
                    }
                    codeStream.store(this.elementVariable.binding, false);
                    break;
                }
                case 1: 
                case 2: {
                    codeStream.load(this.indexVariable);
                    codeStream.invokeJavaUtilIteratorNext();
                    if (this.elementVariable.binding.type.id != 1) {
                        if (this.elementVariableImplicitWidening != -1) {
                            codeStream.checkcast(this.collectionElementType);
                            codeStream.generateImplicitConversion(this.elementVariableImplicitWidening);
                        } else {
                            codeStream.checkcast(this.elementVariable.binding.type);
                        }
                    }
                    codeStream.store(this.elementVariable.binding, false);
                }
            }
            codeStream.addVisibleLocalVariable(this.elementVariable.binding);
            if (this.postCollectionInitStateIndex != -1) {
                codeStream.addDefinitelyAssignedVariables(currentScope, this.postCollectionInitStateIndex);
            }
        } else {
            switch (this.kind) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: {
                    codeStream.load(this.indexVariable);
                    codeStream.invokeJavaUtilIteratorNext();
                    codeStream.pop();
                }
            }
        }
        this.action.generateCode(this.scope, codeStream);
        int continuationPC = codeStream.position;
        if (this.continueLabel != null) {
            this.continueLabel.place();
            switch (this.kind) {
                case 0: {
                    codeStream.iinc(this.indexVariable.resolvedPosition, 1);
                    break;
                }
            }
        }
        conditionLabel.place();
        if (this.postCollectionInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.postCollectionInitStateIndex);
        }
        switch (this.kind) {
            case 0: {
                codeStream.load(this.indexVariable);
                codeStream.load(this.maxVariable);
                codeStream.if_icmplt(actionLabel);
                break;
            }
            case 1: 
            case 2: {
                codeStream.load(this.indexVariable);
                codeStream.invokeJavaUtilIteratorHasNext();
                codeStream.ifne(actionLabel);
            }
        }
        codeStream.recordPositionsFrom(continuationPC, this.elementVariable.sourceStart);
        this.breakLabel.place();
        codeStream.exitUserScope(this.scope);
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public StringBuffer printStatement(int tab, StringBuffer output) {
        ASTNode.printIndent(tab, output).append("for (");
        this.elementVariable.print(0, output);
        output.append(" : ");
        this.collection.print(0, output).append(") ");
        if (this.action == null) {
            output.append(';');
        } else {
            output.append('\n');
            this.action.printStatement(tab + 1, output);
        }
        return output;
    }

    public void resolve(BlockScope upperScope) {
        boolean hasError;
        this.scope = new BlockScope(upperScope);
        this.elementVariable.resolve(this.scope);
        TypeBinding elementType = this.elementVariable.type.resolvedType;
        TypeBinding collectionType = this.collection.resolveType(this.scope);
        this.collection.computeConversion(this.scope, collectionType, collectionType);
        boolean bl = hasError = elementType == null || collectionType == null;
        if (!hasError) {
            ReferenceBinding iterableType;
            if (collectionType.isArrayType()) {
                this.kind = 0;
                this.collectionElementType = ((ArrayBinding)collectionType).elementsType();
                if (!this.collectionElementType.isCompatibleWith(elementType) && !this.scope.isBoxingCompatibleWith(this.collectionElementType, elementType)) {
                    this.scope.problemReporter().notCompatibleTypesErrorInForeach(this.collection, this.collectionElementType, elementType);
                }
                int compileTimeTypeID = this.collectionElementType.id;
                if (elementType.isBaseType()) {
                    if (!this.collectionElementType.isBaseType()) {
                        compileTimeTypeID = this.scope.environment().computeBoxingType((TypeBinding)this.collectionElementType).id;
                        this.elementVariableImplicitWidening = 1024;
                        if (elementType.isBaseType()) {
                            this.elementVariableImplicitWidening |= (elementType.id << 4) + compileTimeTypeID;
                            this.scope.problemReporter().autoboxing(this.collection, this.collectionElementType, elementType);
                        }
                    } else {
                        this.elementVariableImplicitWidening = (elementType.id << 4) + compileTimeTypeID;
                    }
                } else if (this.collectionElementType.isBaseType()) {
                    int boxedID = this.scope.environment().computeBoxingType((TypeBinding)this.collectionElementType).id;
                    this.elementVariableImplicitWidening = 0x200 | compileTimeTypeID << 4 | compileTimeTypeID;
                    compileTimeTypeID = boxedID;
                    this.scope.problemReporter().autoboxing(this.collection, this.collectionElementType, elementType);
                }
            } else if (collectionType instanceof ReferenceBinding && (iterableType = ((ReferenceBinding)collectionType).findSuperTypeErasingTo(38, false)) != null) {
                if (iterableType.isParameterizedType()) {
                    ParameterizedTypeBinding parameterizedType = (ParameterizedTypeBinding)iterableType;
                    if (parameterizedType.arguments.length == 1) {
                        this.kind = 2;
                        this.collectionElementType = parameterizedType.arguments[0];
                        if (!this.collectionElementType.isCompatibleWith(elementType) && !this.scope.isBoxingCompatibleWith(this.collectionElementType, elementType)) {
                            this.scope.problemReporter().notCompatibleTypesErrorInForeach(this.collection, this.collectionElementType, elementType);
                        }
                        int compileTimeTypeID = this.collectionElementType.id;
                        if (elementType.isBaseType()) {
                            if (!this.collectionElementType.isBaseType()) {
                                compileTimeTypeID = this.scope.environment().computeBoxingType((TypeBinding)this.collectionElementType).id;
                                this.elementVariableImplicitWidening = 1024;
                                if (elementType.isBaseType()) {
                                    this.elementVariableImplicitWidening |= (elementType.id << 4) + compileTimeTypeID;
                                }
                            } else {
                                this.elementVariableImplicitWidening = (elementType.id << 4) + compileTimeTypeID;
                            }
                        } else if (this.collectionElementType.isBaseType()) {
                            int boxedID = this.scope.environment().computeBoxingType((TypeBinding)this.collectionElementType).id;
                            this.elementVariableImplicitWidening = 0x200 | compileTimeTypeID << 4 | compileTimeTypeID;
                            compileTimeTypeID = boxedID;
                        }
                    }
                } else if (iterableType.isGenericType()) {
                    if (iterableType.typeVariables().length == 1) {
                        this.kind = 2;
                        this.collectionElementType = iterableType.typeVariables()[0];
                        if (!this.collectionElementType.isCompatibleWith(elementType) && !this.scope.isBoxingCompatibleWith(this.collectionElementType, elementType)) {
                            this.scope.problemReporter().notCompatibleTypesErrorInForeach(this.collection, this.collectionElementType, elementType);
                        }
                        int compileTimeTypeID = this.collectionElementType.id;
                        if (elementType.isBaseType()) {
                            if (!this.collectionElementType.isBaseType()) {
                                compileTimeTypeID = this.scope.environment().computeBoxingType((TypeBinding)this.collectionElementType).id;
                                this.elementVariableImplicitWidening = 1024;
                                if (elementType.isBaseType()) {
                                    this.elementVariableImplicitWidening |= (elementType.id << 4) + compileTimeTypeID;
                                }
                            } else {
                                this.elementVariableImplicitWidening = (elementType.id << 4) + compileTimeTypeID;
                            }
                        } else if (this.collectionElementType.isBaseType()) {
                            int boxedID = this.scope.environment().computeBoxingType((TypeBinding)this.collectionElementType).id;
                            this.elementVariableImplicitWidening = 0x200 | compileTimeTypeID << 4 | compileTimeTypeID;
                            compileTimeTypeID = boxedID;
                        }
                    }
                } else if (iterableType.isRawType()) {
                    this.kind = 1;
                    this.collectionElementType = this.scope.getJavaLangObject();
                    if (!this.collectionElementType.isCompatibleWith(elementType) && !this.scope.isBoxingCompatibleWith(this.collectionElementType, elementType)) {
                        this.scope.problemReporter().notCompatibleTypesErrorInForeach(this.collection, this.collectionElementType, elementType);
                    }
                }
            }
            switch (this.kind) {
                case 0: {
                    this.indexVariable = new LocalVariableBinding(SecretIndexVariableName, (TypeBinding)BaseTypes.IntBinding, 0, false);
                    this.scope.addLocalVariable(this.indexVariable);
                    this.indexVariable.setConstant(ASTNode.NotAConstant);
                    this.maxVariable = new LocalVariableBinding(SecretMaxVariableName, (TypeBinding)BaseTypes.IntBinding, 0, false);
                    this.scope.addLocalVariable(this.maxVariable);
                    this.maxVariable.setConstant(ASTNode.NotAConstant);
                    this.collectionVariable = new LocalVariableBinding(SecretCollectionVariableName, collectionType, 0, false);
                    this.scope.addLocalVariable(this.collectionVariable);
                    this.collectionVariable.setConstant(ASTNode.NotAConstant);
                    break;
                }
                case 1: 
                case 2: {
                    this.indexVariable = new LocalVariableBinding(SecretIndexVariableName, (TypeBinding)this.scope.getJavaUtilIterator(), 0, false);
                    this.scope.addLocalVariable(this.indexVariable);
                    this.indexVariable.setConstant(ASTNode.NotAConstant);
                    break;
                }
                default: {
                    this.scope.problemReporter().invalidTypeForCollection(this.collection);
                }
            }
        }
        if (this.action != null) {
            this.action.resolve(this.scope);
        }
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.elementVariable.traverse(visitor, this.scope);
            this.collection.traverse(visitor, this.scope);
            if (this.action != null) {
                this.action.traverse(visitor, this.scope);
            }
        }
        visitor.endVisit(this, blockScope);
    }
}

