/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.referencing.cs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opengis.util.CodeList;

public final class AxisDirection
extends CodeList {
    private static final long serialVersionUID = -4405275475770755714L;
    private static final List VALUES = new ArrayList(32);
    public static final AxisDirection OTHER;
    public static final AxisDirection NORTH;
    public static final AxisDirection NORTH_NORTH_EAST;
    public static final AxisDirection NORTH_EAST;
    public static final AxisDirection EAST_NORTH_EAST;
    public static final AxisDirection EAST;
    public static final AxisDirection EAST_SOUTH_EAST;
    public static final AxisDirection SOUTH_EAST;
    public static final AxisDirection SOUTH_SOUTH_EAST;
    public static final AxisDirection SOUTH;
    public static final AxisDirection SOUTH_SOUTH_WEST;
    public static final AxisDirection SOUTH_WEST;
    public static final AxisDirection WEST_SOUTH_WEST;
    public static final AxisDirection WEST;
    public static final AxisDirection WEST_NORTH_WEST;
    public static final AxisDirection NORTH_WEST;
    public static final AxisDirection NORTH_NORTH_WEST;
    public static final AxisDirection UP;
    public static final AxisDirection DOWN;
    public static final AxisDirection GEOCENTRIC_X;
    public static final AxisDirection GEOCENTRIC_Y;
    public static final AxisDirection GEOCENTRIC_Z;
    public static final AxisDirection FUTURE;
    public static final AxisDirection PAST;
    public static final AxisDirection COLUMN_POSITIVE;
    public static final AxisDirection COLUMN_NEGATIVE;
    public static final AxisDirection ROW_POSITIVE;
    public static final AxisDirection ROW_NEGATIVE;
    public static final AxisDirection DISPLAY_RIGHT;
    public static final AxisDirection DISPLAY_LEFT;
    public static final AxisDirection DISPLAY_UP;
    public static final AxisDirection DISPLAY_DOWN;
    private transient AxisDirection opposite;

    private AxisDirection(String string) {
        super(string, VALUES);
    }

    private AxisDirection(String string, AxisDirection axisDirection) {
        this(string);
        if (axisDirection.opposite != null) {
            throw new IllegalArgumentException(String.valueOf(axisDirection));
        }
        this.opposite = axisDirection;
        axisDirection.opposite = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AxisDirection[] values() {
        List list = VALUES;
        synchronized (list) {
            return VALUES.toArray(new AxisDirection[VALUES.size()]);
        }
    }

    public CodeList[] family() {
        return AxisDirection.values();
    }

    public AxisDirection opposite() {
        return this.opposite;
    }

    public AxisDirection absolute() {
        AxisDirection axisDirection = this.opposite;
        if (axisDirection != null && axisDirection.ordinal() < this.ordinal()) {
            return axisDirection;
        }
        return this;
    }

    public static synchronized AxisDirection valueOf(String string) {
        if (string == null) {
            return null;
        }
        Iterator iterator = VALUES.iterator();
        while (iterator.hasNext()) {
            AxisDirection axisDirection = (AxisDirection)iterator.next();
            if (!string.equalsIgnoreCase(axisDirection.name())) continue;
            return axisDirection;
        }
        return new AxisDirection(string);
    }

    static {
        AxisDirection.OTHER.opposite = OTHER = new AxisDirection("OTHER");
        NORTH = new AxisDirection("NORTH");
        NORTH_NORTH_EAST = new AxisDirection("NORTH_NORTH_EAST");
        NORTH_EAST = new AxisDirection("NORTH_EAST");
        EAST_NORTH_EAST = new AxisDirection("EAST_NORTH_EAST");
        EAST = new AxisDirection("EAST");
        EAST_SOUTH_EAST = new AxisDirection("EAST_SOUTH_EAST");
        SOUTH_EAST = new AxisDirection("SOUTH_EAST");
        SOUTH_SOUTH_EAST = new AxisDirection("SOUTH_SOUTH_EAST");
        SOUTH = new AxisDirection("SOUTH", NORTH);
        SOUTH_SOUTH_WEST = new AxisDirection("SOUTH_SOUTH_WEST", NORTH_NORTH_EAST);
        SOUTH_WEST = new AxisDirection("SOUTH_WEST", NORTH_EAST);
        WEST_SOUTH_WEST = new AxisDirection("WEST_SOUTH_WEST", EAST_NORTH_EAST);
        WEST = new AxisDirection("WEST", EAST);
        WEST_NORTH_WEST = new AxisDirection("WEST_NORTH_WEST", EAST_SOUTH_EAST);
        NORTH_WEST = new AxisDirection("NORTH_WEST", SOUTH_EAST);
        NORTH_NORTH_WEST = new AxisDirection("NORTH_NORTH_WEST", SOUTH_SOUTH_EAST);
        UP = new AxisDirection("UP");
        DOWN = new AxisDirection("DOWN", UP);
        GEOCENTRIC_X = new AxisDirection("GEOCENTRIC_X");
        GEOCENTRIC_Y = new AxisDirection("GEOCENTRIC_Y");
        GEOCENTRIC_Z = new AxisDirection("GEOCENTRIC_Z");
        FUTURE = new AxisDirection("FUTURE");
        PAST = new AxisDirection("PAST", FUTURE);
        COLUMN_POSITIVE = new AxisDirection("COLUMN_POSITIVE");
        COLUMN_NEGATIVE = new AxisDirection("COLUMN_NEGATIVE", COLUMN_POSITIVE);
        ROW_POSITIVE = new AxisDirection("ROW_POSITIVE");
        ROW_NEGATIVE = new AxisDirection("ROW_NEGATIVE", ROW_POSITIVE);
        DISPLAY_RIGHT = new AxisDirection("DISPLAY_RIGHT");
        DISPLAY_LEFT = new AxisDirection("DISPLAY_LEFT", DISPLAY_RIGHT);
        DISPLAY_UP = new AxisDirection("DISPLAY_UP");
        DISPLAY_DOWN = new AxisDirection("DISPLAY_DOWN", DISPLAY_UP);
    }
}

