/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.Interval;
import org.joda.time.JodaTimePermission;
import org.joda.time.PeriodType;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.ISOChronology;

public class DateTimeUtils {
    private static final SystemMillisProvider SYSTEM_MILLIS_PROVIDER = new SystemMillisProvider();
    private static MillisProvider cMillisProvider = SYSTEM_MILLIS_PROVIDER;

    protected DateTimeUtils() {
    }

    public static final long currentTimeMillis() {
        return cMillisProvider.getMillis();
    }

    public static final void setCurrentMillisSystem() throws SecurityException {
        DateTimeUtils.checkPermission();
        cMillisProvider = SYSTEM_MILLIS_PROVIDER;
    }

    public static final void setCurrentMillisFixed(long l) throws SecurityException {
        DateTimeUtils.checkPermission();
        cMillisProvider = new FixedMillisProvider(l);
    }

    public static final void setCurrentMillisOffset(long l) throws SecurityException {
        DateTimeUtils.checkPermission();
        cMillisProvider = l == 0L ? SYSTEM_MILLIS_PROVIDER : new OffsetMillisProvider(l);
    }

    private static void checkPermission() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JodaTimePermission("CurrentTime.setProvider"));
        }
    }

    public static final long getInstantMillis(ReadableInstant readableInstant) {
        if (readableInstant == null) {
            return DateTimeUtils.currentTimeMillis();
        }
        return readableInstant.getMillis();
    }

    public static final Chronology getInstantChronology(ReadableInstant readableInstant) {
        if (readableInstant == null) {
            return ISOChronology.getInstance();
        }
        Chronology chronology = readableInstant.getChronology();
        if (chronology == null) {
            return ISOChronology.getInstance();
        }
        return chronology;
    }

    public static final Chronology getIntervalChronology(ReadableInstant readableInstant, ReadableInstant readableInstant2) {
        Chronology chronology = null;
        if (readableInstant != null) {
            chronology = readableInstant.getChronology();
        } else if (readableInstant2 != null) {
            chronology = readableInstant2.getChronology();
        }
        if (chronology == null) {
            chronology = ISOChronology.getInstance();
        }
        return chronology;
    }

    public static final Chronology getIntervalChronology(ReadableInterval readableInterval) {
        if (readableInterval == null) {
            return ISOChronology.getInstance();
        }
        Chronology chronology = readableInterval.getChronology();
        if (chronology == null) {
            return ISOChronology.getInstance();
        }
        return chronology;
    }

    public static final ReadableInterval getReadableInterval(ReadableInterval readableInterval) {
        if (readableInterval == null) {
            long l = DateTimeUtils.currentTimeMillis();
            readableInterval = new Interval(l, l);
        }
        return readableInterval;
    }

    public static final Chronology getChronology(Chronology chronology) {
        if (chronology == null) {
            return ISOChronology.getInstance();
        }
        return chronology;
    }

    public static final DateTimeZone getZone(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            return DateTimeZone.getDefault();
        }
        return dateTimeZone;
    }

    public static final PeriodType getPeriodType(PeriodType periodType) {
        if (periodType == null) {
            return PeriodType.standard();
        }
        return periodType;
    }

    public static final long getDurationMillis(ReadableDuration readableDuration) {
        if (readableDuration == null) {
            return 0L;
        }
        return readableDuration.getMillis();
    }

    public static final boolean isContiguous(ReadablePartial readablePartial) {
        if (readablePartial == null) {
            throw new IllegalArgumentException("Partial must not be null");
        }
        DurationFieldType durationFieldType = null;
        int n = 0;
        while (n < readablePartial.size()) {
            DateTimeField dateTimeField = readablePartial.getField(n);
            if (n > 0 && dateTimeField.getRangeDurationField().getType() != durationFieldType) {
                return false;
            }
            durationFieldType = dateTimeField.getDurationField().getType();
            ++n;
        }
        return true;
    }

    static class OffsetMillisProvider
    extends MillisProvider {
        private final long iMillis;

        OffsetMillisProvider(long l) {
            this.iMillis = l;
        }

        long getMillis() {
            return System.currentTimeMillis() + this.iMillis;
        }
    }

    static class FixedMillisProvider
    extends MillisProvider {
        private final long iMillis;

        FixedMillisProvider(long l) {
            this.iMillis = l;
        }

        long getMillis() {
            return this.iMillis;
        }
    }

    static class SystemMillisProvider
    extends MillisProvider {
        SystemMillisProvider() {
        }

        long getMillis() {
            return System.currentTimeMillis();
        }
    }

    static abstract class MillisProvider {
        MillisProvider() {
        }

        abstract long getMillis();
    }
}

