/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.resources.Utilities;
import org.geotools.util.WeakCollectionCleaner;

public class WeakValueHashMap
extends AbstractMap {
    private static final int MIN_CAPACITY = 7;
    private static final float LOAD_FACTOR = 0.75f;
    private Entry[] table;
    private int count;
    private int threshold;
    private long lastRehashTime;
    private static final long HOLD_TIME = 20000L;

    public WeakValueHashMap() {
        this.table = new Entry[7];
        this.threshold = Math.round((float)this.table.length * 0.75f);
        this.lastRehashTime = System.currentTimeMillis();
    }

    public WeakValueHashMap(int initialSize) {
        this.table = new Entry[initialSize];
        this.threshold = Math.round((float)this.table.length * 0.75f);
        this.lastRehashTime = System.currentTimeMillis();
    }

    public WeakValueHashMap(Map map) {
        this();
        this.putAll(map);
    }

    private synchronized void removeEntry(Entry toRemove) {
        assert (this.valid()) : this.count;
        int i = toRemove.index;
        if (i < this.table.length) {
            Entry prev = null;
            Entry e = this.table[i];
            while (e != null) {
                if (e == toRemove) {
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        this.table[i] = e.next;
                    }
                    --this.count;
                    assert (this.valid());
                    if (this.count <= this.threshold / 4) {
                        this.rehash(false);
                    }
                    return;
                }
                prev = e;
                e = e.next;
            }
        }
        assert (this.valid());
    }

    private void rehash(boolean augmentation) {
        Level level;
        assert (Thread.holdsLock(this));
        assert (this.valid());
        long currentTime = System.currentTimeMillis();
        int capacity = Math.max(Math.round((float)this.count / 0.375f), this.count + 7);
        if (augmentation ? capacity <= this.table.length : capacity >= this.table.length || currentTime - this.lastRehashTime < 20000L) {
            return;
        }
        this.lastRehashTime = currentTime;
        Entry[] oldTable = this.table;
        this.table = new Entry[capacity];
        this.threshold = Math.round((float)capacity * 0.75f);
        for (int i = 0; i < oldTable.length; ++i) {
            Entry old = oldTable[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                Object key = e.key;
                if (key != null) {
                    int index;
                    e.index = index = (key.hashCode() & Integer.MAX_VALUE) % this.table.length;
                    e.next = this.table[index];
                    this.table[index] = e;
                    continue;
                }
                --this.count;
            }
        }
        Logger logger = Logger.getLogger("org.geotools.util");
        if (logger.isLoggable(level = Level.FINEST)) {
            LogRecord record = new LogRecord(level, "Rehash from " + oldTable.length + " to " + this.table.length);
            record.setSourceMethodName(augmentation ? "unique" : "remove");
            record.setSourceClassName(WeakValueHashMap.class.getName());
            logger.log(record);
        }
        assert (this.valid());
    }

    private boolean valid() {
        int n = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Entry e = this.table[i];
            while (e != null) {
                ++n;
                e = e.next;
            }
        }
        if (n != this.count) {
            this.count = n;
            return false;
        }
        return true;
    }

    public synchronized int size() {
        assert (this.valid());
        return this.count;
    }

    public synchronized boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public synchronized Object get(Object key) {
        assert (WeakCollectionCleaner.DEFAULT.isAlive());
        assert (this.valid()) : this.count;
        int index = (key.hashCode() & Integer.MAX_VALUE) % this.table.length;
        Entry e = this.table[index];
        while (e != null) {
            if (key.equals(e.key)) {
                return e.get();
            }
            e = e.next;
        }
        return null;
    }

    private synchronized Object intern(Object key, Object value) {
        assert (WeakCollectionCleaner.DEFAULT.isAlive());
        assert (this.valid()) : this.count;
        Object oldValue = null;
        int hash = key.hashCode() & Integer.MAX_VALUE;
        int index = hash % this.table.length;
        Entry e = this.table[index];
        while (e != null) {
            if (key.equals(e.key)) {
                oldValue = e.get();
                e.clear();
            }
            e = e.next;
        }
        if (value != null) {
            if (this.count >= this.threshold) {
                this.rehash(true);
                index = hash % this.table.length;
            }
            this.table[index] = new Entry(key, value, this.table[index], index);
            ++this.count;
        }
        assert (this.valid());
        return oldValue;
    }

    public Object put(Object key, Object value) {
        if (value == null) {
            throw new NullPointerException("Null value not allowed");
        }
        return this.intern(key, value);
    }

    public Object remove(Object key) {
        return this.intern(key, null);
    }

    public synchronized void clear() {
        Arrays.fill(this.table, null);
        this.count = 0;
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    private final class Entry
    extends WeakReference
    implements Map.Entry {
        Object key;
        Entry next;
        int index;

        Entry(Object key, Object value, Entry next, int index) {
            super(value, WeakCollectionCleaner.DEFAULT.referenceQueue);
            this.key = key;
            this.next = next;
            this.index = index;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.get();
        }

        public Object setValue(Object value) {
            if (value != null) {
                throw new UnsupportedOperationException();
            }
            Object old = this.get();
            this.clear();
            return old;
        }

        public void clear() {
            super.clear();
            WeakValueHashMap.this.removeEntry(this);
            this.key = null;
        }

        public boolean equals(Object other) {
            if (other instanceof Map.Entry) {
                Map.Entry that = (Map.Entry)other;
                return Utilities.equals(this.getKey(), that.getKey()) && Utilities.equals(this.getValue(), that.getValue());
            }
            return false;
        }

        public int hashCode() {
            Object val = this.get();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (val == null ? 0 : val.hashCode());
        }
    }
}

