/*
 * Decompiled with CFR 0.152.
 */
package org.postgis;

import java.sql.SQLException;
import org.postgis.Geometry;
import org.postgresql.util.PGtokenizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Point
extends Geometry {
    private static final long serialVersionUID = 256L;
    public static final boolean CUTINTS = true;
    public double x;
    public double y;
    public double z;
    public double m;

    public int hashCode() {
        return super.hashCode() ^ Point.hashCode(this.x) ^ Point.hashCode(this.y) ^ Point.hashCode(this.z) ^ Point.hashCode(this.m);
    }

    public static int hashCode(double d) {
        long l = Double.doubleToLongBits(d);
        return (int)(l ^ l >>> 32);
    }

    protected boolean equalsintern(Geometry geometry) {
        Point point = (Point)geometry;
        return this.equals(point);
    }

    public final boolean equals(Point point) {
        boolean bl = false;
        if (this.x == point.x) {
            bl = true;
        }
        boolean bl2 = bl;
        boolean bl3 = false;
        if (this.y == point.y) {
            bl3 = true;
        }
        boolean bl4 = bl3;
        boolean bl5 = false;
        if (this.dimension == 2 || this.z == point.z) {
            bl5 = true;
        }
        boolean bl6 = bl5;
        boolean bl7 = false;
        if (!this.haveMeasure || this.m == point.m) {
            bl7 = true;
        }
        boolean bl8 = bl7;
        boolean bl9 = false;
        if (bl2 && bl4 && bl6 && bl8) {
            bl9 = true;
        }
        boolean bl10 = bl9;
        return bl10;
    }

    public Point getPoint(int n) {
        if (n == 0) {
            return this;
        }
        throw new ArrayIndexOutOfBoundsException("Point only has a single Point! " + n);
    }

    public Point getFirstPoint() {
        return this;
    }

    public Point getLastPoint() {
        return this;
    }

    public int numPoints() {
        return 1;
    }

    public void innerWKT(StringBuffer stringBuffer) {
        stringBuffer.append(this.x);
        Point.cutint(stringBuffer);
        stringBuffer.append(' ');
        stringBuffer.append(this.y);
        Point.cutint(stringBuffer);
        if (this.dimension == 3) {
            stringBuffer.append(' ');
            stringBuffer.append(this.z);
            Point.cutint(stringBuffer);
        }
        if (this.haveMeasure) {
            stringBuffer.append(' ');
            stringBuffer.append(this.m);
            Point.cutint(stringBuffer);
        }
    }

    private static final void cutint(StringBuffer stringBuffer) {
        int n = stringBuffer.length() - 2;
        if (stringBuffer.charAt(n + 1) == '0' && stringBuffer.charAt(n) == '.') {
            stringBuffer.setLength(n);
        }
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getM() {
        return this.m;
    }

    public void setX(double d) {
        this.x = d;
    }

    public void setY(double d) {
        this.y = d;
    }

    public void setZ(double d) {
        this.z = d;
    }

    public void setM(double d) {
        this.haveMeasure = true;
        this.m = d;
    }

    public void setX(int n) {
        this.x = n;
    }

    public void setY(int n) {
        this.y = n;
    }

    public void setZ(int n) {
        this.z = n;
    }

    public double distance(Point point) {
        if (this.dimension != point.dimension) {
            throw new IllegalArgumentException("Points have different dimensions!");
        }
        double d = this.x - point.x;
        switch (this.dimension) {
            case 1: {
                return Math.sqrt(d * d);
            }
            case 2: {
                double d2 = this.y - point.y;
                return Math.sqrt(d * d + d2 * d2);
            }
            case 3: {
                double d3 = this.y - point.y;
                double d4 = this.z - point.z;
                return Math.sqrt(d * d + d3 * d3 + d4 * d4);
            }
        }
        throw new IllegalArgumentException("Illegal dimension of Point" + this.dimension);
    }

    public boolean checkConsistency() {
        boolean bl = false;
        if (super.checkConsistency() && (this.dimension == 3 || this.z == 0.0) && (this.haveMeasure || this.m == 0.0)) {
            bl = true;
        }
        return bl;
    }

    private final /* synthetic */ void this() {
        this.m = 0.0;
    }

    public Point() {
        super(1);
        this.this();
    }

    public Point(double d, double d2, double d3) {
        this();
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.dimension = 3;
    }

    public Point(double d, double d2) {
        this();
        this.x = d;
        this.y = d2;
        this.z = 0.0;
        this.dimension = 2;
    }

    public Point(String string) throws SQLException {
        this(string, false);
    }

    protected Point(String string, boolean bl) throws SQLException {
        this();
        string = this.initSRID(string);
        if (string.indexOf("POINTM") == 0) {
            bl = true;
            string = string.substring(6).trim();
        } else if (string.indexOf("POINT") == 0) {
            string = string.substring(5).trim();
        }
        PGtokenizer pGtokenizer = new PGtokenizer(PGtokenizer.removePara((String)string), ' ');
        try {
            this.x = Double.valueOf(pGtokenizer.getToken(0));
            this.y = Double.valueOf(pGtokenizer.getToken(1));
            boolean bl2 = false;
            if (pGtokenizer.getSize() == 4) {
                bl2 = true;
            }
            if (pGtokenizer.getSize() == 3 && !(bl |= bl2) || pGtokenizer.getSize() == 4) {
                this.z = Double.valueOf(pGtokenizer.getToken(2));
                this.dimension = 3;
            } else {
                this.dimension = 2;
            }
            if (bl) {
                this.m = Double.valueOf(pGtokenizer.getToken(this.dimension));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("Error parsing Point: " + numberFormatException.toString());
        }
        this.haveMeasure = bl;
    }
}

