/*
 * Decompiled with CFR 0.152.
 */
package org.postgis;

import java.sql.SQLException;
import org.postgis.Geometry;
import org.postgis.GeometryCollection;
import org.postgis.LineString;
import org.postgis.MultiLineString;
import org.postgis.MultiPoint;
import org.postgis.MultiPolygon;
import org.postgis.Point;
import org.postgis.Polygon;
import org.postgis.binary.BinaryParser;
import org.postgresql.util.PGobject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PGgeometry
extends PGobject {
    private static final long serialVersionUID = 256L;
    public static final String SRIDPREFIX = "SRID=";
    Geometry geom;
    BinaryParser bp;

    public void setValue(String string) throws SQLException {
        this.geom = PGgeometry.geomFromString(string, this.bp);
    }

    public static Geometry geomFromString(String string) throws SQLException {
        return PGgeometry.geomFromString(string, false);
    }

    public static Geometry geomFromString(String string, boolean bl) throws SQLException {
        BinaryParser binaryParser = new BinaryParser();
        return PGgeometry.geomFromString(string, binaryParser, bl);
    }

    public static Geometry geomFromString(String string, BinaryParser binaryParser) throws SQLException {
        return PGgeometry.geomFromString(string, binaryParser, false);
    }

    public static Geometry geomFromString(String string, BinaryParser binaryParser, boolean bl) throws SQLException {
        Object object;
        string = string.trim();
        int n = -1;
        if (string.startsWith(SRIDPREFIX)) {
            object = PGgeometry.splitSRID(string);
            string = object[1].trim();
            n = Integer.parseInt(object[0].substring(5));
        }
        if (string.startsWith("00") || string.startsWith("01")) {
            object = binaryParser.parse(string);
        } else if (string.endsWith("EMPTY")) {
            object = new GeometryCollection();
        } else if (string.startsWith("MULTIPOLYGON")) {
            object = new MultiPolygon(string, bl);
        } else if (string.startsWith("MULTILINESTRING")) {
            object = new MultiLineString(string, bl);
        } else if (string.startsWith("MULTIPOINT")) {
            object = new MultiPoint(string, bl);
        } else if (string.startsWith("POLYGON")) {
            object = new Polygon(string, bl);
        } else if (string.startsWith("LINESTRING")) {
            object = new LineString(string, bl);
        } else if (string.startsWith("POINT")) {
            object = new Point(string, bl);
        } else if (string.startsWith("GEOMETRYCOLLECTION")) {
            object = new GeometryCollection(string, bl);
        } else {
            throw new SQLException("Unknown type: " + string);
        }
        if (n != -1) {
            object.srid = n;
        }
        return object;
    }

    public Geometry getGeometry() {
        return this.geom;
    }

    public void setGeometry(Geometry geometry) {
        this.geom = geometry;
    }

    public int getGeoType() {
        return this.geom.type;
    }

    public String toString() {
        return this.geom.toString();
    }

    public String getValue() {
        return this.geom.toString();
    }

    public Object clone() {
        return new PGgeometry(this.geom);
    }

    public static String[] splitSRID(String string) throws SQLException {
        int n = string.indexOf(59, 5);
        if (n == -1) {
            throw new SQLException("Error parsing Geometry - SRID not delimited with ';' ");
        }
        return new String[]{string.substring(0, n), string.substring(n + 1)};
    }

    private final /* synthetic */ void this() {
        this.bp = new BinaryParser();
    }

    public PGgeometry() {
        this.this();
        this.setType("geometry");
    }

    public PGgeometry(Geometry geometry) {
        this();
        this.geom = geometry;
    }

    public PGgeometry(String string) throws SQLException {
        this();
        this.setValue(string);
    }
}

