/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.wkt;

import java.lang.reflect.Array;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.units.BaseUnit;
import javax.units.NonSI;
import javax.units.SI;
import javax.units.Unit;
import javax.units.UnitFormat;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.wkt.Adapter;
import org.geotools.referencing.wkt.Formattable;
import org.geotools.referencing.wkt.Symbols;
import org.geotools.resources.Arguments;
import org.geotools.resources.Utilities;
import org.geotools.resources.XMath;
import org.geotools.resources.i18n.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.CodeList;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class Formatter {
    private static final Class[] AUTHORITY_EXCLUDE = new Class[]{CoordinateSystemAxis.class};
    private static final String NUMBER_COLOR = "\u001b[33m";
    private static final String INTEGER_COLOR = "\u001b[33m";
    private static final String UNIT_COLOR = "\u001b[33m";
    private static final String AXIS_COLOR = "\u001b[36m";
    private static final String CODELIST_COLOR = "\u001b[36m";
    private static final String PARAMETER_COLOR = "\u001b[32m";
    private static final String METHOD_COLOR = "\u001b[32m";
    private static final String DATUM_COLOR = "\u001b[32m";
    private static final String ERROR_COLOR = "\u001b[41m";
    private final Symbols symbols;
    Citation authority = Citations.OGC;
    boolean colorEnabled = false;
    private Unit linearUnit;
    private Unit angularUnit;
    private final NumberFormat numberFormat;
    private final UnitFormat unitFormat = UnitFormat.getAsciiInstance();
    private final FieldPosition dummy = new FieldPosition(0);
    StringBuffer buffer;
    int bufferBase;
    final int indentation;
    private int margin;
    private boolean lineChanged;
    private boolean invalidWKT;
    private Class unformattable;
    String warning;

    public Formatter() {
        this(Symbols.DEFAULT, 0);
    }

    public Formatter(Symbols symbols) {
        this(symbols, 0);
    }

    public Formatter(Symbols symbols, int indentation) {
        this.symbols = symbols;
        this.indentation = indentation;
        if (symbols == null) {
            throw new IllegalArgumentException(Errors.format(105, "symbols"));
        }
        if (indentation < 0) {
            throw new IllegalArgumentException(Errors.format(42, "indentation", new Integer(indentation)));
        }
        this.numberFormat = (NumberFormat)symbols.numberFormat.clone();
        this.buffer = new StringBuffer();
    }

    Formatter(Symbols symbols, NumberFormat numberFormat) {
        this.symbols = symbols;
        this.indentation = Formattable.getIndentation();
        this.numberFormat = numberFormat;
    }

    private void setColor(String color) {
        if (this.colorEnabled) {
            this.buffer.append(color);
        }
    }

    private void resetColor() {
        if (this.colorEnabled) {
            this.buffer.append("\u001b[39m");
        }
    }

    private static String getNameColor(IdentifiedObject object) {
        if (object instanceof Datum) {
            return "\u001b[32m";
        }
        if (object instanceof OperationMethod) {
            return "\u001b[32m";
        }
        if (object instanceof CoordinateSystemAxis) {
            return "\u001b[36m";
        }
        return null;
    }

    private void appendSeparator(boolean newLine) {
        char c;
        int length = this.buffer.length();
        do {
            if (length == this.bufferBase) {
                return;
            }
            if ((c = this.buffer.charAt(--length)) != this.symbols.open && c != this.symbols.openArray) continue;
            return;
        } while (Character.isWhitespace(c) || c == this.symbols.space);
        this.buffer.append(this.symbols.separator);
        this.buffer.append(this.symbols.space);
        if (newLine && this.indentation != 0) {
            this.buffer.append(System.getProperty("line.separator", "\n"));
            this.buffer.append(Utilities.spaces(this.margin));
            this.lineChanged = true;
        }
    }

    public void append(Formattable formattable) {
        Citation authority;
        IdentifiedObject info;
        this.appendSeparator(true);
        int base = this.buffer.length();
        this.buffer.append(this.symbols.open);
        IdentifiedObject identifiedObject = info = formattable instanceof IdentifiedObject ? (IdentifiedObject)formattable : null;
        if (info != null) {
            String c = Formatter.getNameColor(info);
            if (c != null) {
                this.setColor(c);
            }
            this.buffer.append(this.symbols.quote);
            this.buffer.append(this.getName(info));
            this.buffer.append(this.symbols.quote);
            if (c != null) {
                this.resetColor();
            }
        }
        this.indent(1);
        this.lineChanged = false;
        String keyword = formattable.formatWKT(this);
        if (this.colorEnabled && this.invalidWKT) {
            this.invalidWKT = false;
            this.buffer.insert(base, "\u001b[41m\u001b[49m");
            base += ERROR_COLOR.length();
        }
        this.buffer.insert(base, keyword);
        Identifier identifier = this.getIdentifier(info);
        if (identifier != null && Formatter.authorityAllowed(info) && (authority = identifier.getAuthority()) != null) {
            InternationalString inter2 = authority.getTitle();
            String title = inter2 != null ? inter2.toString(this.symbols.locale) : null;
            for (InternationalString inter2 : authority.getAlternateTitles()) {
                String candidate;
                if (inter2 == null || (candidate = inter2.toString(this.symbols.locale)) == null || title != null && candidate.length() >= title.length()) continue;
                title = candidate;
            }
            if (title != null) {
                this.appendSeparator(this.lineChanged);
                this.buffer.append("AUTHORITY");
                this.buffer.append(this.symbols.open);
                this.buffer.append(this.symbols.quote);
                this.buffer.append(title);
                this.buffer.append(this.symbols.quote);
                String code = identifier.getCode();
                if (code != null) {
                    this.buffer.append(this.symbols.separator);
                    this.buffer.append(this.symbols.quote);
                    this.buffer.append(code);
                    this.buffer.append(this.symbols.quote);
                }
                this.buffer.append(this.symbols.close);
            }
        }
        this.buffer.append(this.symbols.close);
        this.lineChanged = true;
        this.indent(-1);
    }

    public void append(IdentifiedObject info) {
        if (info instanceof Formattable) {
            this.append((Formattable)info);
        } else {
            this.append(new Adapter(info));
        }
    }

    public void append(MathTransform transform) {
        if (transform instanceof Formattable) {
            this.append((Formattable)transform);
        } else {
            this.append(new Adapter(transform));
        }
    }

    public void append(CodeList code) {
        if (code != null) {
            boolean needQuotes;
            this.appendSeparator(false);
            this.setColor("\u001b[36m");
            String name = code.name();
            boolean bl = needQuotes = name.indexOf(32) >= 0;
            if (needQuotes) {
                this.buffer.append(this.symbols.quote);
            }
            this.buffer.append(name);
            if (needQuotes) {
                this.buffer.append(this.symbols.quote);
                this.setInvalidWKT(code.getClass());
            }
            this.resetColor();
        }
    }

    public void append(GeneralParameterValue parameter) {
        if (parameter instanceof ParameterValueGroup) {
            Iterator it = ((ParameterValueGroup)parameter).values().iterator();
            while (it.hasNext()) {
                this.append((GeneralParameterValue)it.next());
            }
        }
        if (parameter instanceof ParameterValue) {
            ParameterValue param = (ParameterValue)parameter;
            ParameterDescriptor descriptor = (ParameterDescriptor)param.getDescriptor();
            Unit valueUnit = descriptor.getUnit();
            Unit unit = valueUnit;
            if (unit != null && !Unit.ONE.equals((Object)unit)) {
                if (this.linearUnit != null && unit.isCompatible(this.linearUnit)) {
                    unit = this.linearUnit;
                } else if (this.angularUnit != null && unit.isCompatible(this.angularUnit)) {
                    unit = this.angularUnit;
                }
            }
            this.appendSeparator(true);
            int start = this.buffer.length();
            this.buffer.append("PARAMETER");
            int stop = this.buffer.length();
            this.buffer.append(this.symbols.open);
            this.setColor("\u001b[32m");
            this.buffer.append(this.symbols.quote);
            this.buffer.append(this.getName((IdentifiedObject)descriptor));
            this.buffer.append(this.symbols.quote);
            this.resetColor();
            this.buffer.append(this.symbols.separator);
            this.buffer.append(this.symbols.space);
            if (unit != null) {
                double value;
                try {
                    value = param.doubleValue(unit);
                }
                catch (IllegalStateException exception) {
                    if (this.colorEnabled) {
                        this.buffer.insert(stop, "\u001b[49m");
                        this.buffer.insert(start, ERROR_COLOR);
                    }
                    this.warning = exception.getLocalizedMessage();
                    value = Double.NaN;
                }
                if (!unit.equals((Object)valueUnit)) {
                    value = XMath.fixRoundingError(value, 9);
                }
                this.format(value);
            } else {
                this.appendObject(param.getValue());
            }
            this.buffer.append(this.symbols.close);
        }
    }

    private void appendObject(Object value) {
        if (value == null) {
            this.buffer.append("null");
            return;
        }
        if (value.getClass().isArray()) {
            this.buffer.append(this.symbols.openArray);
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                if (i != 0) {
                    this.buffer.append(this.symbols.separator);
                    this.buffer.append(this.symbols.space);
                }
                this.appendObject(Array.get(value, i));
            }
            this.buffer.append(this.symbols.closeArray);
            return;
        }
        if (value instanceof Number) {
            this.format((Number)value);
        } else {
            this.buffer.append(this.symbols.quote);
            this.buffer.append(value);
            this.buffer.append(this.symbols.quote);
        }
    }

    public void append(int number) {
        this.appendSeparator(false);
        this.format(number);
    }

    public void append(double number) {
        this.appendSeparator(false);
        this.format(number);
    }

    public void append(Unit unit) {
        if (unit != null) {
            this.appendSeparator(this.lineChanged);
            this.buffer.append("UNIT");
            this.buffer.append(this.symbols.open);
            this.setColor("\u001b[33m");
            this.buffer.append(this.symbols.quote);
            if (NonSI.DEGREE_ANGLE.equals((Object)unit)) {
                this.buffer.append("degree");
            } else {
                this.unitFormat.format((Object)unit, this.buffer, this.dummy);
            }
            this.buffer.append(this.symbols.quote);
            this.resetColor();
            BaseUnit base = null;
            if (SI.METER.isCompatible(unit)) {
                base = SI.METER;
            } else if (SI.SECOND.isCompatible(unit)) {
                base = SI.SECOND;
            } else if (SI.RADIAN.isCompatible(unit) && !Unit.ONE.equals((Object)unit)) {
                base = SI.RADIAN;
            }
            if (base != null) {
                this.append(unit.getConverterTo((Unit)base).convert(1.0));
            }
            this.buffer.append(this.symbols.close);
        }
    }

    public void append(String text) {
        this.appendSeparator(false);
        this.buffer.append(this.symbols.quote);
        this.buffer.append(text);
        this.buffer.append(this.symbols.quote);
    }

    private void format(Number number) {
        if (number instanceof Byte || number instanceof Short || number instanceof Integer) {
            this.format(number.intValue());
        } else {
            this.format(number.doubleValue());
        }
    }

    private void format(int number) {
        this.setColor("\u001b[33m");
        int fraction = this.numberFormat.getMinimumFractionDigits();
        this.numberFormat.setMinimumFractionDigits(0);
        this.numberFormat.format(number, this.buffer, this.dummy);
        this.numberFormat.setMinimumFractionDigits(fraction);
        this.resetColor();
    }

    private void format(double number) {
        this.setColor("\u001b[33m");
        this.numberFormat.format(number, this.buffer, this.dummy);
        this.resetColor();
    }

    private void indent(int amount) {
        this.margin = Math.max(0, this.margin + this.indentation * amount);
    }

    private static boolean authorityAllowed(IdentifiedObject info) {
        for (int i = 0; i < AUTHORITY_EXCLUDE.length; ++i) {
            if (!AUTHORITY_EXCLUDE[i].isInstance(info)) continue;
            return false;
        }
        return true;
    }

    public Identifier getIdentifier(IdentifiedObject info) {
        Set identifiers;
        Identifier first = null;
        if (info != null && (identifiers = info.getIdentifiers()) != null) {
            for (Identifier id : identifiers) {
                if (this.authorityMatches(id.getAuthority())) {
                    return id;
                }
                if (first != null) continue;
                first = id;
            }
        }
        return first;
    }

    private boolean authorityMatches(Citation citation) {
        if (this.authority == citation) {
            return true;
        }
        return citation != null && this.authority.getTitle().toString(Locale.US).equalsIgnoreCase(citation.getTitle().toString(Locale.US));
    }

    public String getName(IdentifiedObject info) {
        Collection aliases;
        ReferenceIdentifier name = info.getName();
        if (!this.authorityMatches(name.getAuthority()) && (aliases = info.getAlias()) != null) {
            for (GenericName alias : aliases) {
                Identifier candidate;
                if (!(alias instanceof Identifier) || !this.authorityMatches((candidate = (Identifier)alias).getAuthority())) continue;
                return candidate.getCode();
            }
            String title = this.authority.getTitle().toString(Locale.US);
            for (GenericName alias : aliases) {
                GenericName scope = alias.getScope();
                if (scope == null || !title.equalsIgnoreCase(scope.toString())) continue;
                return alias.asLocalName().toString();
            }
        }
        return name.getCode();
    }

    public Unit getLinearUnit() {
        return this.linearUnit;
    }

    public void setLinearUnit(Unit unit) {
        if (unit != null && !SI.METER.isCompatible(unit)) {
            throw new IllegalArgumentException(Errors.format(83, unit));
        }
        this.linearUnit = unit;
    }

    public Unit getAngularUnit() {
        return this.angularUnit;
    }

    public void setAngularUnit(Unit unit) {
        if (unit != null && (!SI.RADIAN.isCompatible(unit) || Unit.ONE.equals((Object)unit))) {
            throw new IllegalArgumentException(Errors.format(77, unit));
        }
        this.angularUnit = unit;
    }

    public boolean isInvalidWKT() {
        return this.unformattable != null || this.buffer != null && this.buffer.length() == 0;
    }

    final Class getUnformattableClass() {
        return this.unformattable;
    }

    public void setInvalidWKT(Class unformattable) {
        this.unformattable = unformattable;
        this.invalidWKT = true;
    }

    public void setInvalidWKT() {
        this.setInvalidWKT(IdentifiedObject.class);
    }

    public String toString() {
        return this.buffer.toString();
    }

    public void clear() {
        if (this.buffer != null) {
            this.buffer.setLength(0);
        }
        this.linearUnit = null;
        this.angularUnit = null;
        this.unformattable = null;
        this.warning = null;
        this.invalidWKT = false;
        this.lineChanged = false;
        this.margin = 0;
    }

    public static void main(String[] args) {
        Arguments arguments = new Arguments(args);
        int indentation = arguments.getRequiredInteger("Indentation");
        args = arguments.getRemainingArguments(0);
        Formattable.setIndentation(indentation);
    }
}

