/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.module.photocast.io;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.photocast.PhotocastModuleImpl;
import com.sun.syndication.feed.module.photocast.types.Metadata;
import com.sun.syndication.feed.module.photocast.types.PhotoDate;
import com.sun.syndication.io.ModuleParser;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.logging.Logger;
import org.jdom.Element;
import org.jdom.Namespace;

public class Parser
implements ModuleParser {
    private static final Logger LOG = Logger.getAnonymousLogger();
    private static final Namespace NS = Namespace.getNamespace((String)"http://www.apple.com/ilife/wallpapers");
    static final DateFormat PHOTO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    static final DateFormat CROP_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");

    public Module parse(Element element) {
        if (element.getName().equals("channel") || element.getName().equals("feed")) {
            return new PhotocastModuleImpl();
        }
        if (element.getChild("metadata", NS) == null && element.getChild("image", NS) == null) {
            return null;
        }
        PhotocastModuleImpl pm = new PhotocastModuleImpl();
        List children = element.getChildren();
        for (Element e : children) {
            if (!e.getNamespace().equals((Object)NS)) continue;
            if (e.getName().equals("photoDate")) {
                try {
                    pm.setPhotoDate(PHOTO_DATE_FORMAT.parse(e.getText()));
                }
                catch (Exception ex) {
                    LOG.warning("Unable to parse photoDate: " + e.getText() + " " + ex.toString());
                }
                continue;
            }
            if (e.getName().equals("cropDate")) {
                try {
                    pm.setCropDate(CROP_DATE_FORMAT.parse(e.getText()));
                }
                catch (Exception ex) {
                    LOG.warning("Unable to parse cropDate: " + e.getText() + " " + ex.toString());
                }
                continue;
            }
            if (e.getName().equals("thumbnail")) {
                try {
                    pm.setThumbnailUrl(new URL(e.getText()));
                }
                catch (Exception ex) {
                    LOG.warning("Unable to parse thumnail: " + e.getText() + " " + ex.toString());
                }
                continue;
            }
            if (e.getName().equals("image")) {
                try {
                    pm.setImageUrl(new URL(e.getText()));
                }
                catch (Exception ex) {
                    LOG.warning("Unable to parse image: " + e.getText() + " " + ex.toString());
                }
                continue;
            }
            if (!e.getName().equals("metadata")) continue;
            String comments = "";
            PhotoDate photoDate = null;
            if (e.getChildText("PhotoDate") != null) {
                try {
                    photoDate = new PhotoDate(Double.parseDouble(e.getChildText("PhotoDate")));
                }
                catch (Exception ex) {
                    LOG.warning("Unable to parse PhotoDate: " + e.getText() + " " + ex.toString());
                }
            }
            if (e.getChildText("Comments") != null) {
                comments = e.getChildText("Comments");
            }
            pm.setMetadata(new Metadata(photoDate, comments));
        }
        return pm;
    }

    public String getNamespaceUri() {
        return "http://www.apple.com/ilife/wallpapers";
    }
}

