/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.module.opensearch.impl;

import com.sun.syndication.feed.atom.Link;
import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.opensearch.entity.OSQuery;
import com.sun.syndication.feed.module.opensearch.impl.OpenSearchModuleImpl;
import com.sun.syndication.io.ModuleParser;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Parent;

public class OpenSearchModuleParser
implements ModuleParser {
    private static final Namespace OS_NS = Namespace.getNamespace((String)"opensearch", (String)"http://a9.com/-/spec/opensearch/1.1/");

    public String getNamespaceUri() {
        return "http://a9.com/-/spec/opensearch/1.1/";
    }

    public Module parse(Element dcRoot) {
        URL baseURI = OpenSearchModuleParser.findBaseURI(dcRoot);
        boolean foundSomething = false;
        OpenSearchModuleImpl osm = new OpenSearchModuleImpl();
        Element e2 = dcRoot.getChild("totalResults", OS_NS);
        if (e2 != null) {
            foundSomething = true;
            try {
                osm.setTotalResults(Integer.parseInt(e2.getText()));
            }
            catch (NumberFormatException ex) {
                System.err.println("Warning: The element totalResults must be an integer value: " + ex.getMessage());
            }
        }
        e2 = dcRoot.getChild("itemsPerPage", OS_NS);
        try {
            osm.setItemsPerPage(Integer.parseInt(e2.getText()));
        }
        catch (NumberFormatException ex) {
            System.err.println("Warning: The element itemsPerPage must be an integer value: " + ex.getMessage());
        }
        e2 = dcRoot.getChild("startIndex", OS_NS);
        try {
            osm.setStartIndex(Integer.parseInt(e2.getText()));
        }
        catch (NumberFormatException ex) {
            System.err.println("Warning: The element startIndex must be an integer value: " + ex.getMessage());
        }
        List queries = dcRoot.getChildren("Query", OS_NS);
        if (queries != null && queries.size() > 0) {
            LinkedList<OSQuery> osqList = new LinkedList<OSQuery>();
            for (Element e2 : queries) {
                osqList.add(OpenSearchModuleParser.parseQuery(e2));
            }
            osm.setQueries(osqList);
        }
        if ((e2 = dcRoot.getChild("link", OS_NS)) != null) {
            osm.setLink(OpenSearchModuleParser.parseLink(e2, baseURI));
        }
        return foundSomething ? osm : null;
    }

    private static OSQuery parseQuery(Element e) {
        OSQuery query = new OSQuery();
        String att = e.getAttributeValue("role");
        query.setRole(att);
        att = e.getAttributeValue("osd");
        query.setOsd(att);
        att = e.getAttributeValue("searchTerms");
        query.setSearchTerms(att);
        att = e.getAttributeValue("title");
        query.setTitle(att);
        try {
            att = e.getAttributeValue("totalResults");
            if (att != null) {
                query.setTotalResults(Integer.parseInt(att));
            }
            if ((att = e.getAttributeValue("startPage")) != null) {
                query.setStartPage(Integer.parseInt(att));
            }
        }
        catch (NumberFormatException ex) {
            System.err.println("Warning: Exception caught while trying to parse a non-numeric Query attribute " + ex.getMessage());
        }
        return query;
    }

    private static Link parseLink(Element e, URL baseURI) {
        Link link = new Link();
        String att = e.getAttributeValue("rel");
        if (att != null) {
            link.setRel(att);
        }
        if ((att = e.getAttributeValue("type")) != null) {
            link.setType(att);
        }
        if ((att = e.getAttributeValue("href")) != null) {
            if (OpenSearchModuleParser.isRelativeURI(att)) {
                link.setHref(OpenSearchModuleParser.resolveURI(baseURI, (Parent)e, ""));
            } else {
                link.setHref(att);
            }
        }
        if ((att = e.getAttributeValue("hreflang")) != null) {
            link.setHreflang(att);
        }
        att = e.getAttributeValue("length");
        return link;
    }

    private static boolean isRelativeURI(String uri) {
        return !uri.startsWith("http://") && !uri.startsWith("https://") && !uri.startsWith("/");
    }

    private static String resolveURI(URL baseURI, Parent parent, String url) {
        String string = url = url.equals(".") || url.equals("./") ? "" : url;
        if (OpenSearchModuleParser.isRelativeURI(url) && parent != null && parent instanceof Element) {
            String xmlBase;
            Attribute baseAtt = ((Element)parent).getAttribute("base", Namespace.XML_NAMESPACE);
            String string2 = xmlBase = baseAtt == null ? "" : baseAtt.getValue();
            if (!OpenSearchModuleParser.isRelativeURI(xmlBase) && !xmlBase.endsWith("/")) {
                xmlBase = xmlBase.substring(0, xmlBase.lastIndexOf("/") + 1);
            }
            return OpenSearchModuleParser.resolveURI(baseURI, parent.getParent(), xmlBase + url);
        }
        if (OpenSearchModuleParser.isRelativeURI(url) && parent == null) {
            return baseURI + url;
        }
        if (baseURI != null && url.startsWith("/")) {
            String hostURI = baseURI.getProtocol() + "://" + baseURI.getHost();
            if (baseURI.getPort() != baseURI.getDefaultPort()) {
                hostURI = hostURI + ":" + baseURI.getPort();
            }
            return hostURI + url;
        }
        return url;
    }

    private static URL findBaseURI(Element root) {
        URL baseURI = null;
        List linksList = root.getChildren("link", OS_NS);
        if (linksList != null) {
            Element link;
            Iterator links = linksList.iterator();
            while (links.hasNext() && root.equals((Object)(link = (Element)links.next()).getParent())) {
                String href = link.getAttribute("href").getValue();
                if (link.getAttribute("rel", OS_NS) != null && !link.getAttribute("rel", OS_NS).getValue().equals("alternate")) continue;
                href = OpenSearchModuleParser.resolveURI(null, (Parent)link, href);
                try {
                    baseURI = new URL(href);
                    break;
                }
                catch (MalformedURLException e) {
                    System.err.println("Base URI is malformed: " + href);
                }
            }
        }
        return baseURI;
    }
}

