/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.postgis;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Polygon;
import java.sql.Connection;
import org.hibernatespatial.AbstractDBGeometryType;
import org.postgis.Geometry;
import org.postgis.LineString;
import org.postgis.MultiLineString;
import org.postgis.MultiPolygon;
import org.postgis.PGgeometry;
import org.postgis.Point;

public class PGGeometryUserType
extends AbstractDBGeometryType {
    private static final int[] geometryTypes = new int[]{2002};
    private static final GeometryFactory geomFactory = new GeometryFactory();

    public int[] sqlTypes() {
        return geometryTypes;
    }

    public com.vividsolutions.jts.geom.Geometry convert2JTS(Object object) {
        if (object == null) {
            return null;
        }
        PGgeometry geom = (PGgeometry)object;
        com.vividsolutions.jts.geom.Point out = null;
        switch (geom.getGeoType()) {
            case 1: {
                out = this.convertPoint((Point)geom.getGeometry());
                break;
            }
            case 2: {
                out = this.convertLineString((LineString)geom.getGeometry());
                break;
            }
            case 3: {
                out = this.convertPolygon((org.postgis.Polygon)geom.getGeometry());
                break;
            }
            case 5: {
                out = this.convertMultiLineString((MultiLineString)geom.getGeometry());
                break;
            }
            case 4: {
                out = this.convertMultiPoint((org.postgis.MultiPoint)geom.getGeometry());
                break;
            }
            case 6: {
                out = this.convertMultiPolygon((MultiPolygon)geom.getGeometry());
                break;
            }
            case 7: {
                out = this.convertGeometryCollection((org.postgis.GeometryCollection)geom.getGeometry());
            }
        }
        return out;
    }

    private com.vividsolutions.jts.geom.Geometry convertGeometryCollection(org.postgis.GeometryCollection collection) {
        Geometry[] geometries = collection.getGeometries();
        GeometryCollection[] jtsGeometries = new GeometryCollection[geometries.length];
        int i = 0;
        while (i < geometries.length) {
            jtsGeometries[i] = this.convert2JTS(geometries[i]);
            ++i;
        }
        GeometryCollection jtsGCollection = geomFactory.createGeometryCollection((com.vividsolutions.jts.geom.Geometry[])jtsGeometries);
        return jtsGCollection;
    }

    private com.vividsolutions.jts.geom.Geometry convertMultiPolygon(MultiPolygon pgMultiPolygon) {
        Polygon[] polygons = new Polygon[pgMultiPolygon.numPolygons()];
        int i = 0;
        while (i < polygons.length) {
            org.postgis.Polygon pgPolygon = pgMultiPolygon.getPolygon(i);
            polygons[i] = (Polygon)this.convertPolygon(pgPolygon);
            ++i;
        }
        com.vividsolutions.jts.geom.MultiPolygon out = geomFactory.createMultiPolygon(polygons);
        out.setSRID(pgMultiPolygon.srid);
        return out;
    }

    private com.vividsolutions.jts.geom.Geometry convertMultiPoint(org.postgis.MultiPoint pgMultiPoint) {
        com.vividsolutions.jts.geom.Point[] points = new com.vividsolutions.jts.geom.Point[pgMultiPoint.numPoints()];
        int i = 0;
        while (i < points.length) {
            points[i] = this.convertPoint(pgMultiPoint.getPoint(i));
            ++i;
        }
        MultiPoint out = geomFactory.createMultiPoint(points);
        out.setSRID(pgMultiPoint.srid);
        return out;
    }

    private com.vividsolutions.jts.geom.Geometry convertMultiLineString(MultiLineString mlstr) {
        com.vividsolutions.jts.geom.LineString[] lstrs = new com.vividsolutions.jts.geom.LineString[mlstr.numLines()];
        int i = 0;
        while (i < mlstr.numLines()) {
            lstrs[i] = geomFactory.createLineString(this.toJTSCoordinates(mlstr.getLine(i).getPoints()));
            ++i;
        }
        com.vividsolutions.jts.geom.MultiLineString out = geomFactory.createMultiLineString(lstrs);
        out.setSRID(mlstr.srid);
        return out;
    }

    protected com.vividsolutions.jts.geom.Geometry convertPolygon(org.postgis.Polygon polygon) {
        LinearRing shell = geomFactory.createLinearRing(this.toJTSCoordinates(polygon.getRing(0).getPoints()));
        Polygon out = null;
        if (polygon.numRings() > 1) {
            LinearRing[] rings = new LinearRing[polygon.numRings() - 1];
            int r = 1;
            while (r < polygon.numRings()) {
                rings[r - 1] = geomFactory.createLinearRing(this.toJTSCoordinates(polygon.getRing(r).getPoints()));
                ++r;
            }
            out = geomFactory.createPolygon(shell, rings);
        } else {
            out = geomFactory.createPolygon(shell, null);
        }
        out.setSRID(polygon.srid);
        return out;
    }

    protected com.vividsolutions.jts.geom.Point convertPoint(Point pnt) {
        com.vividsolutions.jts.geom.Point g = geomFactory.createPoint(new Coordinate(pnt.x, pnt.y));
        g.setSRID(pnt.getSrid());
        return g;
    }

    protected com.vividsolutions.jts.geom.LineString convertLineString(LineString lstr) {
        com.vividsolutions.jts.geom.LineString out = geomFactory.createLineString(this.toJTSCoordinates(lstr.getPoints()));
        out.setSRID(lstr.getSrid());
        return out;
    }

    private Coordinate[] toJTSCoordinates(Point[] points) {
        Coordinate[] coordinates = new Coordinate[points.length];
        int i = 0;
        while (i < points.length) {
            coordinates[i] = new Coordinate(points[i].x, points[i].y);
            ++i;
        }
        return coordinates;
    }

    private Point[] toPoints(Coordinate[] coordinates) {
        Point[] points = new Point[coordinates.length];
        int i = 0;
        while (i < coordinates.length) {
            points[i] = new Point(coordinates[i].x, coordinates[i].y);
            ++i;
        }
        return points;
    }

    public Object conv2DBGeometry(com.vividsolutions.jts.geom.Geometry jtsGeom, Connection connection) {
        Point geom = null;
        if (jtsGeom.getClass() == com.vividsolutions.jts.geom.Point.class) {
            geom = this.convertJTSPoint((com.vividsolutions.jts.geom.Point)jtsGeom);
        } else if (jtsGeom.getClass() == com.vividsolutions.jts.geom.LineString.class) {
            geom = this.convertJTSLineString((com.vividsolutions.jts.geom.LineString)jtsGeom);
        } else if (jtsGeom.getClass() == com.vividsolutions.jts.geom.MultiLineString.class) {
            geom = this.convertJTSMultiLineSTring((com.vividsolutions.jts.geom.MultiLineString)jtsGeom);
        } else if (jtsGeom.getClass() == Polygon.class) {
            geom = this.convertJTSPolygon((Polygon)jtsGeom);
        } else if (jtsGeom.getClass() == MultiPoint.class) {
            geom = this.convertJTSMultiPoint((MultiPoint)jtsGeom);
        } else if (jtsGeom.getClass() == com.vividsolutions.jts.geom.MultiPolygon.class) {
            geom = this.convertJTSMultiPolygon((com.vividsolutions.jts.geom.MultiPolygon)jtsGeom);
        }
        if (geom != null) {
            return new PGgeometry((Geometry)geom);
        }
        throw new UnsupportedOperationException("Conversion of " + jtsGeom.getClass().getSimpleName() + " to PGgeometry not supported");
    }

    private MultiPolygon convertJTSMultiPolygon(com.vividsolutions.jts.geom.MultiPolygon multiPolygon) {
        org.postgis.Polygon[] pgPolygons = new org.postgis.Polygon[multiPolygon.getNumGeometries()];
        int i = 0;
        while (i < pgPolygons.length) {
            pgPolygons[i] = this.convertJTSPolygon((Polygon)multiPolygon.getGeometryN(i));
            ++i;
        }
        MultiPolygon mpg = new MultiPolygon(pgPolygons);
        mpg.setSrid(multiPolygon.getSRID());
        return mpg;
    }

    private org.postgis.MultiPoint convertJTSMultiPoint(MultiPoint multiPoint) {
        Point[] pgPoints = new Point[multiPoint.getNumGeometries()];
        int i = 0;
        while (i < pgPoints.length) {
            pgPoints[i] = this.convertJTSPoint((com.vividsolutions.jts.geom.Point)multiPoint.getGeometryN(i));
            ++i;
        }
        org.postgis.MultiPoint mp = new org.postgis.MultiPoint(pgPoints);
        mp.setSrid(multiPoint.getSRID());
        return mp;
    }

    private org.postgis.Polygon convertJTSPolygon(Polygon jtsPolygon) {
        int numRings = jtsPolygon.getNumInteriorRing();
        org.postgis.LinearRing[] rings = new org.postgis.LinearRing[numRings + 1];
        rings[0] = this.convertJTSLineStringToLinearRing(jtsPolygon.getExteriorRing());
        int i = 0;
        while (i < numRings) {
            rings[i + 1] = this.convertJTSLineStringToLinearRing(jtsPolygon.getInteriorRingN(i));
            ++i;
        }
        org.postgis.Polygon polygon = new org.postgis.Polygon(rings);
        polygon.setSrid(jtsPolygon.getSRID());
        return polygon;
    }

    private org.postgis.LinearRing convertJTSLineStringToLinearRing(com.vividsolutions.jts.geom.LineString lineString) {
        org.postgis.LinearRing lr = new org.postgis.LinearRing(this.toPoints(lineString.getCoordinates()));
        lr.setSrid(lineString.getSRID());
        return lr;
    }

    private LineString convertJTSLineString(com.vividsolutions.jts.geom.LineString string) {
        LineString ls = new LineString(this.toPoints(string.getCoordinates()));
        ls.setSrid(string.getSRID());
        return ls;
    }

    private MultiLineString convertJTSMultiLineSTring(com.vividsolutions.jts.geom.MultiLineString string) {
        LineString[] lines = new LineString[string.getNumGeometries()];
        int i = 0;
        while (i < string.getNumGeometries()) {
            lines[i] = new LineString(this.toPoints(string.getGeometryN(i).getCoordinates()));
            ++i;
        }
        MultiLineString mls = new MultiLineString(lines);
        mls.setSrid(string.getSRID());
        return mls;
    }

    private Point convertJTSPoint(com.vividsolutions.jts.geom.Point point) {
        Point pgPoint = new Point();
        pgPoint.srid = point.getSRID();
        pgPoint.x = point.getX();
        pgPoint.y = point.getY();
        pgPoint.haveMeasure = false;
        pgPoint.dimension = 2;
        return pgPoint;
    }
}

