/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.SortField;
import org.apache.solr.request.TextResponseWriter;
import org.apache.solr.request.XMLWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.function.LongFieldSource;
import org.apache.solr.search.function.ValueSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongField
extends FieldType {
    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        this.restrictProps(3072);
    }

    @Override
    public SortField getSortField(SchemaField field, boolean reverse) {
        return new SortField(field.name, 6, reverse);
    }

    @Override
    public ValueSource getValueSource(SchemaField field) {
        return new LongFieldSource(field.name);
    }

    @Override
    public void write(XMLWriter xmlWriter, String name, Fieldable f) throws IOException {
        xmlWriter.writeLong(name, f.stringValue());
    }

    @Override
    public void write(TextResponseWriter writer, String name, Fieldable f) throws IOException {
        String s = f.stringValue();
        int len = s.length();
        if (len >= 2) {
            char ch = s.charAt(0);
            if (ch == '0' || ch == '-' && s.charAt(1) == '0') {
                s = Long.toString(Long.parseLong(s));
            }
        } else if (len == 0) {
            writer.writeNull(name);
            return;
        }
        writer.writeLong(name, s);
    }

    @Override
    public Long toObject(Fieldable f) {
        return Long.valueOf(this.toExternal(f));
    }
}

