/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.LinkedHashMap;
import java.util.List;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.handler.component.DistribFieldFacet;
import org.apache.solr.handler.component.ResponseBuilder;

class FacetInfo {
    List<String>[] _toRefine;
    LinkedHashMap<String, Long> queryFacets;
    LinkedHashMap<String, DistribFieldFacet> topFacets;
    LinkedHashMap<String, DistribFieldFacet> listFacets;

    FacetInfo() {
    }

    void parse(SolrParams params, ResponseBuilder rb) {
        String[] facetFs;
        this.queryFacets = new LinkedHashMap();
        this.topFacets = new LinkedHashMap();
        this.listFacets = new LinkedHashMap();
        String[] facetQs = params.getParams("facet.query");
        if (facetQs != null) {
            for (String query : facetQs) {
                this.queryFacets.put(query, 0L);
            }
        }
        if ((facetFs = params.getParams("facet.field")) != null) {
            for (String field : facetFs) {
                DistribFieldFacet ff = new DistribFieldFacet(rb, field);
                ff.fillParams(params, field);
                if (ff.sort) {
                    this.topFacets.put(field, ff);
                    continue;
                }
                this.listFacets.put(field, ff);
            }
        }
    }
}

