/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.servlet.ServletContext;
import org.apache.jasper.JasperException;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.xmlparser.ParserUtils;
import org.apache.jasper.xmlparser.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TldLocationsCache {
    private static Log log = LogFactory.getLog(TldLocationsCache.class);
    public static final int ABS_URI = 0;
    public static final int ROOT_REL_URI = 1;
    public static final int NOROOT_REL_URI = 2;
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private static final String FILE_PROTOCOL = "file:";
    private static final String JAR_FILE_SUFFIX = ".jar";
    private static HashSet<String> noTldJars;
    private static HashSet<String> systemJars;
    private static HashSet<String> systemUris;
    private HashMap mappings;
    private boolean initialized;
    private ServletContext ctxt;
    private boolean redeployMode;
    private Options options;
    private boolean localTldsProcessed = false;

    public TldLocationsCache(ServletContext ctxt, Options options) {
        this(ctxt, options, true);
    }

    public TldLocationsCache(ServletContext ctxt, Options options, boolean redeployMode) {
        this.ctxt = ctxt;
        this.options = options;
        this.redeployMode = redeployMode;
        this.initialized = false;
    }

    public static void setNoTldJars(String jarNames) {
        if (jarNames != null) {
            if (noTldJars == null) {
                noTldJars = new HashSet();
            } else {
                noTldJars.clear();
            }
            StringTokenizer tokenizer = new StringTokenizer(jarNames, ",");
            while (tokenizer.hasMoreElements()) {
                noTldJars.add(tokenizer.nextToken());
            }
        }
    }

    public static void setNoTldJars(HashSet<String> set) {
        noTldJars = set;
    }

    public String[] getLocation(String uri) throws JasperException {
        if (!this.initialized) {
            this.init();
        }
        return (String[])this.mappings.get(uri);
    }

    public static int uriType(String uri) {
        if (uri.indexOf(58) != -1) {
            return 0;
        }
        if (uri.startsWith("/")) {
            return 1;
        }
        return 2;
    }

    private void init() throws JasperException {
        if (this.initialized) {
            return;
        }
        HashMap tldUriToLocationMap = (HashMap)this.ctxt.getAttribute("com.sun.jsp.tldUriToLocationMap");
        if (tldUriToLocationMap != null) {
            this.localTldsProcessed = true;
            this.mappings = tldUriToLocationMap;
        } else {
            this.mappings = new HashMap();
        }
        try {
            if (!this.localTldsProcessed) {
                this.processWebDotXml();
            }
            this.scanJars();
            if (!this.localTldsProcessed) {
                this.processTldsInFileSystem("/WEB-INF/");
            }
            this.initialized = true;
        }
        catch (Exception ex) {
            throw new JasperException(Localizer.getMessage("jsp.error.internal.tldinit"), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWebDotXml() throws Exception {
        InputStream is = null;
        try {
            String altDDName = (String)this.ctxt.getAttribute("org.apache.catalina.deploy.alt_dd");
            if (altDDName != null) {
                try {
                    is = new FileInputStream(altDDName);
                }
                catch (FileNotFoundException e) {
                    if (log.isWarnEnabled()) {
                        log.warn(Localizer.getMessage("jsp.error.internal.filenotfound", altDDName));
                    }
                }
            } else {
                is = this.ctxt.getResourceAsStream(WEB_XML);
            }
            if (is == null) {
                return;
            }
            TreeNode webtld = null;
            webtld = altDDName != null ? new ParserUtils().parseXMLDocument(altDDName, is) : new ParserUtils().parseXMLDocument(WEB_XML, is);
            TreeNode jspConfig = webtld.findChild("jsp-config");
            if (jspConfig != null) {
                webtld = jspConfig;
            }
            Iterator taglibs = webtld.findChildren("taglib");
            while (taglibs.hasNext()) {
                TreeNode taglib = (TreeNode)taglibs.next();
                String tagUri = null;
                String tagLoc = null;
                TreeNode child = taglib.findChild("taglib-uri");
                if (child != null) {
                    tagUri = child.getBody();
                }
                if (systemUris.contains(tagUri)) continue;
                child = taglib.findChild("taglib-location");
                if (child != null) {
                    tagLoc = child.getBody();
                }
                if (tagLoc == null) continue;
                if (TldLocationsCache.uriType(tagLoc) == 2) {
                    tagLoc = "/WEB-INF/" + tagLoc;
                }
                String tagLoc2 = null;
                if (tagLoc.endsWith(JAR_FILE_SUFFIX)) {
                    tagLoc = this.ctxt.getResource(tagLoc).toString();
                    tagLoc2 = "META-INF/taglib.tld";
                }
                this.mappings.put(tagUri, new String[]{tagLoc, tagLoc2});
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanJar(JarURLConnection conn, boolean ignore) throws JasperException {
        JarFile jarFile = null;
        String resourcePath = conn.getJarFileURL().toString();
        try {
            if (this.redeployMode) {
                conn.setUseCaches(false);
            }
            jarFile = conn.getJarFile();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith("META-INF/") || !name.endsWith(".tld")) continue;
                InputStream stream = jarFile.getInputStream(entry);
                try {
                    String uri = this.getUriFromTld(resourcePath, stream);
                    if (uri == null || this.mappings.get(uri) != null && !systemUris.contains(uri)) continue;
                    this.mappings.put(uri, new String[]{resourcePath, name});
                }
                finally {
                    if (stream == null) continue;
                    try {
                        stream.close();
                    }
                    catch (Throwable t) {}
                }
            }
        }
        catch (Exception ex) {
            if (!this.redeployMode && jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (!ignore) {
                throw new JasperException(ex);
            }
        }
        finally {
            if (this.redeployMode && jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTldsInFileSystem(String startPath) throws Exception {
        Set dirList = this.ctxt.getResourcePaths(startPath);
        if (dirList != null) {
            for (String path : dirList) {
                if (path.endsWith("/")) {
                    this.processTldsInFileSystem(path);
                }
                if (!path.endsWith(".tld")) continue;
                if (path.startsWith("/WEB-INF/tags/") && !path.endsWith("implicit.tld")) {
                    throw new JasperException(Localizer.getMessage("jsp.error.tldinit.tldInWebInfTags", path));
                }
                InputStream stream = this.ctxt.getResourceAsStream(path);
                String uri = null;
                try {
                    uri = this.getUriFromTld(path, stream);
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable t) {}
                    }
                }
                if (uri == null || systemUris.contains(uri) || this.mappings.get(uri) != null) continue;
                this.mappings.put(uri, new String[]{path, null});
            }
        }
    }

    private String getUriFromTld(String resourcePath, InputStream in) throws JasperException {
        String body;
        TreeNode tld = new ParserUtils().parseXMLDocument(resourcePath, in, this.options.isValidationEnabled());
        TreeNode uri = tld.findChild("uri");
        if (uri != null && (body = uri.getBody()) != null) {
            return body;
        }
        return null;
    }

    private void scanJars() throws Exception {
        ClassLoader webappLoader;
        ClassLoader loader = webappLoader = Thread.currentThread().getContextClassLoader();
        if (this.localTldsProcessed && loader != null) {
            loader = loader.getParent();
        }
        while (loader != null) {
            if (loader instanceof URLClassLoader) {
                boolean isLocal = loader == webappLoader;
                URL[] urls = ((URLClassLoader)loader).getURLs();
                for (int i = 0; i < urls.length; ++i) {
                    URLConnection conn = urls[i].openConnection();
                    if (conn instanceof JarURLConnection) {
                        if (!this.needScanJar(((JarURLConnection)conn).getJarFile().getName(), isLocal)) continue;
                        this.scanJar((JarURLConnection)conn, true);
                        continue;
                    }
                    String urlStr = urls[i].toString();
                    if (!urlStr.startsWith(FILE_PROTOCOL) || !urlStr.endsWith(JAR_FILE_SUFFIX) || !this.needScanJar(urlStr, isLocal)) continue;
                    URL jarURL = new URL("jar:" + urlStr + "!/");
                    this.scanJar((JarURLConnection)jarURL.openConnection(), true);
                }
            }
            loader = loader.getParent();
        }
    }

    private boolean needScanJar(String jarPath, boolean isLocal) {
        if (isLocal) {
            return true;
        }
        String jarName = jarPath;
        int slash = jarPath.lastIndexOf(47);
        if (slash >= 0) {
            jarName = jarPath.substring(slash + 1);
        }
        return noTldJars == null || !noTldJars.contains(jarName);
    }

    static {
        systemJars = new HashSet();
        systemUris = new HashSet();
        systemJars.add("standard.jar");
        systemJars.add("appserv-jstl.jar");
        systemJars.add("jsf-impl.jar");
        systemUris.add("http://java.sun.com/jsf/core");
        systemUris.add("http://java.sun.com/jsf/html");
        systemUris.add("http://java.sun.com/jsp/jstl/core");
    }
}

