/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.freemarker;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ValueStack;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.StrutsResultSupport;
import org.apache.struts2.views.freemarker.FreemarkerManager;
import org.apache.struts2.views.util.ResourceUtil;

public class FreemarkerResult
extends StrutsResultSupport {
    private static final long serialVersionUID = -3778230771704661631L;
    protected ActionInvocation invocation;
    protected Configuration configuration;
    protected ObjectWrapper wrapper;
    protected FreemarkerManager freemarkerManager;
    private Writer writer;
    private boolean writeIfCompleted = false;
    protected String location;
    private String pContentType = "text/html";

    public FreemarkerResult() {
    }

    public FreemarkerResult(String location) {
        super(location);
    }

    @Inject
    public void setFreemarkerManager(FreemarkerManager mgr) {
        this.freemarkerManager = mgr;
    }

    public void setContentType(String aContentType) {
        this.pContentType = aContentType;
    }

    public String getContentType() {
        return this.pContentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute(String locationArg, ActionInvocation invocation) throws IOException, TemplateException {
        block10: {
            TemplateModel model;
            Template template;
            this.location = locationArg;
            this.invocation = invocation;
            this.configuration = this.getConfiguration();
            this.wrapper = this.getObjectWrapper();
            if (!locationArg.startsWith("/")) {
                ActionContext ctx = invocation.getInvocationContext();
                HttpServletRequest req = (HttpServletRequest)ctx.get((Object)"com.opensymphony.xwork2.dispatcher.HttpServletRequest");
                String base = ResourceUtil.getResourceBase(req);
                locationArg = base + "/" + locationArg;
            }
            if (this.preTemplateProcess(template = this.configuration.getTemplate(locationArg, this.deduceLocale()), model = this.createModel())) {
                try {
                    Writer writer = this.getWriter();
                    if (this.isWriteIfCompleted() || this.configuration.getTemplateExceptionHandler() == TemplateExceptionHandler.RETHROW_HANDLER) {
                        CharArrayWriter charArrayWriter = new CharArrayWriter();
                        try {
                            template.process((Object)model, (Writer)charArrayWriter);
                            charArrayWriter.flush();
                            charArrayWriter.writeTo(writer);
                            break block10;
                        }
                        finally {
                            if (charArrayWriter != null) {
                                charArrayWriter.close();
                            }
                        }
                    }
                    template.process((Object)model, writer);
                }
                finally {
                    this.postTemplateProcess(template, model);
                }
            }
        }
    }

    protected Configuration getConfiguration() throws TemplateException {
        return this.freemarkerManager.getConfiguration(ServletActionContext.getServletContext());
    }

    protected ObjectWrapper getObjectWrapper() {
        return this.configuration.getObjectWrapper();
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    protected Writer getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        return ServletActionContext.getResponse().getWriter();
    }

    protected TemplateModel createModel() throws TemplateModelException {
        ServletContext servletContext = ServletActionContext.getServletContext();
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        ValueStack stack = ServletActionContext.getContext().getValueStack();
        Object action = null;
        if (this.invocation != null) {
            action = this.invocation.getAction();
        }
        return this.freemarkerManager.buildTemplateModel(stack, action, servletContext, request, response, this.wrapper);
    }

    protected Locale deduceLocale() {
        if (this.invocation.getAction() instanceof LocaleProvider) {
            return ((LocaleProvider)this.invocation.getAction()).getLocale();
        }
        return this.configuration.getLocale();
    }

    protected void postTemplateProcess(Template template, TemplateModel data) throws IOException {
    }

    protected boolean preTemplateProcess(Template template, TemplateModel model) throws IOException {
        Object attrContentType = template.getCustomAttribute("content_type");
        if (attrContentType != null) {
            ServletActionContext.getResponse().setContentType(attrContentType.toString());
        } else {
            String encoding;
            String contentType = this.getContentType();
            if (contentType == null) {
                contentType = "text/html";
            }
            if ((encoding = template.getEncoding()) != null) {
                contentType = contentType + "; charset=" + encoding;
            }
            ServletActionContext.getResponse().setContentType(contentType);
        }
        return true;
    }

    public boolean isWriteIfCompleted() {
        return this.writeIfCompleted;
    }

    public void setWriteIfCompleted(boolean writeIfCompleted) {
        this.writeIfCompleted = writeIfCompleted;
    }
}

