/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.ValueStack;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;

public class HttpHeaderResult
implements Result {
    private static final long serialVersionUID = 195648957144219214L;
    public static final String DEFAULT_PARAM = "status";
    private boolean parse = true;
    private Map<String, String> headers = new HashMap<String, String>();
    private int status = -1;
    private int error = -1;
    private String errorMessage;

    public HttpHeaderResult() {
    }

    public HttpHeaderResult(int status) {
        this();
        this.status = status;
        this.parse = false;
    }

    public void setError(int error) {
        this.error = error;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Map getHeaders() {
        return this.headers;
    }

    public void setParse(boolean parse) {
        this.parse = parse;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void execute(ActionInvocation invocation) throws Exception {
        HttpServletResponse response = ServletActionContext.getResponse();
        ValueStack stack = ActionContext.getContext().getValueStack();
        if (this.status != -1) {
            response.setStatus(this.status);
        } else if (this.error != -1) {
            if (this.errorMessage != null) {
                String finalMessage = this.parse ? TextParseUtil.translateVariables((String)this.errorMessage, (ValueStack)stack) : this.errorMessage;
                response.sendError(this.error, finalMessage);
            } else {
                response.sendError(this.error);
            }
        }
        if (this.headers != null) {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                String value = entry.getValue();
                String finalValue = this.parse ? TextParseUtil.translateVariables((String)value, (ValueStack)stack) : value;
                response.addHeader(entry.getKey(), finalValue);
            }
        }
    }
}

