/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.config;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.providers.XmlConfigurationProvider;
import com.opensymphony.xwork2.inject.ContainerBuilder;
import com.opensymphony.xwork2.inject.Context;
import com.opensymphony.xwork2.inject.Factory;
import com.opensymphony.xwork2.util.location.LocatableProperties;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrutsXmlConfigurationProvider
extends XmlConfigurationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(StrutsXmlConfigurationProvider.class);
    private File baseDir = null;
    private String filename;
    private String reloadKey;
    private ServletContext servletContext;

    public StrutsXmlConfigurationProvider(boolean errorIfMissing) {
        this("struts.xml", errorIfMissing, null);
    }

    public StrutsXmlConfigurationProvider(String filename, boolean errorIfMissing, ServletContext ctx) {
        super(filename, errorIfMissing);
        this.servletContext = ctx;
        this.filename = filename;
        this.reloadKey = "configurationReload-" + filename;
        HashMap<String, String> dtdMappings = new HashMap<String, String>(this.getDtdMappings());
        dtdMappings.put("-//Apache Software Foundation//DTD Struts Configuration 2.0//EN", "struts-2.0.dtd");
        this.setDtdMappings(dtdMappings);
        File file = new File(filename);
        if (file.getParent() != null) {
            this.baseDir = file.getParentFile();
        }
    }

    public void register(ContainerBuilder containerBuilder, LocatableProperties props) throws ConfigurationException {
        if (this.servletContext != null && !containerBuilder.contains(ServletContext.class)) {
            containerBuilder.factory(ServletContext.class, new Factory(){

                public Object create(Context context) throws Exception {
                    return StrutsXmlConfigurationProvider.this.servletContext;
                }
            });
        }
        super.register(containerBuilder, props);
    }

    public void loadPackages() {
        ActionContext ctx = ActionContext.getContext();
        ctx.put((Object)this.reloadKey, (Object)Boolean.TRUE);
        super.loadPackages();
    }

    protected Iterator<URL> getConfigurationUrls(String fileName) throws IOException {
        URL url = null;
        if (this.baseDir != null && (url = this.findInFileSystem(fileName)) == null) {
            return super.getConfigurationUrls(fileName);
        }
        if (url != null) {
            ArrayList<URL> list = new ArrayList<URL>();
            list.add(url);
            return list.iterator();
        }
        return super.getConfigurationUrls(fileName);
    }

    protected URL findInFileSystem(String fileName) throws IOException {
        URL url = null;
        File file = new File(fileName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Trying to load file " + file, new String[0]);
        }
        if (!file.exists()) {
            file = new File(this.baseDir, fileName);
        }
        if (file.exists()) {
            try {
                url = file.toURL();
            }
            catch (MalformedURLException e) {
                throw new IOException("Unable to convert " + file + " to a URL");
            }
        }
        return url;
    }

    public boolean needsReload() {
        ActionContext ctx = ActionContext.getContext();
        if (ctx != null) {
            return ctx.get((Object)this.reloadKey) == null && super.needsReload();
        }
        return super.needsReload();
    }

    public String toString() {
        return "Struts XML configuration provider (" + this.filename + ")";
    }
}

