/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components.template;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.components.template.BaseTemplateEngine;
import org.apache.struts2.components.template.Template;
import org.apache.struts2.components.template.TemplateRenderingContext;
import org.apache.struts2.views.freemarker.FreemarkerManager;

public class FreemarkerTemplateEngine
extends BaseTemplateEngine {
    static Class bodyContent = null;
    private FreemarkerManager freemarkerManager;
    private final HashMap<String, freemarker.template.Template> templates = new HashMap();
    private final HashSet<String> missingTemplates = new HashSet();
    private boolean freemarkerCaching = false;
    private static final Logger LOG;

    @Inject
    public void setFreemarkerManager(FreemarkerManager mgr) {
        this.freemarkerManager = mgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderTemplate(TemplateRenderingContext templateContext) throws Exception {
        ActionInvocation ai;
        ValueStack stack = templateContext.getStack();
        Map context = stack.getContext();
        ServletContext servletContext = (ServletContext)context.get("com.opensymphony.xwork2.dispatcher.ServletContext");
        HttpServletRequest req = (HttpServletRequest)context.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        HttpServletResponse res = (HttpServletResponse)context.get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        Configuration config = this.freemarkerManager.getConfiguration(servletContext);
        List<Template> templates = templateContext.getTemplate().getPossibleTemplates(this);
        freemarker.template.Template template = null;
        String templateName = null;
        Throwable exception = null;
        for (Template t : templates) {
            templateName = this.getFinalTemplateName(t);
            if (this.freemarkerCaching) {
                if (this.isTemplateMissing(templateName)) continue;
                try {
                    template = this.findInCache(templateName);
                    if (template != null) break;
                    template = config.getTemplate(templateName);
                    this.addToCache(templateName, template);
                    break;
                }
                catch (IOException e) {
                    this.addToMissingTemplateCache(templateName);
                    if (exception != null) continue;
                    exception = e;
                    continue;
                }
            }
            try {
                template = config.getTemplate(templateName);
                break;
            }
            catch (ParseException e) {
                exception = e;
                break;
            }
            catch (IOException e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        if (template == null) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Could not load the FreeMarker template named '" + templateContext.getTemplate().getName() + "':", new String[0]);
                for (Template t : templates) {
                    LOG.error("Attempted: " + this.getFinalTemplateName(t), new String[0]);
                }
                LOG.error("The TemplateLoader provided by the FreeMarker Configuration was a: " + config.getTemplateLoader().getClass().getName(), new String[0]);
            }
            if (exception != null) {
                throw exception;
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Rendering template " + templateName, new String[0]);
        }
        Object action = (ai = ActionContext.getContext().getActionInvocation()) == null ? null : ai.getAction();
        SimpleHash model = this.freemarkerManager.buildTemplateModel(stack, action, servletContext, req, res, config.getObjectWrapper());
        model.put("tag", (Object)templateContext.getTag());
        model.put("themeProperties", (Object)this.getThemeProps(templateContext.getTemplate()));
        Writer writer = templateContext.getWriter();
        if (bodyContent != null && bodyContent.isAssignableFrom(writer.getClass())) {
            final Writer wrapped = writer;
            writer = new Writer(){

                public void write(char[] cbuf, int off, int len) throws IOException {
                    wrapped.write(cbuf, off, len);
                }

                public void flush() throws IOException {
                }

                public void close() throws IOException {
                    wrapped.close();
                }
            };
        }
        try {
            stack.push((Object)templateContext.getTag());
            template.process((Object)model, writer);
        }
        finally {
            stack.pop();
        }
    }

    protected String getSuffix() {
        return "ftl";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToMissingTemplateCache(String templateName) {
        HashSet<String> hashSet = this.missingTemplates;
        synchronized (hashSet) {
            this.missingTemplates.add(templateName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isTemplateMissing(String templateName) {
        HashSet<String> hashSet = this.missingTemplates;
        synchronized (hashSet) {
            return this.missingTemplates.contains(templateName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToCache(String templateName, freemarker.template.Template template) {
        HashMap<String, freemarker.template.Template> hashMap = this.templates;
        synchronized (hashMap) {
            this.templates.put(templateName, template);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected freemarker.template.Template findInCache(String templateName) {
        HashMap<String, freemarker.template.Template> hashMap = this.templates;
        synchronized (hashMap) {
            return this.templates.get(templateName);
        }
    }

    @Inject(value="struts.freemarker.templatesCache")
    public void setCacheTemplates(String cacheTemplates) {
        this.freemarkerCaching = "true".equals(cacheTemplates);
    }

    static {
        try {
            bodyContent = ClassLoaderUtil.loadClass((String)"javax.servlet.jsp.tagext.BodyContent", FreemarkerTemplateEngine.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        LOG = LoggerFactory.getLogger(FreemarkerTemplateEngine.class);
    }
}

