/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.struts2.StrutsException;
import org.apache.struts2.components.Form;
import org.apache.struts2.components.URL;
import org.apache.struts2.components.UrlRenderer;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.apache.struts2.views.util.UrlHelper;

public class ServletUrlRenderer
implements UrlRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(ServletUrlRenderer.class);
    private ActionMapper actionMapper;

    @Inject
    public void setActionMapper(ActionMapper mapper) {
        this.actionMapper = mapper;
    }

    public void renderUrl(Writer writer, URL urlComponent) {
        String var;
        String result;
        String scheme = urlComponent.req.getScheme();
        if (urlComponent.scheme != null) {
            scheme = urlComponent.scheme;
        }
        if (urlComponent.value == null && urlComponent.action != null) {
            result = urlComponent.determineActionURL(urlComponent.action, urlComponent.namespace, urlComponent.method, urlComponent.req, urlComponent.res, urlComponent.parameters, scheme, urlComponent.includeContext, urlComponent.encode, urlComponent.forceAddSchemeHostAndPort, urlComponent.escapeAmp);
        } else {
            String _value = urlComponent.value;
            if (_value != null && _value.indexOf("?") > 0) {
                _value = _value.substring(0, _value.indexOf("?"));
            }
            result = UrlHelper.buildUrl(_value, urlComponent.req, urlComponent.res, urlComponent.parameters, scheme, urlComponent.includeContext, urlComponent.encode, urlComponent.forceAddSchemeHostAndPort, urlComponent.escapeAmp);
        }
        if (urlComponent.anchor != null && urlComponent.anchor.length() > 0) {
            result = result + '#' + urlComponent.anchor;
        }
        if ((var = urlComponent.getVar()) != null) {
            urlComponent.putInContext(result);
            urlComponent.req.setAttribute(var, (Object)result);
        } else {
            try {
                writer.write(result);
            }
            catch (IOException e) {
                throw new StrutsException("IOError: " + e.getMessage(), e);
            }
        }
    }

    public void renderFormUrl(Form formComponent) {
        String action;
        String namespace = formComponent.determineNamespace(formComponent.namespace, formComponent.getStack(), formComponent.request);
        if (formComponent.action != null) {
            action = formComponent.findString(formComponent.action);
        } else {
            ActionInvocation ai = (ActionInvocation)formComponent.getStack().getContext().get("com.opensymphony.xwork2.ActionContext.actionInvocation");
            if (ai != null) {
                action = ai.getProxy().getActionName();
                namespace = ai.getProxy().getNamespace();
            } else {
                String uri = formComponent.request.getRequestURI();
                action = uri.substring(uri.lastIndexOf(47));
            }
        }
        ActionMapping nameMapping = this.actionMapper.getMappingFromActionName(action);
        String actionName = nameMapping.getName();
        String actionMethod = nameMapping.getMethod();
        ActionConfig actionConfig = formComponent.configuration.getRuntimeConfiguration().getActionConfig(namespace, action);
        if (actionConfig != null) {
            ActionMapping mapping = new ActionMapping(action, namespace, actionMethod, formComponent.parameters);
            String result = UrlHelper.buildUrl(formComponent.actionMapper.getUriFromActionMapping(mapping), formComponent.request, formComponent.response, null);
            formComponent.addParameter("action", result);
            formComponent.addParameter("actionName", actionName);
            try {
                Class clazz = formComponent.objectFactory.getClassInstance(actionConfig.getClassName());
                formComponent.addParameter("actionClass", clazz);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            formComponent.addParameter("namespace", namespace);
            if (formComponent.name == null) {
                formComponent.addParameter("name", action);
            }
            if (formComponent.getId() == null && action != null) {
                formComponent.addParameter("id", formComponent.escape(action));
            }
        } else if (action != null) {
            if (namespace != null) {
                LOG.warn("No configuration found for the specified action: '" + action + "' in namespace: '" + namespace + "'. Form action defaulting to 'action' attribute's literal value.", new String[0]);
            }
            String result = UrlHelper.buildUrl(action, formComponent.request, formComponent.response, null);
            formComponent.addParameter("action", result);
            int slash = result.lastIndexOf(47);
            if (slash != -1) {
                formComponent.addParameter("namespace", result.substring(0, slash));
            } else {
                formComponent.addParameter("namespace", "");
            }
            String id = formComponent.getId();
            if (id == null) {
                slash = result.lastIndexOf(47);
                int dot = result.indexOf(46, slash);
                id = dot != -1 ? result.substring(slash + 1, dot) : result.substring(slash + 1);
                formComponent.addParameter("id", formComponent.escape(id));
            }
        }
        formComponent.evaluateClientSideJsEnablement(actionName, namespace, actionMethod);
    }

    public void beforeRenderUrl(URL urlComponent) {
        if (urlComponent.value != null) {
            urlComponent.value = urlComponent.findString(urlComponent.value);
        }
        try {
            String includeParams;
            String string = includeParams = urlComponent.urlIncludeParams != null ? urlComponent.urlIncludeParams.toLowerCase() : "get";
            if (urlComponent.includeParams != null) {
                includeParams = urlComponent.findString(urlComponent.includeParams);
            }
            if ("none".equalsIgnoreCase(includeParams)) {
                this.mergeRequestParameters(urlComponent.value, urlComponent.parameters, Collections.EMPTY_MAP);
            } else if ("all".equalsIgnoreCase(includeParams)) {
                this.mergeRequestParameters(urlComponent.value, urlComponent.parameters, urlComponent.req.getParameterMap());
                this.includeGetParameters(urlComponent);
                this.includeExtraParameters(urlComponent);
            } else if ("get".equalsIgnoreCase(includeParams) || includeParams == null && urlComponent.value == null && urlComponent.action == null) {
                this.includeGetParameters(urlComponent);
                this.includeExtraParameters(urlComponent);
            } else if (includeParams != null) {
                LOG.warn("Unknown value for includeParams parameter to URL tag: " + includeParams, new String[0]);
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to put request parameters (" + urlComponent.req.getQueryString() + ") into parameter map.", (Throwable)e, new String[0]);
        }
    }

    private void includeExtraParameters(URL urlComponent) {
        if (urlComponent.extraParameterProvider != null) {
            this.mergeRequestParameters(urlComponent.value, urlComponent.parameters, urlComponent.extraParameterProvider.getExtraParameters());
        }
    }

    private void includeGetParameters(URL urlComponent) {
        String query = this.extractQueryString(urlComponent);
        this.mergeRequestParameters(urlComponent.value, urlComponent.parameters, UrlHelper.parseQueryString(query));
    }

    private String extractQueryString(URL urlComponent) {
        int idx;
        String query = urlComponent.req.getQueryString();
        if (query == null) {
            query = (String)urlComponent.req.getAttribute("javax.servlet.forward.query_string");
        }
        if (query != null && (idx = query.lastIndexOf(35)) != -1) {
            query = query.substring(0, idx);
        }
        return query;
    }

    protected void mergeRequestParameters(String value, Map parameters, Map contextParameters) {
        Map mergedParams = new LinkedHashMap(contextParameters);
        if (value != null && value.trim().length() > 0 && value.indexOf("?") > 0) {
            mergedParams = new LinkedHashMap();
            String queryString = value.substring(value.indexOf("?") + 1);
            mergedParams = UrlHelper.parseQueryString(queryString);
            for (Map.Entry entry : contextParameters.entrySet()) {
                Object key = entry.getKey();
                if (mergedParams.containsKey(key)) continue;
                mergedParams.put(key, entry.getValue());
            }
        }
        for (Map.Entry entry : mergedParams.entrySet()) {
            Object key = entry.getKey();
            if (parameters.containsKey(key)) continue;
            parameters.put(key, entry.getValue());
        }
    }
}

