/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components;

import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.RuntimeConfiguration;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.InterceptorMapping;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptorUtil;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.validator.ActionValidatorManager;
import com.opensymphony.xwork2.validator.FieldValidator;
import com.opensymphony.xwork2.validator.ValidationInterceptor;
import com.opensymphony.xwork2.validator.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.components.ClosingUIBean;
import org.apache.struts2.components.UrlRenderer;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;

@StrutsTag(name="form", tldTagClass="org.apache.struts2.views.jsp.ui.FormTag", description="Renders an input form", allowDynamicAttributes=true)
public class Form
extends ClosingUIBean {
    public static final String OPEN_TEMPLATE = "form";
    public static final String TEMPLATE = "form-close";
    private int sequence = 0;
    protected String onsubmit;
    protected String action;
    protected String target;
    protected String enctype;
    protected String method;
    protected String namespace;
    protected String validate;
    protected String portletMode;
    protected String windowState;
    protected String acceptcharset;
    protected String focusElement;
    protected Configuration configuration;
    protected ObjectFactory objectFactory;
    protected UrlRenderer urlRenderer;
    protected ActionValidatorManager actionValidatorManager;

    public Form(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    protected boolean evaluateNameValue() {
        return false;
    }

    public String getDefaultOpenTemplate() {
        return OPEN_TEMPLATE;
    }

    protected String getDefaultTemplate() {
        return TEMPLATE;
    }

    @Inject
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Inject
    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    @Inject
    public void setUrlRenderer(UrlRenderer urlRenderer) {
        this.urlRenderer = urlRenderer;
    }

    @Inject
    public void setActionValidatorManager(ActionValidatorManager mgr) {
        this.actionValidatorManager = mgr;
    }

    protected void evaluateExtraParams() {
        super.evaluateExtraParams();
        if (this.validate != null) {
            this.addParameter("validate", this.findValue(this.validate, Boolean.class));
        }
        if (this.onsubmit != null) {
            this.addParameter("onsubmit", this.findString(this.onsubmit));
        }
        if (this.target != null) {
            this.addParameter("target", this.findString(this.target));
        }
        if (this.enctype != null) {
            this.addParameter("enctype", this.findString(this.enctype));
        }
        if (this.method != null) {
            this.addParameter("method", this.findString(this.method));
        }
        if (this.acceptcharset != null) {
            this.addParameter("acceptcharset", this.findString(this.acceptcharset));
        }
        if (!this.parameters.containsKey("tagNames")) {
            this.addParameter("tagNames", new ArrayList());
        }
        if (this.focusElement != null) {
            this.addParameter("focusElement", this.findString(this.focusElement));
        }
    }

    protected void populateComponentHtmlId(Form form) {
        if (this.id != null) {
            this.addParameter("id", this.escape(this.id));
        }
        this.urlRenderer.renderFormUrl(this);
    }

    protected void evaluateClientSideJsEnablement(String actionName, String namespace, String actionMethod) {
        Boolean validate = (Boolean)this.getParameters().get("validate");
        if (validate != null && validate.booleanValue()) {
            this.addParameter("performValidation", Boolean.FALSE);
            RuntimeConfiguration runtimeConfiguration = this.configuration.getRuntimeConfiguration();
            ActionConfig actionConfig = runtimeConfiguration.getActionConfig(namespace, actionName);
            if (actionConfig != null) {
                List interceptors = actionConfig.getInterceptors();
                for (InterceptorMapping interceptorMapping : interceptors) {
                    Set includeMethods;
                    if (!ValidationInterceptor.class.isInstance(interceptorMapping.getInterceptor())) continue;
                    ValidationInterceptor validationInterceptor = (ValidationInterceptor)interceptorMapping.getInterceptor();
                    Set excludeMethods = validationInterceptor.getExcludeMethodsSet();
                    if (MethodFilterInterceptorUtil.applyMethod((Set)excludeMethods, (Set)(includeMethods = validationInterceptor.getIncludeMethodsSet()), (String)actionMethod)) {
                        this.addParameter("performValidation", Boolean.TRUE);
                    }
                    return;
                }
            }
        }
    }

    public List getValidators(String name) {
        Class actionClass = (Class)this.getParameters().get("actionClass");
        if (actionClass == null) {
            return Collections.EMPTY_LIST;
        }
        List all = this.actionValidatorManager.getValidators(actionClass, (String)this.getParameters().get("actionName"));
        ArrayList<FieldValidator> validators = new ArrayList<FieldValidator>();
        for (Validator validator : all) {
            FieldValidator fieldValidator;
            if (!(validator instanceof FieldValidator) || !(fieldValidator = (FieldValidator)validator).getFieldName().equals(name)) continue;
            validators.add(fieldValidator);
        }
        return validators;
    }

    protected int getSequence() {
        return this.sequence++;
    }

    @StrutsTagAttribute(description="HTML onsubmit attribute")
    public void setOnsubmit(String onsubmit) {
        this.onsubmit = onsubmit;
    }

    @StrutsTagAttribute(description="Set action name to submit to, without .action suffix", defaultValue="current action")
    public void setAction(String action) {
        this.action = action;
    }

    @StrutsTagAttribute(description="HTML form target attribute")
    public void setTarget(String target) {
        this.target = target;
    }

    @StrutsTagAttribute(description="HTML form enctype attribute")
    public void setEnctype(String enctype) {
        this.enctype = enctype;
    }

    @StrutsTagAttribute(description="HTML form method attribute")
    public void setMethod(String method) {
        this.method = method;
    }

    @StrutsTagAttribute(description="Namespace for action to submit to", defaultValue="current namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @StrutsTagAttribute(description="Whether client side/remote validation should be performed. Only useful with theme xhtml/ajax", type="Boolean", defaultValue="false")
    public void setValidate(String validate) {
        this.validate = validate;
    }

    @StrutsTagAttribute(description="The portlet mode to display after the form submit")
    public void setPortletMode(String portletMode) {
        this.portletMode = portletMode;
    }

    @StrutsTagAttribute(description="The window state to display after the form submit")
    public void setWindowState(String windowState) {
        this.windowState = windowState;
    }

    @StrutsTagAttribute(description="The accepted charsets for this form. The values may be comma or blank delimited.")
    public void setAcceptcharset(String acceptcharset) {
        this.acceptcharset = acceptcharset;
    }

    @StrutsTagAttribute(description="Id of element that will receive the focus when page loads.")
    public void setFocusElement(String focusElement) {
        this.focusElement = focusElement;
    }
}

