/*
 * Decompiled with CFR 0.152.
 */
package javax.units;

import javax.units.Converter;

public final class LogConverter
extends Converter {
    private final double _base;
    private final double _logBase;
    private final double _invLogBase;
    private final Inverse _inverse = new Inverse();

    public LogConverter(double base) {
        this._base = base;
        this._logBase = Math.log(base);
        this._invLogBase = 1.0 / this._logBase;
    }

    public double getBase() {
        return this._base;
    }

    public Converter inverse() {
        return this._inverse;
    }

    public double convert(double x) {
        return this._invLogBase * Math.log(x);
    }

    public double derivative(double x) {
        return this._invLogBase / x;
    }

    public boolean isLinear() {
        return false;
    }

    public boolean equals(Object obj) {
        return obj instanceof LogConverter && Float.floatToIntBits((float)((LogConverter)obj)._base) == Float.floatToIntBits((float)this._base);
    }

    public int hashCode() {
        return Float.floatToIntBits((float)this._base);
    }

    private class Inverse
    extends Converter {
        private Inverse() {
        }

        public Converter inverse() {
            return LogConverter.this;
        }

        public double convert(double x) {
            return Math.exp(LogConverter.this._logBase * x);
        }

        public double derivative(double x) {
            return LogConverter.this._logBase * Math.exp(x);
        }

        public boolean isLinear() {
            return false;
        }

        public boolean equals(Object obj) {
            return obj instanceof Inverse && LogConverter.this.equals(((Inverse)obj).inverse());
        }

        public int hashCode() {
            return LogConverter.this.hashCode() * 31;
        }
    }
}

