/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.MapEntry;
import org.geotools.util.WeakCollectionCleaner;

public class SoftValueHashMap
extends AbstractMap {
    private static final int DEFAULT_HARD_REFERENCE_COUNT = 20;
    private final Map hash = new HashMap();
    private final LinkedList hardCache = new LinkedList();
    private final int hardReferencesCount;
    private transient Set entries;

    public SoftValueHashMap() {
        this.hardReferencesCount = 20;
    }

    public SoftValueHashMap(int hardReferencesCount) {
        this.hardReferencesCount = hardReferencesCount;
    }

    private static void ensureNotNull(Object value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException(Errors.format(105, "value"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isValid() {
        int count = 0;
        int size = 0;
        Map map = this.hash;
        synchronized (map) {
            for (Map.Entry entry : this.hash.entrySet()) {
                if (entry.getValue() instanceof Reference) {
                    ++count;
                } else assert (this.hardCache.contains(entry.getKey()));
                ++size;
            }
            assert (size == this.hash.size());
            assert (this.hardCache.size() == Math.min(size, this.hardReferencesCount));
        }
        return count == Math.max(size - this.hardReferencesCount, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Map map = this.hash;
        synchronized (map) {
            return this.hash.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        Map map = this.hash;
        synchronized (map) {
            return this.hash.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object value) {
        SoftValueHashMap.ensureNotNull(value);
        Map map = this.hash;
        synchronized (map) {
            return super.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Map map = this.hash;
        synchronized (map) {
            Object value = this.hash.get(key);
            if (value instanceof Reference) {
                if ((value = ((Reference)value).getAndClear()) != null) {
                    this.hash.put(key, value);
                    this.retainStrongly(key);
                } else {
                    this.hash.remove(key);
                }
            }
            return value;
        }
    }

    private void retainStrongly(Object key) {
        assert (Thread.holdsLock(this.hash));
        assert (!this.hardCache.contains(key)) : key;
        this.hardCache.addFirst(key);
        if (this.hardCache.size() > this.hardReferencesCount) {
            Object toRemove = this.hardCache.removeLast();
            Object value = this.hash.get(toRemove);
            assert (value != null && !(value instanceof Reference)) : toRemove;
            this.hash.put(toRemove, new Reference(this.hash, toRemove, value));
            assert (this.hardCache.size() == this.hardReferencesCount);
        }
        assert (this.isValid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        SoftValueHashMap.ensureNotNull(value);
        Map map = this.hash;
        synchronized (map) {
            Object oldValue = this.hash.put(key, value);
            if (oldValue instanceof Reference) {
                oldValue = ((Reference)oldValue).getAndClear();
            } else if (oldValue != null && !this.hardCache.remove(key)) {
                throw new AssertionError(key);
            }
            this.retainStrongly(key);
            return oldValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map map) {
        Map map2 = this.hash;
        synchronized (map2) {
            super.putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        Map map = this.hash;
        synchronized (map) {
            Object oldValue = this.hash.remove(key);
            if (oldValue instanceof Reference) {
                oldValue = ((Reference)oldValue).getAndClear();
            } else if (oldValue != null && !this.hardCache.remove(key)) {
                throw new AssertionError(key);
            }
            return oldValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map map = this.hash;
        synchronized (map) {
            for (Object value : this.hash.values()) {
                if (!(value instanceof Reference)) continue;
                ((Reference)value).getAndClear();
            }
            this.hash.clear();
            this.hardCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entrySet() {
        Map map = this.hash;
        synchronized (map) {
            if (this.entries == null) {
                this.entries = new Entries();
            }
            return this.entries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        Map map = this.hash;
        synchronized (map) {
            return super.equals(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Map map = this.hash;
        synchronized (map) {
            return super.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map map = this.hash;
        synchronized (map) {
            return super.toString();
        }
    }

    private static final class Reference
    extends SoftReference {
        private final Map hash;
        private final Object key;

        Reference(Map hash, Object key, Object value) {
            super(value, WeakCollectionCleaner.DEFAULT.referenceQueue);
            this.hash = hash;
            this.key = key;
        }

        final Object getAndClear() {
            assert (Thread.holdsLock(this.hash));
            Object value = this.get();
            super.clear();
            return value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            super.clear();
            Map map = this.hash;
            synchronized (map) {
                Object old = this.hash.remove(this.key);
                if (old != this && old != null) {
                    this.hash.put(this.key, old);
                }
            }
        }
    }

    private static final class Iter
    implements Iterator {
        private final Map hash;
        private final Iterator iterator;
        private transient Map.Entry entry;

        Iter(Map hash) {
            this.hash = hash;
            this.iterator = hash.entrySet().iterator();
        }

        private boolean findNext() {
            assert (Thread.holdsLock(this.hash));
            while (this.iterator.hasNext()) {
                Map.Entry candidate = (Map.Entry)this.iterator.next();
                Object value = candidate.getValue();
                if (value instanceof Reference) {
                    value = ((Reference)value).get();
                    this.entry = new MapEntry(candidate.getKey(), value);
                    return true;
                }
                if (value == null) continue;
                this.entry = candidate;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            Map map = this.hash;
            synchronized (map) {
                return this.entry != null || this.findNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            Map map = this.hash;
            synchronized (map) {
                if (this.entry == null && !this.findNext()) {
                    throw new NoSuchElementException();
                }
                Map.Entry next = this.entry;
                this.entry = null;
                return next;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            Map map = this.hash;
            synchronized (map) {
                this.iterator.remove();
            }
        }
    }

    private final class Entries
    extends AbstractSet {
        private Entries() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterator iterator() {
            Map map = SoftValueHashMap.this.hash;
            synchronized (map) {
                return new Iter(SoftValueHashMap.this.hash);
            }
        }

        public int size() {
            return SoftValueHashMap.this.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Object entry) {
            Map map = SoftValueHashMap.this.hash;
            synchronized (map) {
                return super.contains(entry);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray() {
            Map map = SoftValueHashMap.this.hash;
            synchronized (map) {
                return super.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray(Object[] array) {
            Map map = SoftValueHashMap.this.hash;
            synchronized (map) {
                return super.toArray(array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object entry) {
            Map map = SoftValueHashMap.this.hash;
            synchronized (map) {
                return super.remove(entry);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsAll(Collection collection) {
            Map map = SoftValueHashMap.this.hash;
            synchronized (map) {
                return super.containsAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(Collection collection) {
            Map map = SoftValueHashMap.this.hash;
            synchronized (map) {
                return super.addAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(Collection collection) {
            Map map = SoftValueHashMap.this.hash;
            synchronized (map) {
                return super.removeAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(Collection collection) {
            Map map = SoftValueHashMap.this.hash;
            synchronized (map) {
                return super.retainAll(collection);
            }
        }

        public void clear() {
            SoftValueHashMap.this.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Map map = SoftValueHashMap.this.hash;
            synchronized (map) {
                return super.toString();
            }
        }
    }
}

