/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.identification;

import java.util.Collection;
import org.geotools.metadata.iso.MetadataEntity;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.distribution.Format;
import org.opengis.metadata.identification.AggregateInformation;
import org.opengis.metadata.identification.BrowseGraphic;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.identification.Keywords;
import org.opengis.metadata.identification.Progress;
import org.opengis.metadata.identification.Usage;
import org.opengis.metadata.maintenance.MaintenanceInformation;
import org.opengis.util.InternationalString;

public class IdentificationImpl
extends MetadataEntity
implements Identification {
    private static final long serialVersionUID = -3715084806249419137L;
    private Citation citation;
    private InternationalString abstracts;
    private InternationalString purpose;
    private Collection credits;
    private Collection status;
    private Collection pointOfContacts;
    private Collection resourceMaintenance;
    private Collection graphicOverviews;
    private Collection resourceFormat;
    private Collection descriptiveKeywords;
    private Collection resourceSpecificUsages;
    private Collection resourceConstraints;
    private Collection aggregationInfo;

    public IdentificationImpl() {
    }

    public IdentificationImpl(Identification source) {
        super(source);
    }

    public IdentificationImpl(Citation citation, InternationalString abstracts) {
        this.setCitation(citation);
        this.setAbstract(abstracts);
    }

    public Citation getCitation() {
        return this.citation;
    }

    public synchronized void setCitation(Citation newValue) {
        this.checkWritePermission();
        this.citation = newValue;
    }

    public InternationalString getAbstract() {
        return this.abstracts;
    }

    public synchronized void setAbstract(InternationalString newValue) {
        this.checkWritePermission();
        this.abstracts = newValue;
    }

    public InternationalString getPurpose() {
        return this.purpose;
    }

    public synchronized void setPurpose(InternationalString newValue) {
        this.checkWritePermission();
        this.purpose = newValue;
    }

    public synchronized Collection getCredits() {
        this.credits = this.nonNullCollection(this.credits, String.class);
        return this.credits;
    }

    public synchronized void setCredits(Collection newValues) {
        this.credits = this.copyCollection(newValues, this.credits, String.class);
    }

    public synchronized Collection getStatus() {
        this.status = this.nonNullCollection(this.status, Progress.class);
        return this.status;
    }

    public synchronized void setStatus(Collection newValues) {
        this.status = this.copyCollection(newValues, this.status, Progress.class);
    }

    public synchronized Collection getPointOfContacts() {
        this.pointOfContacts = this.nonNullCollection(this.pointOfContacts, ResponsibleParty.class);
        return this.pointOfContacts;
    }

    public synchronized void setPointOfContacts(Collection newValues) {
        this.pointOfContacts = this.copyCollection(newValues, this.pointOfContacts, ResponsibleParty.class);
    }

    public synchronized Collection getResourceMaintenance() {
        this.resourceMaintenance = this.nonNullCollection(this.resourceMaintenance, MaintenanceInformation.class);
        return this.resourceMaintenance;
    }

    public synchronized void setResourceMaintenance(Collection newValues) {
        this.resourceMaintenance = this.copyCollection(newValues, this.resourceMaintenance, MaintenanceInformation.class);
    }

    public synchronized Collection getGraphicOverviews() {
        this.graphicOverviews = this.nonNullCollection(this.graphicOverviews, BrowseGraphic.class);
        return this.graphicOverviews;
    }

    public synchronized void setGraphicOverviews(Collection newValues) {
        this.graphicOverviews = this.copyCollection(newValues, this.graphicOverviews, BrowseGraphic.class);
    }

    public synchronized Collection getResourceFormat() {
        this.resourceFormat = this.nonNullCollection(this.resourceFormat, Format.class);
        return this.resourceFormat;
    }

    public synchronized void setResourceFormat(Collection newValues) {
        this.resourceFormat = this.copyCollection(newValues, this.resourceFormat, Format.class);
    }

    public synchronized Collection getDescriptiveKeywords() {
        this.descriptiveKeywords = this.nonNullCollection(this.descriptiveKeywords, Keywords.class);
        return this.descriptiveKeywords;
    }

    public synchronized void setDescriptiveKeywords(Collection newValues) {
        this.descriptiveKeywords = this.copyCollection(newValues, this.descriptiveKeywords, Keywords.class);
    }

    public synchronized Collection getResourceSpecificUsages() {
        this.resourceSpecificUsages = this.nonNullCollection(this.resourceSpecificUsages, Usage.class);
        return this.resourceSpecificUsages;
    }

    public synchronized void setResourceSpecificUsages(Collection newValues) {
        this.resourceSpecificUsages = this.copyCollection(newValues, this.resourceSpecificUsages, Usage.class);
    }

    public synchronized Collection getResourceConstraints() {
        this.resourceConstraints = this.nonNullCollection(this.resourceConstraints, Constraints.class);
        return this.resourceConstraints;
    }

    public synchronized void setResourceConstraints(Collection newValues) {
        this.resourceConstraints = this.copyCollection(newValues, this.resourceConstraints, Constraints.class);
    }

    public synchronized Collection getAggregationInfo() {
        this.aggregationInfo = this.nonNullCollection(this.aggregationInfo, AggregateInformation.class);
        return this.aggregationInfo;
    }

    public synchronized void setAggregationInfo(Collection newValues) {
        this.aggregationInfo = this.copyCollection(newValues, this.aggregationInfo, AggregateInformation.class);
    }
}

