/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.spi.ServiceRegistry;
import org.geotools.factory.FactoryNotFoundException;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;

public class FactoryCreator
extends FactoryRegistry {
    private static final Class[] HINTS_ARGUMENT = new Class[]{Hints.class};
    private final Map cache = new HashMap();
    private final Set underConstruction = new HashSet();

    public FactoryCreator(Collection categories) {
        super(categories);
    }

    final List getCachedProviders(Class category) {
        LinkedList c = (LinkedList)this.cache.get(category);
        if (c == null) {
            c = new LinkedList();
            this.cache.put(category, c);
        }
        return c;
    }

    private void cache(Class category, Object factory) {
        this.getCachedProviders(category).add(new WeakReference<Object>(factory));
    }

    public Object getServiceProvider(Class category, ServiceRegistry.Filter filter, Hints hints, Hints.Key key) throws FactoryRegistryException {
        try {
            return super.getServiceProvider(category, filter, hints, key);
        }
        catch (FactoryNotFoundException exception) {
            Class[] types;
            FactoryNotFoundException notFound = exception;
            if (hints == null || key == null) {
                types = null;
            } else {
                Object hint = hints.get(key);
                if (hint == null) {
                    types = null;
                } else {
                    types = hint instanceof Class[] ? (Class[])hint : new Class[]{(Class)hint};
                    int length = types.length;
                    for (int i = 0; i < length; ++i) {
                        Object candidate;
                        int modifiers;
                        Class type = types[i];
                        if (type == null || !category.isAssignableFrom(type) || Modifier.isAbstract(modifiers = type.getModifiers()) || (candidate = this.createSafe(category, type, hints)) == null) continue;
                        if (this.isAcceptable(candidate, category, hints, filter)) {
                            this.cache(category, candidate);
                            return candidate;
                        }
                        FactoryCreator.dispose(candidate);
                    }
                }
            }
            Iterator it = this.getUnfilteredProviders(category);
            while (it.hasNext()) {
                Object candidate;
                Object factory = it.next();
                Class<?> implementation = factory.getClass();
                if (types != null && !FactoryCreator.isTypeOf(types, implementation) || filter != null && !filter.filter(factory)) continue;
                try {
                    candidate = this.createSafe(category, implementation, hints);
                }
                catch (FactoryRegistryException exception2) {
                    if (exception2.getCause() instanceof NoSuchMethodException) continue;
                    throw exception2;
                }
                if (candidate == null) continue;
                if (this.isAcceptable(candidate, category, hints, filter)) {
                    this.cache(category, candidate);
                    return candidate;
                }
                FactoryCreator.dispose(candidate);
            }
            throw notFound;
        }
    }

    private static boolean isTypeOf(Class[] types, Class implementation) {
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].isAssignableFrom(implementation)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object createSafe(Class category, Class implementation, Hints hints) {
        if (!this.underConstruction.add(implementation)) {
            return null;
        }
        try {
            Object object = this.createServiceProvider(category, implementation, hints);
            return object;
        }
        finally {
            if (!this.underConstruction.remove(implementation)) {
                throw new AssertionError();
            }
        }
    }

    protected Object createServiceProvider(Class category, Class implementation, Hints hints) throws FactoryRegistryException {
        Throwable cause;
        block8: {
            try {
                try {
                    return implementation.getConstructor(HINTS_ARGUMENT).newInstance(hints);
                }
                catch (NoSuchMethodException exception) {
                    cause = exception;
                    try {
                        return implementation.getConstructor(null).newInstance(null);
                    }
                    catch (NoSuchMethodException exception2) {
                    }
                }
            }
            catch (IllegalAccessException exception) {
                cause = exception;
            }
            catch (InstantiationException exception) {
                cause = exception;
            }
            catch (InvocationTargetException exception) {
                cause = exception.getCause();
                if (!(cause instanceof FactoryRegistryException)) break block8;
                throw (FactoryRegistryException)cause;
            }
        }
        throw new FactoryRegistryException(Errors.format(184, Utilities.getShortName(implementation)), cause);
    }

    private static void dispose(Object factory) {
    }
}

