/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.fr;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public class ElisionFilter
extends TokenFilter {
    private Set articles = null;
    private static char[] apostrophes = new char[]{'\'', '\u2019'};

    public void setArticles(Set articles) {
        this.articles = new HashSet();
        Iterator iter = articles.iterator();
        while (iter.hasNext()) {
            this.articles.add(((String)iter.next()).toLowerCase());
        }
    }

    protected ElisionFilter(TokenStream input) {
        super(input);
        this.articles = new HashSet<String>(Arrays.asList("l", "m", "t", "qu", "n", "s", "j"));
    }

    public ElisionFilter(TokenStream input, Set articles) {
        super(input);
        this.setArticles(articles);
    }

    public ElisionFilter(TokenStream input, String[] articles) {
        super(input);
        this.setArticles(new HashSet<String>(Arrays.asList(articles)));
    }

    public Token next(Token reusableToken) throws IOException {
        assert (reusableToken != null);
        Token nextToken = this.input.next(reusableToken);
        if (nextToken == null) {
            return null;
        }
        char[] termBuffer = nextToken.termBuffer();
        int termLength = nextToken.termLength();
        int minPoz = Integer.MAX_VALUE;
        block0: for (int i = 0; i < apostrophes.length; ++i) {
            char apos = apostrophes[i];
            for (int poz = 0; poz < termLength; ++poz) {
                if (termBuffer[poz] != apos) continue;
                minPoz = Math.min(poz, minPoz);
                continue block0;
            }
        }
        if (minPoz != Integer.MAX_VALUE && this.articles.contains(new String(nextToken.termBuffer(), 0, minPoz).toLowerCase())) {
            nextToken.setTermBuffer(nextToken.termBuffer(), minPoz + 1, nextToken.termLength() - (minPoz + 1));
        }
        return nextToken;
    }
}

