/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml.producer;

import com.vividsolutions.jts.geom.Coordinate;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Locale;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class CoordinateWriter {
    private final String coordinateDelimiter;
    private final String tupleDelimiter;
    private final NumberFormat coordFormatter = NumberFormat.getInstance(Locale.US);
    private final AttributesImpl atts = new AttributesImpl();
    private final StringBuffer coordBuff = new StringBuffer();
    private final FieldPosition zero = new FieldPosition(0);
    private char[] buff = new char[200];
    private final boolean useDummyZ;
    private final double dummyZ;
    private boolean namespaceAware = true;
    private String prefix = "gml";
    private String namespaceUri = "http://www.opengis.net/gml";

    public CoordinateWriter() {
        this(4);
    }

    public CoordinateWriter(int numDecimals, boolean isDummyZEnabled) {
        this(numDecimals, " ", ",", isDummyZEnabled);
    }

    public CoordinateWriter(int numDecimals) {
        this(numDecimals, false);
    }

    public CoordinateWriter(int numDecimals, String tupleDelim, String coordDelim) {
        this(numDecimals, tupleDelim, coordDelim, false);
    }

    public CoordinateWriter(int numDecimals, String tupleDelim, String coordDelim, boolean isDummyZEnabled) {
        this(numDecimals, tupleDelim, coordDelim, isDummyZEnabled, 0.0);
    }

    public int getNumDecimals() {
        return this.coordFormatter.getMaximumFractionDigits();
    }

    public boolean isDummyZEnabled() {
        return this.useDummyZ;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setNamespaceUri(String namespaceUri) {
        this.namespaceUri = namespaceUri;
    }

    public CoordinateWriter(int numDecimals, String tupleDelim, String coordDelim, boolean useDummyZ, double zValue) {
        if (tupleDelim == null || tupleDelim.length() == 0) {
            throw new IllegalArgumentException("Tuple delimeter cannot be null or zero length");
        }
        if (coordDelim != null && coordDelim.length() == 0) {
            throw new IllegalArgumentException("Coordinate delimeter cannot be null or zero length");
        }
        this.tupleDelimiter = tupleDelim;
        this.coordinateDelimiter = coordDelim;
        this.coordFormatter.setMaximumFractionDigits(numDecimals);
        this.coordFormatter.setGroupingUsed(false);
        String uri = this.namespaceUri;
        if (!this.namespaceAware) {
            uri = null;
        }
        this.atts.addAttribute(uri, "decimal", "decimal", "decimal", ".");
        this.atts.addAttribute(uri, "cs", "cs", "cs", this.coordinateDelimiter);
        this.atts.addAttribute(uri, "ts", "ts", "ts", this.tupleDelimiter);
        this.useDummyZ = useDummyZ;
        this.dummyZ = zValue;
    }

    public void writeCoordinates(Coordinate[] c, ContentHandler output) throws SAXException {
        String prefix = this.prefix + ":";
        String namespaceUri = this.namespaceUri;
        if (!this.namespaceAware) {
            prefix = "";
            namespaceUri = null;
        }
        output.startElement(namespaceUri, "coordinates", prefix + "coordinates", this.atts);
        int n = c.length;
        for (int i = 0; i < n; ++i) {
            this.coordBuff.delete(0, this.coordBuff.length());
            this.coordFormatter.format(c[i].x, this.coordBuff, this.zero).append(this.coordinateDelimiter);
            if (this.useDummyZ) {
                this.coordFormatter.format(c[i].y, this.coordBuff, this.zero).append(this.coordinateDelimiter);
            } else {
                this.coordFormatter.format(c[i].y, this.coordBuff, this.zero);
            }
            if (this.useDummyZ) {
                this.coordFormatter.format(this.dummyZ, this.coordBuff, this.zero);
            }
            if (i + 1 < c.length) {
                this.coordBuff.append(this.tupleDelimiter);
            }
            if (this.coordBuff.length() > this.buff.length) {
                this.buff = new char[this.coordBuff.length()];
            }
            this.coordBuff.getChars(0, this.coordBuff.length(), this.buff, 0);
            output.characters(this.buff, 0, this.coordBuff.length());
        }
        output.endElement(namespaceUri, "coordinates", prefix + "coordinates");
    }
}

