/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.Hints;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessorFactory;
import org.geotools.filter.expression.SimpleFeaturePropertyAccessorFactory;

public class PropertyAccessors {
    static final List FACTORY_CACHE = new ArrayList();

    private PropertyAccessors() {
    }

    public static PropertyAccessor findPropertyAccessor(Object object, String xpath, Class target, Hints hints) {
        if (object == null) {
            return null;
        }
        for (PropertyAccessorFactory factory : FACTORY_CACHE) {
            PropertyAccessor accessor = factory.createPropertyAccessor(object.getClass(), xpath, target, hints);
            if (accessor == null || !accessor.canHandle(object, xpath, target)) continue;
            return accessor;
        }
        return null;
    }

    static {
        FACTORY_CACHE.add(new SimpleFeaturePropertyAccessorFactory());
        Iterator factories = FactoryRegistry.lookupProviders(PropertyAccessorFactory.class);
        while (factories.hasNext()) {
            Object factory = factories.next();
            if (factory instanceof SimpleFeaturePropertyAccessorFactory) continue;
            FACTORY_CACHE.add(factory);
        }
    }
}

