/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.geotools.feature.type.Descriptors;
import org.opengis.feature.Attribute;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.xml.ChoiceType;
import org.opengis.feature.xml.SequenceType;

class DescriptorValidator {
    private DescriptorValidator() {
    }

    public static void validate(AttributeDescriptor schema, List content) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        if (content == null) {
            throw new NullPointerException("content");
        }
        List allowedTypes = Descriptors.types(schema.getType());
        int index = 0;
        for (Attribute att : content) {
            DescriptorValidator.checkAttIsNotNull(index, att);
            DescriptorValidator.checkAttIsOfAllowedType(allowedTypes, index, att);
            ++index;
        }
        if (schema.getType() instanceof SequenceType) {
            DescriptorValidator.validateSequence(schema, content);
        } else if (schema.getType() instanceof ChoiceType) {
            DescriptorValidator.validateChoice(schema, content);
        } else if (schema.getType() instanceof ComplexType) {
            DescriptorValidator.validateAll(schema, content);
        } else {
            DescriptorValidator.validateNode(schema, content);
        }
    }

    private static void validateSequence(AttributeDescriptor schema, List content) {
        int max;
        int min;
        if (((List)((SequenceType)schema.getType()).attributes()).isEmpty()) {
            if (content.size() > 0) {
                throw new IllegalArgumentException("Sequence is empty, content not allowed");
            }
            return;
        }
        List descriptors = (List)((SequenceType)schema.getType()).attributes();
        List remaining = DescriptorValidator.processSequence(descriptors, content, min = schema.getMinOccurs(), max = schema.getMaxOccurs());
        if (remaining.size() > 0) {
            throw new IllegalArgumentException("Extra content found beyond the specified in the schema: " + remaining);
        }
    }

    private static void validateChoice(AttributeDescriptor choice, List content) {
        int max;
        int min;
        ChoiceType type = (ChoiceType)choice.getType();
        if (type.attributes().isEmpty()) {
            if (content.size() > 0) {
                throw new IllegalArgumentException("Choice is empty, content not allowed");
            }
            return;
        }
        Set descriptors = (Set)type.attributes();
        List remaining = DescriptorValidator.processChoice(descriptors, content, min = choice.getMinOccurs(), max = choice.getMaxOccurs());
        if (remaining.size() > 0) {
            throw new IllegalArgumentException("Extra content found beyond the specified in the schema: " + remaining);
        }
    }

    private static void validateAll(AttributeDescriptor all, List content) throws NullPointerException, IllegalArgumentException {
        if (content == null) {
            throw new NullPointerException("content");
        }
        ComplexType ctype = (ComplexType)all.getType();
        ArrayList<AttributeType> usedTypes = new ArrayList<AttributeType>();
        for (Attribute att : content) {
            AttributeType type = att.getType();
            if (usedTypes.contains(type)) {
                throw new IllegalArgumentException("Attribute of type " + type.getName() + " encountered more than once.");
            }
            usedTypes.add(type);
        }
        for (AttributeDescriptor node : ctype.attributes()) {
            int min = node.getMinOccurs();
            int max = node.getMaxOccurs();
            AttributeType expectedType = node.getType();
            if (max == 0 && usedTypes.contains(expectedType)) {
                throw new IllegalArgumentException(expectedType.getName() + " was fund, thus it is not allowed since maxOccurs is set to 0");
            }
            if (min != 1 || usedTypes.contains(expectedType)) continue;
            throw new IllegalArgumentException(expectedType.getName() + " was not fund, thus it have to since minOccurs is set to 1");
        }
    }

    private static List processDescriptor(AttributeDescriptor schema, List content) {
        int min = schema.getMinOccurs();
        int max = schema.getMaxOccurs();
        if (schema.getType() instanceof ChoiceType) {
            Set options = (Set)((ChoiceType)schema.getType()).attributes();
            return DescriptorValidator.processChoice(options, content, min, max);
        }
        if (schema.getType() instanceof SequenceType) {
            List sequence = (List)((SequenceType)schema.getType()).attributes();
            return DescriptorValidator.processSequence(sequence, content, min, max);
        }
        AttributeType type = schema.getType();
        return DescriptorValidator.processType(content, type, min, max);
    }

    private static List processSequence(List sequence, List content, int min, int max) {
        int count = 0;
        List remaining = content;
        do {
            for (AttributeDescriptor desc : sequence) {
                remaining = DescriptorValidator.processDescriptor(desc, remaining);
            }
        } while (count < max && ++count != max && remaining.size() != 0);
        return remaining;
    }

    private static List processChoice(Set allowableContent, List content, int min, int max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    private static List processType(List content, AttributeType expectedType, int min, int max) {
        Attribute att;
        AttributeType attType;
        int count = 0;
        Iterator itr = content.iterator();
        while (itr.hasNext() && (attType = (att = (Attribute)itr.next()).getType()).equals(expectedType) && ++count != max) {
        }
        if (count < min) {
            throw new IllegalArgumentException("got " + count + " occurrences of " + expectedType.getName() + ". Expected at least " + min);
        }
        if (count == 0) {
            return content;
        }
        return content.subList(count, content.size());
    }

    private static void validateNode(AttributeDescriptor schema, List content) {
    }

    private static void checkAttIsOfAllowedType(List allowedTypes, int index, Attribute att) throws IllegalArgumentException {
        AttributeType type = att.getType();
        if (!allowedTypes.contains(type)) {
            throw new IllegalArgumentException("Attribute of type " + type.getName() + " found at index " + index + " but this type is not allowed by this descriptor");
        }
    }

    private static void checkAttIsNotNull(int index, Attribute att) {
        if (att == null) {
            throw new NullPointerException("Attribute at index " + index + " is null. Attributes can't be null. Do you mean Attribute.get() == null?");
        }
    }
}

