/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.simple;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.geotools.feature.FeatureImpl;
import org.opengis.feature.Attribute;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;

public class SimpleFeatureImpl
extends FeatureImpl
implements SimpleFeature {
    public SimpleFeatureImpl(List properties, AttributeDescriptor desc, String id) {
        super((Collection)properties, desc, id);
    }

    public SimpleFeatureImpl(List properties, SimpleFeatureType type, String id) {
        super((Collection)properties, (FeatureType)type, id);
    }

    public Object getValue(String name) {
        for (Attribute att : this.properties) {
            AttributeType type = att.getType();
            String attName = type.getName().getLocalPart();
            if (!attName.equals(name)) continue;
            return att.getValue();
        }
        return null;
    }

    public Object getValue(AttributeType type) {
        if (!super.types().contains(type)) {
            throw new IllegalArgumentException("this feature content model has no type " + type);
        }
        for (Attribute att : this.properties) {
            if (!att.getType().equals(type)) continue;
            return att.getValue();
        }
        throw new Error();
    }

    public Object getValue(int index) {
        Attribute att = (Attribute)this.properties.get(index);
        return att == null ? null : att.getValue();
    }

    public void setValue(String name, Object value) {
        AttributeType type = ((SimpleFeatureType)this.getType()).getType(name);
        List types = this.types();
        int idx = types.indexOf(type);
        if (idx == -1) {
            throw new IllegalArgumentException(name + " is not a feature attribute");
        }
        this.setValue(idx, value);
    }

    public void setValue(int index, Object value) {
        List contents = (List)this.getValue();
        Attribute attribute = (Attribute)contents.get(index);
        attribute.setValue(value);
        this.setValue(contents);
    }

    public void setValues(List values) {
        for (int i = 0; i < values.size(); ++i) {
            this.setValue(i, values.get(i));
        }
    }

    public void setValues(Object[] values) {
        this.setValues(Arrays.asList(values));
    }

    public List getAttributes() {
        return this.attributes();
    }

    public int getNumberOfAttributes() {
        return this.types().size();
    }

    public List getTypes() {
        return super.types();
    }

    public List getValues() {
        return super.values();
    }

    public Object getDefaultGeometryValue() {
        return this.getDefaultGeometry() != null ? this.getDefaultGeometry().getValue() : null;
    }

    public void setDefaultGeometryValue(Object geometry) {
        if (this.getDefaultGeometry() != null) {
            this.getDefaultGeometry().setValue(geometry);
        }
    }

    public Object operation(String arg0, Object arg1) {
        throw new UnsupportedOperationException("operation not supported yet");
    }

    public void setValue(List values) {
        this.setValue((Object)values);
    }
}

