/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.geotools.data.collection.ResourceList;
import org.geotools.feature.collection.AbstractResourceList;

class SubList
extends AbstractResourceList
implements ResourceList {
    private AbstractResourceList l;
    private int offset;
    private int size;
    private int expectedModCount;

    SubList(AbstractResourceList list, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > list.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        this.l = list;
        this.offset = fromIndex;
        this.size = toIndex - fromIndex;
        this.expectedModCount = this.l.modCount;
    }

    public Object set(int index, Object element) {
        this.rangeCheck(index);
        this.checkForComodification();
        return this.l.set(index + this.offset, element);
    }

    public Object get(int index) {
        this.rangeCheck(index);
        this.checkForComodification();
        return this.l.get(index + this.offset);
    }

    public int size() {
        this.checkForComodification();
        return this.size;
    }

    public void add(int index, Object element) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.checkForComodification();
        this.l.add(index + this.offset, element);
        this.expectedModCount = this.l.modCount;
        ++this.size;
        ++this.modCount;
    }

    public Object remove(int index) {
        this.rangeCheck(index);
        this.checkForComodification();
        Object result = this.l.remove(index + this.offset);
        this.expectedModCount = this.l.modCount;
        --this.size;
        ++this.modCount;
        return result;
    }

    public void removeRange(int fromIndex, int toIndex) {
        this.checkForComodification();
        this.l.removeRange(fromIndex + this.offset, toIndex + this.offset);
        this.expectedModCount = this.l.modCount;
        this.size -= toIndex - fromIndex;
        ++this.modCount;
    }

    public boolean addAll(Collection c) {
        return this.addAll(this.size, c);
    }

    public boolean addAll(int index, Collection c) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        int cSize = c.size();
        if (cSize == 0) {
            return false;
        }
        this.checkForComodification();
        this.l.addAll(this.offset + index, c);
        this.expectedModCount = this.l.modCount;
        this.size += cSize;
        ++this.modCount;
        return true;
    }

    public void closeIterator(Iterator close) {
        SubListIterator it = (SubListIterator)close;
        this.l.close(it.i);
    }

    public void purge() {
        Iterator i = this.open.iterator();
        while (i.hasNext()) {
            SubListIterator it = (SubListIterator)i.next();
            this.l.close(it.i);
            i.remove();
        }
    }

    public ListIterator listIterator(int index) {
        this.checkForComodification();
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        SubListIterator listIterator = new SubListIterator(index);
        this.open.add(listIterator);
        return listIterator;
    }

    public List subList(int fromIndex, int toIndex) {
        return new SubList(this, fromIndex, toIndex);
    }

    private void rangeCheck(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ",Size: " + this.size);
        }
    }

    private void checkForComodification() {
        if (this.l.modCount != this.expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }

    private final class SubListIterator
    implements ListIterator {
        private ListIterator i;

        private SubListIterator(int index) {
            this.i = SubList.this.l.listIterator(index + SubList.this.offset);
            this.i = SubList.this.l.listIterator(index + SubList.this.offset);
        }

        public boolean hasNext() {
            return this.nextIndex() < SubList.this.size;
        }

        public Object next() {
            if (this.hasNext()) {
                return this.i.next();
            }
            throw new NoSuchElementException();
        }

        public boolean hasPrevious() {
            return this.previousIndex() >= 0;
        }

        public Object previous() {
            if (this.hasPrevious()) {
                return this.i.previous();
            }
            throw new NoSuchElementException();
        }

        public int nextIndex() {
            return this.i.nextIndex() - SubList.this.offset;
        }

        public int previousIndex() {
            return this.i.previousIndex() - SubList.this.offset;
        }

        public void remove() {
            this.i.remove();
            SubList.this.expectedModCount = ((SubList)SubList.this).l.modCount;
            SubList.this.size--;
            ++SubList.this.modCount;
        }

        public void set(Object o) {
            this.i.set(o);
        }

        public void add(Object o) {
            this.i.add(o);
            SubList.this.expectedModCount = ((SubList)SubList.this).l.modCount;
            SubList.this.size++;
            ++SubList.this.modCount;
        }
    }
}

