/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureType;
import org.geotools.feature.collection.AbstractResourceCollection;
import org.geotools.feature.collection.BaseFeatureCollection;
import org.geotools.feature.collection.DelegateFeatureIterator;
import org.geotools.feature.collection.SubFeatureCollection;
import org.geotools.feature.collection.SubFeatureList;
import org.opengis.feature.FeatureVisitor;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.util.ProgressListener;

public abstract class AbstractFeatureCollection
extends BaseFeatureCollection
implements FeatureCollection {
    AbstractResourceCollection rc;

    protected AbstractFeatureCollection(FeatureType memberType) {
        super(null, memberType);
    }

    protected AbstractFeatureCollection(FeatureType memberType, AbstractResourceCollection rc) {
        super(null, memberType);
        this.rc = rc;
    }

    protected void setResourceCollection(AbstractResourceCollection rc) {
        this.rc = rc;
    }

    public FeatureIterator features() {
        DelegateFeatureIterator iter = new DelegateFeatureIterator(this, this.rc.openIterator());
        this.rc.getOpenIterators().add(iter);
        return iter;
    }

    public void close(FeatureIterator close) {
        this.closeIterator(close);
        this.rc.getOpenIterators().remove(close);
    }

    public void closeIterator(FeatureIterator close) {
        DelegateFeatureIterator iter = (DelegateFeatureIterator)close;
        this.rc.closeIterator(iter.delegate);
        iter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        Iterator i = this.rc.getOpenIterators().iterator();
        while (i.hasNext()) {
            Object resource = i.next();
            if (!(resource instanceof FeatureIterator)) continue;
            FeatureIterator resourceIterator = (FeatureIterator)resource;
            try {
                this.closeIterator(resourceIterator);
            }
            catch (Throwable e) {}
            continue;
            finally {
                i.remove();
            }
        }
        this.rc.purge();
    }

    public final int size() {
        return this.rc.size();
    }

    public final Iterator iterator() {
        return this.rc.iterator();
    }

    public final void close(Iterator close) {
        this.rc.close(close);
    }

    public final boolean add(Object o) {
        return this.rc.add(o);
    }

    public final boolean addAll(Collection c) {
        return this.rc.addAll(c);
    }

    public final void clear() {
        this.rc.clear();
    }

    public final boolean contains(Object o) {
        return this.rc.contains(o);
    }

    public final boolean containsAll(Collection c) {
        return this.rc.containsAll(c);
    }

    public final boolean isEmpty() {
        return this.rc.isEmpty();
    }

    public final boolean remove(Object o) {
        return this.rc.remove(o);
    }

    public final boolean removeAll(Collection c) {
        return this.rc.removeAll(c);
    }

    public final boolean retainAll(Collection c) {
        return this.rc.retainAll(c);
    }

    public final Object[] toArray() {
        return this.rc.toArray();
    }

    public final Object[] toArray(Object[] a) {
        return this.rc.toArray(a);
    }

    public final void accepts(org.geotools.feature.visitor.FeatureVisitor visitor, org.geotools.util.ProgressListener progress) throws IOException {
        this.accepts((FeatureVisitor)visitor, (ProgressListener)progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accepts(FeatureVisitor visitor, ProgressListener progress) {
        Iterator iterator = null;
        try {
            float size = this.size();
            float position = 0.0f;
            progress.started();
            iterator = this.iterator();
            while (!progress.isCanceled() && iterator.hasNext()) {
                if (size > 0.0f) {
                    float f = position;
                    position = f + 1.0f;
                    progress.progress(f / size);
                }
                try {
                    Feature feature = (Feature)iterator.next();
                    visitor.visit((org.opengis.feature.Feature)feature);
                }
                catch (Exception erp) {
                    progress.exceptionOccurred((Throwable)erp);
                }
            }
        }
        catch (Throwable throwable) {
            progress.complete();
            this.close(iterator);
            throw throwable;
        }
        progress.complete();
        this.close(iterator);
    }

    public FeatureCollection subList(Filter filter) {
        return new SubFeatureList((FeatureCollection)this, filter);
    }

    public FeatureCollection subCollection(Filter filter) {
        if (filter == Filter.INCLUDE) {
            return this;
        }
        return new SubFeatureCollection(this, filter);
    }

    public FeatureCollection sort(SortBy order) {
        return new SubFeatureList((FeatureCollection)this, order);
    }
}

