/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.HashSet;
import java.util.Set;
import org.geotools.feature.type.TypeFactoryImpl;
import org.geotools.feature.type.TypeName;
import org.geotools.util.SimpleInternationalString;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.TypeFactory;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.InternationalString;

public class AttributeTypeBuilder {
    protected TypeFactory factory;
    protected String name;
    protected String namespaceURI;
    protected boolean isAbstract = false;
    protected Set restrictions;
    protected String description;
    protected boolean isIdentifiable = false;
    protected Class binding;
    protected AttributeType superType;
    protected Object defaultValue;
    protected CoordinateReferenceSystem crs;
    protected int minOccurs = 1;
    protected int maxOccurs = 1;
    protected boolean isNillable = true;

    public AttributeTypeBuilder() {
        this(new TypeFactoryImpl());
    }

    public AttributeTypeBuilder(TypeFactory factory) {
        this.factory = factory;
    }

    protected void resetTypeState() {
        this.name = null;
        this.namespaceURI = null;
        this.isAbstract = false;
        this.restrictions = null;
        this.description = null;
        this.isIdentifiable = false;
        this.binding = null;
        this.superType = null;
        this.crs = null;
    }

    protected void resetDescriptorState() {
        this.minOccurs = 1;
        this.maxOccurs = 1;
        this.isNillable = true;
    }

    public void setFactory(TypeFactory factory) {
        this.factory = factory;
    }

    public void init(AttributeType type) {
        this.name = type.getName().getLocalPart();
        this.namespaceURI = type.getName().getNamespaceURI();
        this.isAbstract = type.isAbstract();
        if (type.getRestrictions() != null) {
            this.restrictions().addAll(type.getRestrictions());
        }
        this.description = type.getDescription() != null ? type.getDescription().toString() : null;
        this.isIdentifiable = type.isIdentified();
        this.binding = type.getBinding();
        this.superType = type.getSuper();
        if (type instanceof GeometryType) {
            this.crs = ((GeometryType)type).getCRS();
        }
    }

    public void init(AttributeDescriptor descriptor) {
        this.init(descriptor.getType());
        this.minOccurs = descriptor.getMinOccurs();
        this.maxOccurs = descriptor.getMaxOccurs();
        this.isNillable = descriptor.isNillable();
    }

    public void setBinding(Class binding) {
        this.binding = binding;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }

    public void setCRS(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public void setIdentifiable(boolean isIdentifiable) {
        this.isIdentifiable = isIdentifiable;
    }

    public void addRestriction(Filter restriction) {
        this.restrictions().add(restriction);
    }

    public void setNillable(boolean isNillable) {
        this.isNillable = isNillable;
    }

    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public AttributeType buildType() {
        AttributeType type = this.factory.createAttributeType((Name)new TypeName(this.namespaceURI, this.name), this.binding, this.isIdentifiable, this.isAbstract, this.restrictions, this.superType, (InternationalString)(this.description != null ? new SimpleInternationalString(this.description) : null));
        this.resetTypeState();
        return type;
    }

    public GeometryType buildGeometryType() {
        GeometryType type = this.factory.createGeometryType((Name)new TypeName(this.namespaceURI, this.name), this.binding, this.crs, this.isIdentifiable, this.isAbstract, this.restrictions, this.superType, (InternationalString)(this.description != null ? new SimpleInternationalString(this.description) : null));
        this.resetTypeState();
        return type;
    }

    public AttributeDescriptor buildDescriptor(String name) {
        if (this.crs != null) {
            return this.buildDescriptor(name, (AttributeType)this.buildGeometryType());
        }
        return this.buildDescriptor(name, this.buildType());
    }

    public AttributeDescriptor buildDescriptor(String name, AttributeType type) {
        return this.buildDescriptor((Name)new TypeName(name), type);
    }

    public AttributeDescriptor buildDescriptor(Name name, AttributeType type) {
        AttributeDescriptor descriptor = this.factory.createAttributeDescriptor(type, name, this.minOccurs, this.maxOccurs, this.isNillable, this.defaultValue);
        this.resetDescriptorState();
        return descriptor;
    }

    protected Set restrictions() {
        if (this.restrictions == null) {
            this.restrictions = this.newSet();
        }
        return this.restrictions;
    }

    protected Set newSet() {
        return new HashSet();
    }
}

