/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.geotools.data.FeatureReader;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.data.store.ReprojectingIterator;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.geotools.feature.collection.DecoratingFeatureCollection;
import org.geotools.feature.collection.DelegateFeatureIterator;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class ReprojectingFeatureCollection
extends DecoratingFeatureCollection
implements FeatureCollection {
    FeatureCollection delegate;
    MathTransform transform;
    FeatureType schema;
    FeatureType featureType;
    CoordinateReferenceSystem target;
    GeometryCoordinateSequenceTransformer transformer;

    public ReprojectingFeatureCollection(FeatureCollection delegate, CoordinateReferenceSystem target) {
        this(delegate, delegate.getSchema().getPrimaryGeometry().getCoordinateSystem(), target);
    }

    public ReprojectingFeatureCollection(FeatureCollection delegate, CoordinateReferenceSystem source, CoordinateReferenceSystem target) {
        super(delegate);
        this.delegate = delegate;
        this.target = target;
        FeatureType schema = delegate.getSchema();
        this.schema = this.reType(schema, target);
        FeatureType featureType = delegate.getFeatureType();
        this.featureType = this.reType(featureType, target);
        if (source == null) {
            throw new NullPointerException("source crs");
        }
        if (target == null) {
            throw new NullPointerException("destination crs");
        }
        this.transform = this.transform(source, target);
        this.transformer = new GeometryCoordinateSequenceTransformer();
    }

    public void setTransformer(GeometryCoordinateSequenceTransformer transformer) {
        this.transformer = transformer;
    }

    private MathTransform transform(CoordinateReferenceSystem source, CoordinateReferenceSystem target) {
        try {
            return CRS.findMathTransform((CoordinateReferenceSystem)source, (CoordinateReferenceSystem)target);
        }
        catch (FactoryException e) {
            throw new IllegalArgumentException("Could not create math transform");
        }
    }

    private FeatureType reType(FeatureType type, CoordinateReferenceSystem target) {
        try {
            return FeatureTypes.transform(type, target);
        }
        catch (SchemaException e) {
            throw new IllegalArgumentException("Could not transform source schema", e);
        }
    }

    public FeatureReader reader() throws IOException {
        return new DelegateFeatureReader(this.getSchema(), this.features());
    }

    public FeatureIterator features() {
        return new DelegateFeatureIterator(this, this.iterator());
    }

    public void close(FeatureIterator close) {
        close.close();
    }

    public Iterator iterator() {
        try {
            return new ReprojectingIterator(this.delegate.iterator(), this.transform, this.schema, this.transformer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close(Iterator close) {
        Iterator iterator = ((ReprojectingIterator)close).getDelegate();
        this.delegate.close(iterator);
    }

    public FeatureType getFeatureType() {
        return this.featureType;
    }

    public FeatureType getSchema() {
        return this.schema;
    }

    public FeatureCollection subCollection(Filter filter) {
        Filter unFilter = this.unFilter(filter);
        return new ReprojectingFeatureCollection(this.delegate.subCollection(unFilter), this.target);
    }

    private Filter unFilter(Filter filter) {
        return filter;
    }

    public FeatureCollection sort(SortBy order) {
        throw new UnsupportedOperationException("Not yet");
    }

    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] a) {
        ArrayList list = new ArrayList();
        Iterator i = this.iterator();
        try {
            while (i.hasNext()) {
                list.add(i.next());
            }
            Object[] objectArray = list.toArray(a);
            return objectArray;
        }
        finally {
            this.close(i);
        }
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException("Not yet");
    }

    public ReferencedEnvelope getBounds() {
        FeatureIterator r = this.features();
        try {
            Envelope newBBox = new Envelope();
            while (r.hasNext()) {
                Feature feature = r.next();
                Envelope internal = feature.getPrimaryGeometry().getEnvelopeInternal();
                newBBox.expandToInclude(internal);
            }
            ReferencedEnvelope referencedEnvelope = ReferencedEnvelope.reference((Envelope)newBBox);
            return referencedEnvelope;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception occurred while computing reprojected bounds", e);
        }
        finally {
            r.close();
        }
    }
}

